/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.utils;

import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpHeaders;
import io.clientcore.core.implementation.utils.AuthenticateChallengeParser;
import io.clientcore.core.utils.AuthenticateChallenge;
import io.clientcore.core.utils.CoreUtils;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class AuthUtils {
    static final String SESS = "-SESS";
    static final String MD5 = "MD5";
    static final String SHA_512_256 = "SHA-512-256";
    static final String ALGORITHM = "algorithm";
    static final String NEXT_NONCE = "nextnonce";
    static final String BASIC = "Basic";
    static final String DIGEST = "Digest";

    private AuthUtils() {
    }

    public static List<AuthenticateChallenge> parseAuthenticateHeader(String authenticateHeader) {
        if (CoreUtils.isNullOrEmpty(authenticateHeader)) {
            return Collections.emptyList();
        }
        return new AuthenticateChallengeParser(authenticateHeader).parse();
    }

    static String calculateHa1NoSess(Function<byte[], byte[]> digestFunction, String username, String realm, String password) {
        return AuthUtils.bytesToHexString(digestFunction.apply((username + ":" + realm + ":" + password).getBytes(StandardCharsets.UTF_8)));
    }

    static String calculateHa1Sess(Function<byte[], byte[]> digestFunction, String username, String realm, String password, String nonce, String cnonce) {
        String ha1NoSess = AuthUtils.calculateHa1NoSess(digestFunction, username, realm, password);
        return AuthUtils.bytesToHexString(digestFunction.apply((ha1NoSess + ":" + nonce + ":" + cnonce).getBytes(StandardCharsets.UTF_8)));
    }

    static String calculateHa2AuthQopOrEmpty(Function<byte[], byte[]> digestFunction, String httpMethod, String uri) {
        return AuthUtils.bytesToHexString(digestFunction.apply((httpMethod + ":" + uri).getBytes(StandardCharsets.UTF_8)));
    }

    static String calculateHa2AuthIntQop(Function<byte[], byte[]> digestFunction, String httpMethod, String uri, byte[] requestEntityBody) {
        String bodyHex = AuthUtils.bytesToHexString(digestFunction.apply(requestEntityBody));
        return AuthUtils.bytesToHexString(digestFunction.apply((httpMethod + ":" + uri + ":" + bodyHex).getBytes(StandardCharsets.UTF_8)));
    }

    static String calculateResponseUnknownQop(Function<byte[], byte[]> digestFunction, String ha1, String nonce, String ha2) {
        return AuthUtils.bytesToHexString(digestFunction.apply((ha1 + ":" + nonce + ":" + ha2).getBytes(StandardCharsets.UTF_8)));
    }

    static String calculateResponseKnownQop(Function<byte[], byte[]> digestFunction, String ha1, String nonce, int nc, String cnonce, String qop, String ha2) {
        String zeroPadNc = String.format("%08X", nc);
        return AuthUtils.bytesToHexString(digestFunction.apply((ha1 + ":" + nonce + ":" + zeroPadNc + ":" + cnonce + ":" + qop + ":" + ha2).getBytes(StandardCharsets.UTF_8)));
    }

    static String calculateUserhash(Function<byte[], byte[]> digestFunction, String username, String realm) {
        return AuthUtils.bytesToHexString(digestFunction.apply((username + ":" + realm).getBytes(StandardCharsets.UTF_8)));
    }

    static Function<byte[], byte[]> getDigestFunction(String algorithm) {
        if (algorithm.toUpperCase(Locale.ROOT).endsWith(SESS)) {
            algorithm = algorithm.substring(0, algorithm.length() - SESS.length());
        }
        try {
            if (SHA_512_256.equals(algorithm)) {
                MessageDigest digest = MessageDigest.getInstance("SHA-512");
                return bytes -> Arrays.copyOf(digest.digest((byte[])bytes), 32);
            }
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            return digest::digest;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    static String bytesToHexString(byte[] bytes) {
        StringBuilder hexString = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    static String processAuthenticationInfoHeader(Map<String, String> authenticationInfoMap) {
        if (authenticationInfoMap == null || authenticationInfoMap.isEmpty()) {
            return null;
        }
        if (authenticationInfoMap.containsKey(NEXT_NONCE)) {
            return authenticationInfoMap.get(NEXT_NONCE);
        }
        return null;
    }

    public static Map<String, String> parseAuthenticationOrAuthorizationHeader(String header) {
        if (header == null || header.isEmpty()) {
            return Collections.emptyMap();
        }
        if (header.startsWith(BASIC) || header.startsWith(DIGEST)) {
            header = header.split(" ", 2)[1];
        }
        return Arrays.stream(header.split(",")).map(String::trim).map(kvp -> kvp.split("=", 2)).collect(Collectors.toMap(kvpPieces -> kvpPieces[0].toLowerCase(Locale.ROOT), kvpPieces -> kvpPieces[1].replace("\"", "")));
    }

    static Map<String, List<Map<String, String>>> partitionByChallengeType(HttpHeaders headers) {
        List<Map<String, String>> challenges = AuthUtils.extractAllChallenges(headers);
        return challenges.stream().collect(Collectors.groupingBy(challenge -> {
            String algorithmHeader = (String)challenge.get(ALGORITHM);
            return algorithmHeader == null ? MD5 : algorithmHeader.toUpperCase(Locale.ROOT);
        }));
    }

    static List<Map<String, String>> parseChallenges(HttpHeaders headers) {
        ArrayList<String> authenticateHeaders = new ArrayList<String>();
        if (headers.getValue(HttpHeaderName.WWW_AUTHENTICATE) != null) {
            authenticateHeaders.addAll(headers.getValues(HttpHeaderName.WWW_AUTHENTICATE));
        }
        if (headers.getValue(HttpHeaderName.PROXY_AUTHENTICATE) != null) {
            authenticateHeaders.addAll(headers.getValues(HttpHeaderName.PROXY_AUTHENTICATE));
        }
        if (authenticateHeaders.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> challenges = new ArrayList<Map<String, String>>();
        for (String header : authenticateHeaders) {
            challenges.add(AuthUtils.parseChallenge(header));
        }
        return challenges;
    }

    static List<Map<String, String>> extractAllChallenges(HttpHeaders headers) {
        ArrayList<Map<String, String>> challenges = new ArrayList<Map<String, String>>();
        headers.stream().filter(header -> header.getName().toString().toLowerCase().endsWith("authenticate")).forEach(authHeader -> {
            HttpHeaders singleHeader = new HttpHeaders().set(authHeader.getName(), authHeader.getValue());
            challenges.addAll(AuthUtils.parseChallenges(singleHeader));
        });
        return challenges;
    }

    static Map<String, String> parseChallenge(String challengeHeader) {
        String[] paramPairs;
        HashMap<String, String> challengeMap = new HashMap<String, String>();
        int firstSpaceIndex = challengeHeader.indexOf(32);
        if (firstSpaceIndex == -1) {
            challengeMap.put("scheme", challengeHeader.trim());
            return challengeMap;
        }
        String scheme = challengeHeader.substring(0, firstSpaceIndex).trim();
        challengeMap.put("scheme", scheme);
        String params = challengeHeader.substring(firstSpaceIndex + 1).trim();
        for (String pair : paramPairs = params.split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)")) {
            String[] keyValue = pair.split("=", 2);
            if (keyValue.length != 2) continue;
            String key = keyValue[0].replace("{", "").replace("}", "").trim();
            String value = keyValue[1].replace("{", "").replace("}", "").replace("\"", "").trim();
            if (value.endsWith("}")) {
                value = value.substring(0, value.length() - 1).trim();
            }
            challengeMap.put(key, value);
        }
        return challengeMap;
    }

    static String extractValue(String authHeader, String key) {
        String[] headerParts;
        if (authHeader == null || !authHeader.startsWith(DIGEST)) {
            return null;
        }
        for (String part : headerParts = authHeader.split(",")) {
            String headerKey;
            String[] keyValue = part.trim().split("=", 2);
            if (keyValue.length != 2 || !(headerKey = keyValue[0].replace(DIGEST, "").replace("{", "").replace("}", "").trim()).equalsIgnoreCase(key)) continue;
            String value = keyValue[1].replace("{", "").replace("}", "").replace("\"", "").trim();
            if (value.endsWith("}")) {
                value = value.substring(0, value.length() - 1).trim();
            }
            return value;
        }
        return null;
    }

    static String buildAuthorizationHeader(String username, String realm, String uri, String algorithm, String nonce, int nc, String cnonce, String qop, String response, String opaque, boolean userhash) {
        StringBuilder authorizationBuilder = new StringBuilder(512);
        authorizationBuilder.append("Digest ").append("username=\"").append(username).append("\", ").append("realm=\"").append(realm).append("\", ").append("nonce=\"").append(nonce).append("\", ").append("uri=\"").append(uri).append("\", ").append("response=\"").append(response).append("\"");
        if (!CoreUtils.isNullOrEmpty(algorithm)) {
            authorizationBuilder.append(", algorithm=").append(algorithm);
        }
        if (!CoreUtils.isNullOrEmpty(cnonce)) {
            authorizationBuilder.append(", cnonce=\"").append(cnonce).append("\"");
        }
        if (!CoreUtils.isNullOrEmpty(opaque)) {
            authorizationBuilder.append(", opaque=\"").append(opaque).append("\"");
        }
        if (!CoreUtils.isNullOrEmpty(qop)) {
            authorizationBuilder.append(", qop=").append(qop);
            authorizationBuilder.append(", nc=").append(String.format("%08X", nc));
        }
        if (userhash) {
            authorizationBuilder.append(", userhash=true");
        }
        return authorizationBuilder.toString();
    }
}

