/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.xml.implementation.aalto.out;

import io.clientcore.core.serialization.xml.implementation.aalto.impl.ErrorConsts;
import io.clientcore.core.serialization.xml.implementation.aalto.impl.StreamExceptionBase;
import io.clientcore.core.serialization.xml.implementation.aalto.out.OutputCharTypes;
import io.clientcore.core.serialization.xml.implementation.aalto.out.WName;
import io.clientcore.core.serialization.xml.implementation.aalto.util.XmlCharTypes;
import io.clientcore.core.serialization.xml.implementation.aalto.util.XmlChars;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import javax.xml.stream.XMLStreamException;

public final class CharXmlWriter {
    private static final int SURR1_FIRST = 55296;
    private static final int SURR2_LAST = 57343;
    static final int DEFAULT_FULL_BUFFER_SIZE = 1000;
    private int _locPastChars = 0;
    private int _locRowStartOffset = 0;
    private final Writer _out;
    private final char[] _outputBuffer;
    private int _outputPtr;
    private final int _outputBufferLen;
    private final int mEncHighChar = 65534;
    private final int mTableCheckEnd = 256;
    final XmlCharTypes mCharTypes = OutputCharTypes.getLatin1CharTypes();

    public CharXmlWriter(Writer out) {
        this._out = out;
        this._outputBuffer = new char[1000];
        this._outputBufferLen = this._outputBuffer.length;
        this._outputPtr = 0;
    }

    private int getOutputPtr() {
        return this._outputPtr;
    }

    public WName constructName(String localName) {
        return new WName(localName);
    }

    public WName constructName(String prefix, String localName) {
        return new WName(prefix, localName);
    }

    public void close() throws IOException {
        this.flush();
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this._out.flush();
    }

    public void writeRaw(String str, int offset, int len) throws IOException {
        if (len < this._outputBufferLen) {
            if (this._outputPtr + len >= this._outputBufferLen) {
                this.flushBuffer();
            }
            str.getChars(offset, offset + len, this._outputBuffer, this._outputPtr);
            this._outputPtr += len;
            return;
        }
        int ptr = this._outputPtr;
        if (ptr > 0) {
            if (ptr < this._outputBufferLen) {
                int needed = this._outputBufferLen - ptr;
                str.getChars(offset, offset + needed, this._outputBuffer, ptr);
                this._outputPtr = ptr + needed;
                len -= needed;
                offset += needed;
            }
            this.flushBuffer();
        }
        this._out.write(str, offset, len);
    }

    public void writeCDataStart() throws IOException {
        this.fastWriteRaw("<![CDATA[");
    }

    public void writeCDataEnd() throws IOException {
        this.fastWriteRaw("]]>");
    }

    public int writeCData(String data) throws IOException, XMLStreamException {
        int len2;
        this.writeCDataStart();
        int offset = 0;
        for (int len = data.length(); len > 0; len -= len2) {
            len2 = Math.min(len, this._outputBufferLen - this._outputPtr);
            int cix = this.writeCDataContents(data, offset, len2);
            if (cix >= 0) {
                return offset + cix;
            }
            offset += len2;
        }
        this.writeCDataEnd();
        return -1;
    }

    private int writeCDataContents(String data, int offset, int len) throws IOException, XMLStreamException {
        len += offset;
        int start = offset;
        block6: while (offset < len) {
            char ch;
            int[] charTypes = this.mCharTypes.OTHER_CHARS;
            int limit = 256;
            while ((ch = data.charAt(offset)) < '\u0100' && charTypes[ch] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = ch;
                if (++offset < len) continue;
                break block6;
            }
            if ((ch = data.charAt(offset++)) < '\u0100') {
                switch (charTypes[ch]) {
                    case 1: {
                        this.reportInvalidChar(ch);
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping(ch);
                    }
                    case 17: {
                        if (offset - start < 3 || data.charAt(offset - 2) != ']' || data.charAt(offset - 3) != ']') break;
                        --offset;
                        this.writeCDataEnd();
                        this.writeCDataStart();
                    }
                }
            } else if (ch >= '\ufffe') {
                this.reportFailedEscaping(ch);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = ch;
        }
        return -1;
    }

    public void writeCharacters(String text) throws IOException, XMLStreamException {
        int len2;
        int offset = 0;
        for (int len = text.length(); len > 0; len -= len2) {
            len2 = Math.min(len, this._outputBufferLen - this._outputPtr);
            this.writeCharacters(text, offset, len2);
            offset += len2;
        }
    }

    public void writeCharacters(CharSequence text, int offset, int len) throws IOException, XMLStreamException {
        len += offset;
        block6: while (offset < len) {
            char ch;
            int[] charTypes = this.mCharTypes.TEXT_CHARS;
            int limit = 256;
            while ((ch = text.charAt(offset)) < '\u0100' && charTypes[ch] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = ch;
                if (++offset < len) continue;
                break block6;
            }
            if ((ch = text.charAt(offset++)) < '\u0100') {
                switch (charTypes[ch]) {
                    case 1: {
                        this.reportInvalidChar(ch);
                    }
                    case 11: {
                        if (offset < len && text.charAt(offset) != '>') break;
                    }
                    case 4: 
                    case 9: 
                    case 10: {
                        this.writeAsEntity(ch);
                        continue block6;
                    }
                    case 2: {
                        this.writeAsEntity(ch);
                        continue block6;
                    }
                }
            } else if (ch >= '\ufffe') {
                this.writeAsEntity(ch);
                continue;
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = ch;
        }
    }

    public void writeSpace(String data) throws IOException, XMLStreamException {
        int len2;
        int offset = 0;
        for (int len = data.length(); len > 0; len -= len2) {
            len2 = Math.min(len, this._outputBufferLen - this._outputPtr);
            this.writeSpace(data, offset, len2);
            offset += len2;
        }
    }

    public void writeSpace(CharSequence data, int offset, int len) throws IOException, XMLStreamException {
        len += offset;
        while (offset < len) {
            char ch;
            if ((ch = data.charAt(offset++)) > ' ') {
                this.throwOutputError(MessageFormat.format(ErrorConsts.WERR_SPACE_CONTENT, ch, offset - 1));
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = ch;
        }
    }

    public void writeXmlDeclaration() throws IOException {
        this.fastWriteRaw("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    public void writeStartTagStart(WName name) throws IOException {
        int ptr = this._outputPtr;
        int len = name.serializedLength();
        if (ptr + len + 1 > this._outputBufferLen) {
            this.flushBuffer();
            if (len >= this._outputBufferLen) {
                this._out.write(60);
                name.writeChars(this._out);
                return;
            }
            ptr = this._outputPtr;
        }
        char[] buf = this._outputBuffer;
        buf[ptr++] = 60;
        name.appendChars(buf, ptr);
        this._outputPtr = ptr + len;
    }

    public void writeStartTagEnd() throws IOException {
        this.fastWriteRaw('>');
    }

    public void writeStartTagEmptyEnd() throws IOException {
        int ptr = this._outputPtr;
        if (ptr + 2 > this._outputBufferLen) {
            this.flushBuffer();
            ptr = this._outputPtr;
        }
        char[] buf = this._outputBuffer;
        buf[ptr++] = 47;
        buf[ptr++] = 62;
        this._outputPtr = ptr;
    }

    public void writeEndTag(WName name) throws IOException {
        int ptr = this._outputPtr;
        int len = name.serializedLength();
        if (ptr + len + 3 > this._outputBufferLen) {
            this.flushBuffer();
            if (len + 3 > this._outputBufferLen) {
                this._out.write(60);
                this._out.write(47);
                name.writeChars(this._out);
                this._outputBuffer[this._outputPtr++] = 62;
                return;
            }
            ptr = this._outputPtr;
        }
        char[] buf = this._outputBuffer;
        buf[ptr++] = 60;
        buf[ptr++] = 47;
        name.appendChars(buf, ptr);
        ptr += len;
        buf[ptr++] = 62;
        this._outputPtr = ptr;
    }

    public void writeAttribute(WName name, String value) throws IOException, XMLStreamException {
        int len;
        this.fastWriteRaw(' ');
        this.writeName(name);
        this.fastWriteRaw();
        int n = len = value == null ? 0 : value.length();
        if (len > 0) {
            this.writeAttrValue(value, len);
        }
        this.fastWriteRaw('\"');
    }

    private void writeAttrValue(String value, int len) throws IOException, XMLStreamException {
        int offset = 0;
        while (len > 0) {
            int len2 = Math.min(len, this._outputBufferLen - this._outputPtr);
            this.writeAttrValue(value, offset, len2);
            offset += len2;
            len -= len2;
        }
    }

    private void writeAttrValue(String value, int offset, int len) throws IOException, XMLStreamException {
        len += offset;
        block5: while (offset < len) {
            char ch;
            block9: {
                block8: {
                    int[] charTypes = this.mCharTypes.ATTR_CHARS;
                    int limit = 256;
                    while ((ch = value.charAt(offset)) < '\u0100' && charTypes[ch] == 0) {
                        this._outputBuffer[this._outputPtr++] = ch;
                        if (++offset < len) continue;
                        break block5;
                    }
                    if ((ch = value.charAt(offset++)) >= '\u0100') break block8;
                    switch (charTypes[ch]) {
                        case 1: {
                            this.reportInvalidChar(ch);
                        }
                        case 4: 
                        case 9: 
                        case 10: 
                        case 14: {
                            break block9;
                        }
                        case 2: 
                        case 3: {
                            break block9;
                        }
                        default: {
                            this._outputBuffer[this._outputPtr++] = ch;
                            break;
                        }
                    }
                    continue;
                }
                if (ch < '\ufffe') {
                    this._outputBuffer[this._outputPtr++] = ch;
                    continue;
                }
            }
            this.writeAsEntity(ch);
            if (len - offset < this._outputBufferLen - this._outputPtr) continue;
            this.flushBuffer();
        }
    }

    public int getRow() {
        return 1;
    }

    public int getColumn() {
        return this.getOutputPtr() - this._locRowStartOffset + 1;
    }

    public int getAbsOffset() {
        return this._locPastChars + this.getOutputPtr();
    }

    private void flushBuffer() throws IOException {
        if (this._outputPtr > 0 && this._out != null) {
            int ptr = this._outputPtr;
            this._locPastChars += ptr;
            this._locRowStartOffset -= ptr;
            this._outputPtr = 0;
            this._out.write(this._outputBuffer, 0, ptr);
        }
    }

    private void writeName(WName name) throws IOException {
        int ptr = this._outputPtr;
        int len = name.serializedLength();
        if (ptr + len > this._outputBufferLen) {
            this.flushBuffer();
            if (len >= this._outputBufferLen) {
                name.writeChars(this._out);
                return;
            }
            ptr = this._outputPtr;
        }
        name.appendChars(this._outputBuffer, ptr);
        this._outputPtr += len;
    }

    private void fastWriteRaw(char c) throws IOException {
        if (this._outputPtr >= this._outputBufferLen) {
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = c;
    }

    private void fastWriteRaw() throws IOException {
        if (this._outputPtr + 1 >= this._outputBufferLen) {
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = 61;
        this._outputBuffer[this._outputPtr++] = 34;
    }

    private void fastWriteRaw(String str) throws IOException {
        int ptr = this._outputPtr;
        int len = str.length();
        if (ptr + len >= this._outputBufferLen) {
            if (len > this._outputBufferLen) {
                this.writeRaw(str, 0, str.length());
                return;
            }
            this.flushBuffer();
            ptr = this._outputPtr;
        }
        str.getChars(0, len, this._outputBuffer, ptr);
        this._outputPtr = ptr + len;
    }

    private void writeAsEntity(int c) throws IOException {
        int ptr = this._outputPtr;
        char[] buf = this._outputBuffer;
        if (ptr + 10 >= buf.length) {
            this.flushBuffer();
            ptr = this._outputPtr;
        }
        buf[ptr++] = 38;
        if (c < 256) {
            if (c == 38) {
                buf[ptr++] = 97;
                buf[ptr++] = 109;
                buf[ptr++] = 112;
            } else if (c == 60) {
                buf[ptr++] = 108;
                buf[ptr++] = 116;
            } else if (c == 62) {
                buf[ptr++] = 103;
                buf[ptr++] = 116;
            } else if (c == 39) {
                buf[ptr++] = 97;
                buf[ptr++] = 112;
                buf[ptr++] = 111;
                buf[ptr++] = 115;
            } else if (c == 34) {
                buf[ptr++] = 113;
                buf[ptr++] = 117;
                buf[ptr++] = 111;
                buf[ptr++] = 116;
            } else {
                buf[ptr++] = 35;
                buf[ptr++] = 120;
                if (c >= 16) {
                    int digit = c >> 4;
                    buf[ptr++] = (char)(digit < 10 ? 48 + digit : 87 + digit);
                    c &= 0xF;
                }
                buf[ptr++] = (char)(c < 10 ? 48 + c : 87 + c);
            }
        } else {
            buf[ptr++] = 35;
            buf[ptr++] = 120;
            int shift = 20;
            int origPtr = ptr;
            do {
                int digit;
                if ((digit = c >> shift & 0xF) <= 0 && ptr == origPtr) continue;
                buf[ptr++] = (char)(digit < 10 ? 48 + digit : 87 + digit);
            } while ((shift -= 4) > 0);
            buf[ptr++] = (char)((c &= 0xF) < 10 ? 48 + c : 87 + c);
        }
        buf[ptr++] = 59;
        this._outputPtr = ptr;
    }

    private void reportFailedEscaping(int ch) throws XMLStreamException {
        if (ch == 65534 || ch == 65535 || ch >= 55296 && ch <= 57343) {
            this.reportInvalidChar(ch);
        }
        if (ch < 32) {
            this.reportInvalidChar(ch);
        }
        this.throwOutputError(MessageFormat.format(ErrorConsts.WERR_NO_ESCAPING, "CDATA block", ch));
    }

    private void reportInvalidChar(int c) throws XMLStreamException {
        try {
            this.flush();
        }
        catch (IOException ioe) {
            throw new StreamExceptionBase(ioe);
        }
        if (c == 0) {
            this.throwOutputError("Invalid null character in text to output");
        }
        if (c < 32 || c >= 127 && c <= 159) {
            this.throwOutputError("Invalid white space character (0x" + Integer.toHexString(c) + ") in text to output");
        }
        if (c > 0x10FFFF) {
            this.throwOutputError("Illegal unicode character point (0x" + Integer.toHexString(c) + ") to output; max is 0x10FFFF as per RFC 3629");
        }
        if (c >= 55296 && c <= 57343) {
            this.throwOutputError("Illegal surrogate pair -- can only be output via character entities (for current encoding), which are not allowed in this content");
        }
        this.throwOutputError("Invalid XML character " + XmlChars.getCharDesc(c) + " in text to output");
    }

    private void throwOutputError(String msg) throws XMLStreamException {
        try {
            this.flush();
        }
        catch (IOException ioe) {
            throw new StreamExceptionBase(ioe);
        }
        throw new XMLStreamException(msg);
    }
}

