/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.json.models;

import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.serialization.json.JsonReader;
import io.clientcore.core.serialization.json.JsonToken;
import io.clientcore.core.serialization.json.JsonWriter;
import io.clientcore.core.serialization.json.implementation.JsonUtils;
import io.clientcore.core.serialization.json.models.JsonElement;
import java.io.IOException;
import java.util.Objects;

public final class JsonNumber
extends JsonElement {
    private static final ClientLogger LOGGER = new ClientLogger(JsonNumber.class);
    private final Number value;

    JsonNumber(String value) throws IllegalArgumentException {
        this.value = JsonUtils.parseNumber(value);
    }

    public JsonNumber(Number value) {
        this.value = Objects.requireNonNull(value, "JsonNumber cannot represent a null value.");
    }

    public Number getValue() {
        return this.value;
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeRawValue(this.value.toString());
    }

    public static JsonNumber fromJson(JsonReader jsonReader) throws IOException {
        JsonToken token = jsonReader.currentToken();
        if (token == null) {
            token = jsonReader.nextToken();
        }
        if (token != JsonToken.NUMBER) {
            throw LOGGER.throwableAtError().addKeyValue("token", token.name()).log("JsonReader is pointing to an invalid token for deserialization.", IllegalStateException::new);
        }
        return new JsonNumber(jsonReader.getString());
    }

    @Override
    public String toJsonString() throws IOException {
        return this.value.toString();
    }
}

