/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.json.implementation.jackson.core.io;

import io.clientcore.core.serialization.json.implementation.jackson.core.io.ContentReference;
import io.clientcore.core.serialization.json.implementation.jackson.core.util.BufferRecycler;
import io.clientcore.core.serialization.json.implementation.jackson.core.util.TextBuffer;

public class IOContext {
    protected final ContentReference _contentReference;
    protected final BufferRecycler _bufferRecycler;
    protected char[] _tokenCBuffer;
    protected char[] _concatCBuffer;

    public IOContext(BufferRecycler br, ContentReference contentRef) {
        this._bufferRecycler = br;
        this._contentReference = contentRef;
    }

    public ContentReference contentReference() {
        return this._contentReference;
    }

    public TextBuffer constructTextBuffer() {
        return new TextBuffer(this._bufferRecycler);
    }

    public char[] allocTokenBuffer() {
        this._verifyAlloc(this._tokenCBuffer);
        this._tokenCBuffer = this._bufferRecycler.allocCharBuffer(0);
        return this._tokenCBuffer;
    }

    public char[] allocConcatBuffer() {
        this._verifyAlloc(this._concatCBuffer);
        this._concatCBuffer = this._bufferRecycler.allocCharBuffer(1);
        return this._concatCBuffer;
    }

    public void releaseTokenBuffer(char[] buf) {
        if (buf != null) {
            this._verifyRelease(buf, this._tokenCBuffer);
            this._tokenCBuffer = null;
            this._bufferRecycler.releaseCharBuffer(0, buf);
        }
    }

    public void releaseConcatBuffer(char[] buf) {
        if (buf != null) {
            this._verifyRelease(buf, this._concatCBuffer);
            this._concatCBuffer = null;
            this._bufferRecycler.releaseCharBuffer(1, buf);
        }
    }

    protected final void _verifyAlloc(Object buffer) {
        if (buffer != null) {
            throw new IllegalStateException("Trying to call same allocXxx() method second time");
        }
    }

    protected final void _verifyRelease(char[] toRelease, char[] src) {
        if (toRelease != src && toRelease.length < src.length) {
            throw this.wrongBuf();
        }
    }

    private IllegalArgumentException wrongBuf() {
        return new IllegalArgumentException("Trying to release buffer smaller than original");
    }
}

