/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.json;

import io.clientcore.core.implementation.ReflectionUtils;
import io.clientcore.core.implementation.ReflectiveInvoker;
import io.clientcore.core.implementation.TypeUtil;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.serialization.ObjectSerializer;
import io.clientcore.core.serialization.SerializationFormat;
import io.clientcore.core.serialization.json.JsonReader;
import io.clientcore.core.serialization.json.JsonSerializable;
import io.clientcore.core.serialization.json.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public class JsonSerializer
implements ObjectSerializer {
    private static final ClientLogger LOGGER = new ClientLogger(JsonSerializer.class);
    private static final JsonSerializer INSTANCE = new JsonSerializer();

    public static JsonSerializer getInstance() {
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T deserializeFromBytes(byte[] bytes, Type type) throws IOException {
        try (JsonReader jsonReader = JsonReader.fromBytes(bytes);){
            if (type instanceof ParameterizedType && List.class.isAssignableFrom(TypeUtil.getRawClass(type))) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type listElementType = parameterizedType.getActualTypeArguments()[0];
                if (JsonSerializable.class.isAssignableFrom(TypeUtil.getRawClass(listElementType))) {
                    T t = this.deserializeListOfJsonSerializables(jsonReader, parameterizedType);
                    return t;
                }
                if (BinaryData.class.isAssignableFrom(TypeUtil.getRawClass(listElementType))) {
                    T t = this.deserializeListOfBinaryData(jsonReader);
                    return t;
                }
                Object object = jsonReader.readUntyped();
                return (T)object;
            }
            if (type instanceof Class && JsonSerializable.class.isAssignableFrom(TypeUtil.getRawClass(type))) {
                Class clazz = (Class)type;
                Object object = clazz.getMethod("fromJson", JsonReader.class).invoke(null, jsonReader);
                return (T)object;
            }
            Object object = jsonReader.readUntyped();
            return (T)object;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw LOGGER.throwableAtError().log(e, RuntimeException::new);
        }
    }

    private <T> T deserializeListOfBinaryData(JsonReader jsonReader) throws IOException {
        return (T)jsonReader.readArray(arrayReader -> BinaryData.fromObject(arrayReader.readUntyped()));
    }

    private <T> T deserializeListOfJsonSerializables(JsonReader jsonReader, ParameterizedType parameterizedType) throws IOException {
        ReflectiveInvoker methodInvoker;
        Type actualTypeArgument = parameterizedType.getActualTypeArguments()[0];
        Class listElementClass = (Class)actualTypeArgument;
        try {
            Method fromJson = listElementClass.getDeclaredMethod("fromJson", JsonReader.class);
            fromJson.setAccessible(true);
            methodInvoker = ReflectionUtils.getMethodInvoker(listElementClass, fromJson);
        }
        catch (Exception e) {
            throw LOGGER.throwableAtError().log(e, RuntimeException::new);
        }
        return (T)jsonReader.readArray(arrayReader -> {
            try {
                return methodInvoker.invoke(arrayReader);
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    throw (Error)LOGGER.throwableAtError().log(message -> e);
                }
                if (e instanceof IOException) {
                    throw (IOException)LOGGER.throwableAtError().log(message -> e);
                }
                throw LOGGER.throwableAtError().log(e, RuntimeException::new);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T deserializeFromStream(InputStream stream, Type type) throws IOException {
        try (JsonReader jsonReader = JsonReader.fromStream(stream);){
            if (type instanceof Class && JsonSerializable.class.isAssignableFrom(TypeUtil.getRawClass(type))) {
                Class clazz = (Class)type;
                Object object = clazz.getMethod("fromJson", JsonReader.class).invoke(null, jsonReader);
                return (T)object;
            }
            Object object = jsonReader.readUntyped();
            return (T)object;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw LOGGER.throwableAtError().log(e, RuntimeException::new);
        }
    }

    @Override
    public byte[] serializeToBytes(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof JsonSerializable) {
            return ((JsonSerializable)value).toJsonBytes();
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            block13: {
                JsonWriter jsonWriter = JsonWriter.toStream(byteArrayOutputStream);
                try {
                    jsonWriter.writeUntyped(value);
                    jsonWriter.flush();
                    byArray = byteArrayOutputStream.toByteArray();
                    if (jsonWriter == null) break block13;
                }
                catch (Throwable throwable) {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonWriter.close();
            }
            return byArray;
        }
    }

    @Override
    public void serializeToStream(OutputStream stream, Object value) throws IOException {
        if (value == null) {
            return;
        }
        try (JsonWriter jsonWriter = JsonWriter.toStream(stream);){
            jsonWriter.writeUntyped(value);
        }
    }

    @Override
    public final boolean supportsFormat(SerializationFormat format) {
        return format == SerializationFormat.JSON;
    }
}

