/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.models.geo;

import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.geo.GeoLineStringCollection;
import io.clientcore.core.models.geo.GeoPointCollection;
import io.clientcore.core.models.geo.GeoPolygon;
import io.clientcore.core.models.geo.GeoPolygonCollection;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

final class GeoArray<T>
extends AbstractList<T> {
    private static final String NO_MUTATION_MESSAGE = "GeoArray cannot be mutated.";
    private static final ClientLogger LOGGER = new ClientLogger(GeoArray.class);
    private final Object container;

    GeoArray(Object container) {
        this.container = container;
    }

    @Override
    public T get(int index) {
        if (this.container instanceof List) {
            return (T)((List)this.container).get(index);
        }
        if (this.container instanceof GeoPointCollection) {
            return (T)((GeoPointCollection)this.container).getPoints().get(index).getCoordinates();
        }
        if (this.container instanceof GeoLineStringCollection) {
            return (T)((GeoLineStringCollection)this.container).getLines().get(index).getCoordinates();
        }
        if (this.container instanceof GeoPolygon) {
            return (T)((GeoPolygon)this.container).getRings().get(index).getCoordinates();
        }
        if (this.container instanceof GeoPolygonCollection) {
            return (T)((GeoPolygonCollection)this.container).getPolygons().get(index).getCoordinates();
        }
        throw LOGGER.throwableAtError().log(IllegalStateException::new);
    }

    @Override
    public int size() {
        if (this.container instanceof List) {
            return ((List)this.container).size();
        }
        if (this.container instanceof GeoPointCollection) {
            return ((GeoPointCollection)this.container).getPoints().size();
        }
        if (this.container instanceof GeoLineStringCollection) {
            return ((GeoLineStringCollection)this.container).getLines().size();
        }
        if (this.container instanceof GeoPolygon) {
            return ((GeoPolygon)this.container).getRings().size();
        }
        if (this.container instanceof GeoPolygonCollection) {
            return ((GeoPolygonCollection)this.container).getPolygons().size();
        }
        throw LOGGER.throwableAtError().log(IllegalStateException::new);
    }

    @Override
    public boolean remove(Object o) {
        throw LOGGER.throwableAtError().log(NO_MUTATION_MESSAGE, UnsupportedOperationException::new);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw LOGGER.throwableAtError().log(NO_MUTATION_MESSAGE, UnsupportedOperationException::new);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw LOGGER.throwableAtError().log(NO_MUTATION_MESSAGE, UnsupportedOperationException::new);
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        throw LOGGER.throwableAtError().log(NO_MUTATION_MESSAGE, UnsupportedOperationException::new);
    }

    @Override
    public void sort(Comparator<? super T> c) {
        throw LOGGER.throwableAtError().log(NO_MUTATION_MESSAGE, UnsupportedOperationException::new);
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        throw LOGGER.throwableAtError().log(NO_MUTATION_MESSAGE, UnsupportedOperationException::new);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw LOGGER.throwableAtError().log("GeoArray does not support sub lists.", UnsupportedOperationException::new);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoArray)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        GeoArray other = (GeoArray)o;
        return Objects.equals(this.container, other.container);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.container);
    }
}

