/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.models.binarydata;

import io.clientcore.core.implementation.AccessibleByteArrayOutputStream;
import io.clientcore.core.implementation.utils.ImplUtils;
import io.clientcore.core.implementation.utils.IterableOfByteBuffersInputStream;
import io.clientcore.core.implementation.utils.StreamUtil;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.CoreException;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.serialization.ObjectSerializer;
import io.clientcore.core.serialization.json.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;

public final class InputStreamBinaryData
extends BinaryData {
    private static final ClientLogger LOGGER = new ClientLogger(InputStreamBinaryData.class);
    private static final int INITIAL_BUFFER_CHUNK_SIZE = 8192;
    private static final int MAX_BUFFER_CHUNK_SIZE = 0x800000;
    private static final int MAX_ARRAY_LENGTH = 0x7FFFFFF7;
    private final Supplier<InputStream> content;
    private final Long length;
    private final boolean isReplayable;
    private final List<ByteBuffer> bufferedContent;
    private volatile byte[] bytes;
    private static final AtomicReferenceFieldUpdater<InputStreamBinaryData, byte[]> BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(InputStreamBinaryData.class, byte[].class, "bytes");

    public InputStreamBinaryData(InputStream inputStream, Long length) {
        Objects.requireNonNull(inputStream, "'inputStream' cannot be null.");
        this.length = length;
        this.isReplayable = InputStreamBinaryData.canMarkReset(inputStream, length);
        if (this.isReplayable) {
            inputStream.mark(length.intValue());
            this.content = () -> InputStreamBinaryData.resettableContent(inputStream);
        } else {
            this.content = () -> inputStream;
        }
        this.bufferedContent = null;
    }

    private InputStreamBinaryData(Supplier<InputStream> inputStreamSupplier, Long length, List<ByteBuffer> bufferedContent) {
        this.content = Objects.requireNonNull(inputStreamSupplier, "'inputStreamSupplier' cannot be null.");
        this.length = length;
        this.isReplayable = true;
        this.bufferedContent = bufferedContent;
    }

    @Override
    public byte[] toBytes() {
        if (this.length != null && this.length > 0x7FFFFFF7L) {
            throw LOGGER.throwableAtError().log("The content length is too large for a byte array. Content length is: " + this.length, CoreException::from);
        }
        return BYTES_UPDATER.updateAndGet(this, bytes -> bytes == null ? this.getBytes() : bytes);
    }

    @Override
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public <T> T toObject(Type type, ObjectSerializer serializer) {
        try {
            return serializer.deserializeFromBytes(this.toBytes(), type);
        }
        catch (IOException e) {
            throw LOGGER.throwableAtError().log(e, CoreException::from);
        }
    }

    @Override
    public InputStream toStream() {
        return this.content.get();
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.toBytes()).asReadOnlyBuffer();
    }

    @Override
    public void writeTo(OutputStream outputStream) {
        InputStream inputStream = this.content.get();
        try {
            if (this.bufferedContent != null) {
                for (ByteBuffer bb : this.bufferedContent) {
                    ImplUtils.writeByteBufferToStream(bb, outputStream);
                }
            } else {
                int read;
                byte[] buffer = new byte[8192];
                while ((read = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, read);
                }
            }
        }
        catch (IOException e) {
            throw LOGGER.throwableAtError().log(e, CoreException::from);
        }
    }

    @Override
    public void writeTo(WritableByteChannel channel) {
        InputStream inputStream = this.content.get();
        try {
            if (this.bufferedContent != null) {
                for (ByteBuffer bb : this.bufferedContent) {
                    bb = bb.duplicate();
                    while (bb.hasRemaining()) {
                        channel.write(bb);
                    }
                }
            } else {
                int read;
                byte[] buffer = new byte[8192];
                while ((read = inputStream.read(buffer)) != -1) {
                    ByteBuffer bb = ByteBuffer.wrap(buffer, 0, read);
                    while (bb.hasRemaining()) {
                        channel.write(bb);
                    }
                }
            }
        }
        catch (IOException e) {
            throw LOGGER.throwableAtError().log(e, CoreException::from);
        }
    }

    @Override
    public void writeTo(JsonWriter jsonWriter) {
        Objects.requireNonNull(jsonWriter, "'jsonWriter' cannot be null");
        try {
            jsonWriter.writeBinary(this.toBytes());
        }
        catch (IOException e) {
            throw LOGGER.throwableAtError().log(e, CoreException::from);
        }
    }

    @Override
    public Long getLength() {
        byte[] data = BYTES_UPDATER.get(this);
        if (data != null) {
            return data.length;
        }
        return this.length;
    }

    @Override
    public boolean isReplayable() {
        return this.isReplayable;
    }

    @Override
    public BinaryData toReplayableBinaryData() {
        if (this.isReplayable) {
            return this;
        }
        return InputStreamBinaryData.readAndBuffer(this.content.get(), this.length);
    }

    private static boolean canMarkReset(InputStream inputStream, Long length) {
        return length != null && length < 0x7FFFFFF7L && inputStream.markSupported();
    }

    private static InputStream resettableContent(InputStream stream) {
        try {
            stream.reset();
            return stream;
        }
        catch (IOException e) {
            throw LOGGER.throwableAtError().log(e, CoreException::from);
        }
    }

    private static InputStreamBinaryData readAndBuffer(InputStream inputStream, Long length) {
        try {
            List<ByteBuffer> byteBuffers = StreamUtil.readStreamToListOfByteBuffers(inputStream, length, 8192, 0x800000);
            return new InputStreamBinaryData(() -> new IterableOfByteBuffersInputStream(byteBuffers), length, byteBuffers);
        }
        catch (IOException e) {
            throw LOGGER.throwableAtError().log(e, CoreException::from);
        }
    }

    private byte[] getBytes() {
        try {
            int nRead;
            AccessibleByteArrayOutputStream dataOutputBuffer = new AccessibleByteArrayOutputStream();
            byte[] data = new byte[8192];
            InputStream inputStream = this.content.get();
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                dataOutputBuffer.write(data, 0, nRead);
            }
            return dataOutputBuffer.toByteArrayUnsafe();
        }
        catch (IOException ex) {
            throw LOGGER.throwableAtError().log(ex, CoreException::from);
        }
    }

    @Override
    public void close() {
        try {
            this.content.get().close();
        }
        catch (IOException e) {
            throw LOGGER.throwableAtError().log(e, CoreException::from);
        }
    }
}

