/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.instrumentation.logging;

import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.logging.LoggingEvent;
import java.util.function.BiFunction;
import java.util.function.Function;

public class ExceptionLoggingEvent {
    private final LoggingEvent log;

    ExceptionLoggingEvent(LoggingEvent log) {
        this.log = log;
    }

    public ExceptionLoggingEvent addKeyValue(String key, String value) {
        this.log.addKeyValue(key, value);
        return this;
    }

    public ExceptionLoggingEvent addKeyValue(String key, boolean value) {
        this.log.addKeyValue(key, value);
        return this;
    }

    public ExceptionLoggingEvent addKeyValue(String key, long value) {
        this.log.addKeyValue(key, value);
        return this;
    }

    public ExceptionLoggingEvent addKeyValue(String key, Object value) {
        this.log.addKeyValue(key, value);
        return this;
    }

    public ExceptionLoggingEvent setInstrumentationContext(InstrumentationContext context) {
        this.log.setInstrumentationContext(context);
        return this;
    }

    public <T extends Throwable> T log(Function<String, T> throwableFactory) {
        return (T)this.logImpl(null, (Throwable)throwableFactory.apply(this.log.getExceptionMessageWithContext(null, null)));
    }

    public <T extends Throwable> T log(String shortMessage, Function<String, T> throwableFactory) {
        return (T)this.logImpl(shortMessage, (Throwable)throwableFactory.apply(this.log.getExceptionMessageWithContext(shortMessage, null)));
    }

    public <T extends Throwable> T log(Throwable cause, BiFunction<String, Throwable, T> throwableFactory) {
        return (T)this.logImpl(null, (Throwable)throwableFactory.apply(this.log.getExceptionMessageWithContext(cause.getMessage(), cause), cause));
    }

    public <T extends Throwable> T log(String shortMessage, Throwable cause, BiFunction<String, Throwable, T> throwableFactory) {
        return (T)this.logImpl(shortMessage, (Throwable)throwableFactory.apply(this.log.getExceptionMessageWithContext(shortMessage, cause), cause));
    }

    private <T extends Throwable> T logImpl(String shortMessage, T exception) {
        this.log.recordExceptionDetails(exception, null);
        this.log.log(shortMessage);
        return exception;
    }
}

