/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.otel;

import io.clientcore.core.implementation.ReflectionUtils;
import io.clientcore.core.implementation.ReflectiveInvoker;
import io.clientcore.core.implementation.instrumentation.otel.FallbackInvoker;
import io.clientcore.core.implementation.instrumentation.otel.OTelInitializer;
import io.clientcore.core.implementation.instrumentation.otel.tracing.OTelSpan;
import io.clientcore.core.implementation.instrumentation.otel.tracing.OTelSpanContext;
import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.instrumentation.tracing.TracingScope;

public class OTelContext {
    private static final ClientLogger LOGGER = new ClientLogger(OTelContext.class);
    private static final TracingScope NOOP_SCOPE = () -> {};
    private static final FallbackInvoker CURRENT_INVOKER;
    private static final FallbackInvoker MAKE_CURRENT_INVOKER;
    private static final FallbackInvoker WITH_INVOKER;
    private static final FallbackInvoker GET_INVOKER;
    private static final Object CLIENT_CORE_SPAN_CONTEXT_KEY;

    public static Object getCurrent() {
        Object currentContext = CURRENT_INVOKER.invoke();
        assert (OTelInitializer.CONTEXT_CLASS.isInstance(currentContext));
        return currentContext;
    }

    public static AutoCloseable makeCurrent(Object context) {
        Object scope = MAKE_CURRENT_INVOKER.invoke(context);
        assert (scope instanceof AutoCloseable);
        return (AutoCloseable)scope;
    }

    public static Object markCoreSpan(Object context, OTelSpan span) {
        Object updatedContext = WITH_INVOKER.invoke(context, CLIENT_CORE_SPAN_CONTEXT_KEY, span);
        return updatedContext == null ? context : updatedContext;
    }

    public static OTelSpan getClientCoreSpan(Object context) {
        Object clientCoreSpan = GET_INVOKER.invoke(context, CLIENT_CORE_SPAN_CONTEXT_KEY);
        assert (clientCoreSpan == null || clientCoreSpan instanceof OTelSpan);
        return (OTelSpan)clientCoreSpan;
    }

    public static Object fromInstrumentationContext(InstrumentationContext context) {
        Object otelContext;
        if (context instanceof OTelSpanContext && (otelContext = ((OTelSpanContext)context).getOtelContext()) != null) {
            return otelContext;
        }
        Object currentContext = CURRENT_INVOKER.invoke();
        if (context != null) {
            Object spanContext = OTelSpanContext.toOTelSpanContext(context);
            Object span = OTelSpan.wrapSpanContext(spanContext);
            return OTelSpan.storeInContext(span, currentContext);
        }
        return currentContext;
    }

    static {
        ReflectiveInvoker currentInvoker = null;
        ReflectiveInvoker makeCurrentInvoker = null;
        ReflectiveInvoker withInvoker = null;
        ReflectiveInvoker getInvoker = null;
        Object clientCoreSpanContextKey = null;
        Object rootContext = null;
        if (OTelInitializer.isInitialized()) {
            try {
                currentInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.CONTEXT_CLASS, OTelInitializer.CONTEXT_CLASS.getMethod("current", new Class[0]));
                makeCurrentInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.CONTEXT_CLASS, OTelInitializer.CONTEXT_CLASS.getMethod("makeCurrent", new Class[0]));
                withInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.CONTEXT_CLASS, OTelInitializer.CONTEXT_CLASS.getMethod("with", OTelInitializer.CONTEXT_KEY_CLASS, Object.class));
                getInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.CONTEXT_CLASS, OTelInitializer.CONTEXT_CLASS.getMethod("get", OTelInitializer.CONTEXT_KEY_CLASS));
                ReflectiveInvoker contextKeyNamedInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.CONTEXT_KEY_CLASS, OTelInitializer.CONTEXT_KEY_CLASS.getMethod("named", String.class));
                clientCoreSpanContextKey = contextKeyNamedInvoker.invoke("client-core-span");
                ReflectiveInvoker rootInvoker = ReflectionUtils.getMethodInvoker(OTelInitializer.CONTEXT_CLASS, OTelInitializer.CONTEXT_CLASS.getMethod("root", new Class[0]));
                rootContext = rootInvoker.invoke();
            }
            catch (Throwable t) {
                OTelInitializer.initError(LOGGER, t);
            }
        }
        CURRENT_INVOKER = new FallbackInvoker(currentInvoker, rootContext, LOGGER);
        MAKE_CURRENT_INVOKER = new FallbackInvoker(makeCurrentInvoker, NOOP_SCOPE, LOGGER);
        WITH_INVOKER = new FallbackInvoker(withInvoker, LOGGER);
        GET_INVOKER = new FallbackInvoker(getInvoker, LOGGER);
        CLIENT_CORE_SPAN_CONTEXT_KEY = clientCoreSpanContextKey;
    }
}

