/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.otel;

import io.clientcore.core.implementation.ReflectiveInvoker;
import io.clientcore.core.implementation.instrumentation.otel.OTelInitializer;
import io.clientcore.core.instrumentation.logging.ClientLogger;

public class FallbackInvoker {
    private final ReflectiveInvoker inner;
    private final Object fallback;
    private final ClientLogger logger;

    public FallbackInvoker(ReflectiveInvoker inner, ClientLogger logger) {
        this(inner, null, logger);
    }

    public FallbackInvoker(ReflectiveInvoker inner, Object fallback, ClientLogger logger) {
        this.inner = inner;
        this.fallback = fallback;
        this.logger = logger;
    }

    public Object invoke() {
        try {
            return this.inner.invoke();
        }
        catch (Throwable t) {
            OTelInitializer.runtimeError(this.logger, t);
            return this.fallback;
        }
    }

    public Object invoke(Object argOrTarget) {
        try {
            return this.inner.invoke(argOrTarget);
        }
        catch (Throwable t) {
            OTelInitializer.runtimeError(this.logger, t);
            return this.fallback;
        }
    }

    public Object invoke(Object argOrTarget, Object arg1) {
        try {
            return this.inner.invoke(argOrTarget, arg1);
        }
        catch (Throwable t) {
            OTelInitializer.runtimeError(this.logger, t);
            return this.fallback;
        }
    }

    public Object invoke(Object argOrTarget, Object arg1, Object arg2) {
        try {
            return this.inner.invoke(argOrTarget, arg1, arg2);
        }
        catch (Throwable t) {
            OTelInitializer.runtimeError(this.logger, t);
            return this.fallback;
        }
    }

    public Object invoke(Object argOrTarget, Object arg1, Object arg2, Object arg3) {
        try {
            return this.inner.invoke(argOrTarget, arg1, arg2, arg3);
        }
        catch (Throwable t) {
            OTelInitializer.runtimeError(this.logger, t);
            return this.fallback;
        }
    }
}

