/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.fallback;

import io.clientcore.core.implementation.instrumentation.fallback.FallbackAttributes;
import io.clientcore.core.implementation.instrumentation.fallback.FallbackSpan;
import io.clientcore.core.implementation.instrumentation.fallback.FallbackSpanContext;
import io.clientcore.core.instrumentation.InstrumentationAttributes;
import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.instrumentation.logging.LoggingEvent;
import io.clientcore.core.instrumentation.tracing.Span;
import io.clientcore.core.instrumentation.tracing.SpanBuilder;
import io.clientcore.core.instrumentation.tracing.SpanKind;
import java.util.Map;

final class FallbackSpanBuilder
implements SpanBuilder {
    static final FallbackSpanBuilder NOOP = new FallbackSpanBuilder();
    private final LoggingEvent log;
    private final FallbackSpanContext parentSpanContext;
    private final SpanKind spanKind;

    private FallbackSpanBuilder() {
        this.log = null;
        this.parentSpanContext = FallbackSpanContext.INVALID;
        this.spanKind = null;
    }

    FallbackSpanBuilder(ClientLogger logger, String spanName, SpanKind spanKind, InstrumentationContext instrumentationContext) {
        this.parentSpanContext = FallbackSpanContext.fromInstrumentationContext(instrumentationContext);
        this.spanKind = spanKind;
        this.log = logger.atVerbose();
        if (this.log.isEnabled()) {
            this.log.addKeyValue("span.name", spanName).addKeyValue("span.kind", spanKind.name());
            if (this.parentSpanContext.isValid()) {
                this.log.addKeyValue("span.parent.id", this.parentSpanContext.getSpanId());
            }
        }
    }

    @Override
    public SpanBuilder setAttribute(String key, Object value) {
        if (this.log != null) {
            this.log.addKeyValue(key, value);
        }
        return this;
    }

    @Override
    public SpanBuilder setAllAttributes(InstrumentationAttributes attributes) {
        if (this.log != null && attributes instanceof FallbackAttributes) {
            for (Map.Entry<String, Object> entry : ((FallbackAttributes)attributes).getAttributes().entrySet()) {
                this.log.addKeyValue(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Override
    public Span startSpan() {
        if (this.log != null) {
            return new FallbackSpan(this.log, this.spanKind, this.parentSpanContext, this.log.isEnabled());
        }
        return Span.noop();
    }
}

