/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation;

import io.clientcore.core.implementation.instrumentation.NoopMeter;
import io.clientcore.core.instrumentation.SdkInstrumentationOptions;
import io.clientcore.core.instrumentation.metrics.DoubleHistogram;
import io.clientcore.core.instrumentation.metrics.Meter;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class InstrumentationUtils {
    private static final List<Double> DURATION_BOUNDARIES_ADVICE = Collections.unmodifiableList(Arrays.asList(0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0));
    public static final SdkInstrumentationOptions UNKNOWN_LIBRARY_OPTIONS = new SdkInstrumentationOptions("unknown");

    public static DoubleHistogram createOperationDurationHistogram(boolean isExperimentalFeaturesEnabled, String sdkName, Meter meter) {
        if (isExperimentalFeaturesEnabled && meter.isEnabled() && sdkName != null) {
            String metricDescription = "Duration of client operation";
            String metricName = sdkName.replace("-", ".") + ".client.operation.duration";
            return meter.createDoubleHistogram(metricName, metricDescription, "s", DURATION_BOUNDARIES_ADVICE);
        }
        return NoopMeter.NOOP_LONG_HISTOGRAM;
    }

    public static int getServerPort(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            switch (uri.getScheme()) {
                case "http": {
                    return 80;
                }
                case "https": {
                    return 443;
                }
            }
        }
        return port;
    }

    private InstrumentationUtils() {
    }
}

