/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.http.serializer;

import io.clientcore.core.http.models.HttpMethod;
import io.clientcore.core.http.models.HttpResponseException;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.implementation.TypeUtil;
import io.clientcore.core.implementation.http.rest.RestProxyImpl;
import io.clientcore.core.implementation.http.serializer.CompositeSerializer;
import io.clientcore.core.implementation.http.serializer.HttpResponseDecodeData;
import io.clientcore.core.implementation.http.serializer.MalformedValueException;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.serialization.SerializationFormat;
import io.clientcore.core.utils.Base64Uri;
import io.clientcore.core.utils.DateTimeRfc1123;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class HttpResponseBodyDecoder {
    private static final ClientLogger LOGGER = new ClientLogger(HttpResponseBodyDecoder.class);
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static Object decodeByteArray(BinaryData body, Response<BinaryData> response, CompositeSerializer serializer, HttpResponseDecodeData decodeData) {
        HttpResponseBodyDecoder.ensureRequestSet(response);
        if (response.getRequest().getHttpMethod() == HttpMethod.HEAD) {
            return null;
        }
        if (HttpResponseBodyDecoder.isErrorStatus(response.getStatusCode(), decodeData)) {
            try {
                return HttpResponseBodyDecoder.deserializeBody(body, decodeData.getUnexpectedException(response.getStatusCode()).getExceptionBodyClass(), null, RestProxyImpl.serializationFormatFromContentType(response.getHeaders()), serializer);
            }
            catch (IOException e) {
                LOGGER.atWarning().setThrowable(e).log("Failed to deserialize the error entity.");
                return e;
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof InvocationTargetException || cause instanceof IllegalAccessException || cause instanceof NoSuchMethodException || cause instanceof IOException) {
                    LOGGER.atWarning().setThrowable(e).log("Failed to deserialize the error entity.");
                    return e;
                }
                throw e;
            }
        }
        if (!decodeData.isReturnTypeDecodable()) {
            return null;
        }
        try {
            return HttpResponseBodyDecoder.deserializeBody(body == null ? response.getValue() : body, HttpResponseBodyDecoder.extractEntityTypeFromReturnType(decodeData), decodeData.getReturnValueWireType(), RestProxyImpl.serializationFormatFromContentType(response.getHeaders()), serializer);
        }
        catch (MalformedValueException e) {
            throw LOGGER.throwableAtError().log("HTTP response has a malformed body.", e, (m, c) -> new HttpResponseException((String)m, response, (Throwable)c));
        }
        catch (IOException e) {
            throw LOGGER.throwableAtError().log("Deserialization failed.", e, (m, c) -> new HttpResponseException((String)m, response, (Throwable)c));
        }
    }

    public static Type decodedType(Response<?> response, HttpResponseDecodeData decodeData) {
        HttpResponseBodyDecoder.ensureRequestSet(response);
        if (response.getRequest().getHttpMethod() == HttpMethod.HEAD) {
            return null;
        }
        if (HttpResponseBodyDecoder.isErrorStatus(response.getStatusCode(), decodeData)) {
            return decodeData.getUnexpectedException(response.getStatusCode()).getExceptionBodyClass();
        }
        return decodeData.isReturnTypeDecodable() ? HttpResponseBodyDecoder.extractEntityTypeFromReturnType(decodeData) : null;
    }

    static boolean isErrorStatus(int statusCode, HttpResponseDecodeData decodeData) {
        return !decodeData.isExpectedResponseStatusCode(statusCode);
    }

    private static Object deserializeBody(BinaryData value, Type resultType, Type wireType, SerializationFormat format, CompositeSerializer serializer) throws IOException {
        if (wireType == null) {
            return HttpResponseBodyDecoder.deserialize(value, resultType, format, serializer);
        }
        Type wireResponseType = HttpResponseBodyDecoder.constructWireResponseType(resultType, wireType);
        Object wireResponse = HttpResponseBodyDecoder.deserialize(value, wireResponseType, format, serializer);
        return HttpResponseBodyDecoder.convertToResultType(wireResponse, resultType, wireType);
    }

    private static Object deserialize(BinaryData value, Type type, SerializationFormat format, CompositeSerializer serializer) throws IOException {
        return serializer.deserializeFromBytes(value == null ? EMPTY_BYTE_ARRAY : value.toBytes(), type, format);
    }

    private static Type constructWireResponseType(Type resultType, Type wireType) {
        Objects.requireNonNull(wireType);
        if (resultType == byte[].class) {
            if (wireType == Base64Uri.class) {
                return Base64Uri.class;
            }
        } else if (resultType == OffsetDateTime.class) {
            if (wireType == DateTimeRfc1123.class) {
                return DateTimeRfc1123.class;
            }
        } else {
            if (TypeUtil.isTypeOrSubTypeOf(resultType, List.class)) {
                Type resultElementType = TypeUtil.getTypeArgument(resultType);
                Type wireResponseElementType = HttpResponseBodyDecoder.constructWireResponseType(resultElementType, wireType);
                return TypeUtil.createParameterizedType(((ParameterizedType)resultType).getRawType(), wireResponseElementType);
            }
            if (TypeUtil.isTypeOrSubTypeOf(resultType, Map.class)) {
                Type[] typeArguments = TypeUtil.getTypeArguments(resultType);
                Type resultValueType = typeArguments[1];
                Type wireResponseValueType = HttpResponseBodyDecoder.constructWireResponseType(resultValueType, wireType);
                return TypeUtil.createParameterizedType(((ParameterizedType)resultType).getRawType(), typeArguments[0], wireResponseValueType);
            }
        }
        return resultType;
    }

    private static Object convertToResultType(Object wireResponse, Type resultType, Type wireType) {
        if (resultType == byte[].class) {
            if (wireType == Base64Uri.class) {
                return new Base64Uri(wireResponse.toString()).decodedBytes();
            }
        } else {
            if (resultType == OffsetDateTime.class) {
                if (wireType == DateTimeRfc1123.class) {
                    return new DateTimeRfc1123(wireResponse.toString()).getDateTime();
                }
                return OffsetDateTime.parse(wireResponse.toString());
            }
            if (TypeUtil.isTypeOrSubTypeOf(resultType, List.class)) {
                Type resultElementType = TypeUtil.getTypeArgument(resultType);
                List wireResponseList = (List)wireResponse;
                int wireResponseListSize = wireResponseList.size();
                for (int i = 0; i < wireResponseListSize; ++i) {
                    Object resultElement;
                    Object wireResponseElement = wireResponseList.get(i);
                    if (wireResponseElement == (resultElement = HttpResponseBodyDecoder.convertToResultType(wireResponseElement, resultElementType, wireType))) continue;
                    wireResponseList.set(i, resultElement);
                }
                return wireResponseList;
            }
            if (TypeUtil.isTypeOrSubTypeOf(resultType, Map.class)) {
                Type resultValueType = TypeUtil.getTypeArguments(resultType)[1];
                Map wireResponseMap = (Map)wireResponse;
                Set wireResponseEntries = wireResponseMap.entrySet();
                for (Map.Entry wireResponseEntry : wireResponseEntries) {
                    Object resultValue;
                    Object wireResponseValue = wireResponseEntry.getValue();
                    if (wireResponseValue == (resultValue = HttpResponseBodyDecoder.convertToResultType(wireResponseValue, resultValueType, wireType))) continue;
                    wireResponseMap.put((String)wireResponseEntry.getKey(), resultValue);
                }
                return wireResponseMap;
            }
        }
        return wireResponse;
    }

    private static Type extractEntityTypeFromReturnType(HttpResponseDecodeData decodeData) {
        Type token = decodeData.getReturnType();
        if (TypeUtil.isTypeOrSubTypeOf(token, Response.class)) {
            token = TypeUtil.getRestResponseBodyType(token);
        }
        return token;
    }

    private static void ensureRequestSet(Response<?> response) {
        Objects.requireNonNull(response.getRequest());
    }
}

