/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.http.serializer;

import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.serialization.ObjectSerializer;
import io.clientcore.core.serialization.SerializationFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class CompositeSerializer {
    private static final ClientLogger LOGGER = new ClientLogger(CompositeSerializer.class);
    private final List<ObjectSerializer> serializers;

    public CompositeSerializer(List<ObjectSerializer> serializers) {
        Objects.requireNonNull(serializers, "The list of serializers cannot be null.");
        if (serializers.isEmpty()) {
            throw new IllegalArgumentException("The list of serializers cannot be empty.");
        }
        this.serializers = new ArrayList<ObjectSerializer>(serializers);
    }

    public <T> T deserializeFromBytes(byte[] data, Type type, SerializationFormat format) throws IOException {
        for (ObjectSerializer serializer : this.serializers) {
            if (!serializer.supportsFormat(format)) continue;
            return serializer.deserializeFromBytes(data, type);
        }
        throw LOGGER.throwableAtError().addKeyValue("format", format.name()).log("Format is not supported by any serializer.", UnsupportedOperationException::new);
    }

    public <T> T deserializeFromStream(InputStream stream, Type type, SerializationFormat format) throws IOException {
        for (ObjectSerializer serializer : this.serializers) {
            if (!serializer.supportsFormat(format)) continue;
            return serializer.deserializeFromStream(stream, type);
        }
        throw LOGGER.throwableAtError().addKeyValue("format", format.name()).log("Format is not supported by any serializer.", UnsupportedOperationException::new);
    }

    public byte[] serializeToBytes(Object value, SerializationFormat format) throws IOException {
        for (ObjectSerializer serializer : this.serializers) {
            if (!serializer.supportsFormat(format)) continue;
            return serializer.serializeToBytes(value);
        }
        throw LOGGER.throwableAtError().addKeyValue("format", format.name()).log("Format is not supported by any serializer.", UnsupportedOperationException::new);
    }

    public void serializeToStream(OutputStream stream, Object value, SerializationFormat format) throws IOException {
        for (ObjectSerializer serializer : this.serializers) {
            if (!serializer.supportsFormat(format)) continue;
            serializer.serializeToStream(stream, value);
            return;
        }
        throw LOGGER.throwableAtError().addKeyValue("format", format.name()).log("Format is not supported by any serializer.", UnsupportedOperationException::new);
    }

    public ObjectSerializer getSerializerForFormat(SerializationFormat format) {
        for (ObjectSerializer serializer : this.serializers) {
            if (!serializer.supportsFormat(format)) continue;
            return serializer;
        }
        throw LOGGER.throwableAtError().addKeyValue("format", format.name()).log("Format is not supported by any serializer.", UnsupportedOperationException::new);
    }
}

