/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.pipeline;

import io.clientcore.core.credentials.oauth.AccessToken;
import io.clientcore.core.credentials.oauth.OAuthTokenCredential;
import io.clientcore.core.credentials.oauth.OAuthTokenRequestContext;
import io.clientcore.core.http.models.AuthMetadata;
import io.clientcore.core.http.models.AuthScheme;
import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.http.pipeline.HttpCredentialPolicy;
import io.clientcore.core.http.pipeline.HttpPipelineNextPolicy;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.utils.CoreUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class OAuthBearerTokenAuthenticationPolicy
extends HttpCredentialPolicy {
    private static final ClientLogger LOGGER = new ClientLogger(OAuthBearerTokenAuthenticationPolicy.class);
    private static final String BEARER = "Bearer";
    private final OAuthTokenRequestContext context;
    private final OAuthTokenCredential credential;

    public OAuthBearerTokenAuthenticationPolicy(OAuthTokenCredential credential, OAuthTokenRequestContext context) {
        Objects.requireNonNull(context);
        this.credential = credential;
        this.context = context;
    }

    public void authorizeRequest(HttpRequest httpRequest, OAuthTokenRequestContext context) {
        AccessToken token = this.credential.getToken(context);
        httpRequest.getHeaders().set(HttpHeaderName.AUTHORIZATION, "Bearer " + token.getToken());
    }

    @Override
    public Response<BinaryData> process(HttpRequest httpRequest, HttpPipelineNextPolicy next) {
        if (!"https".equals(httpRequest.getUri().getScheme())) {
            throw LOGGER.throwableAtError().log("Token credentials require a URL using the HTTPS protocol scheme", IllegalStateException::new);
        }
        HttpPipelineNextPolicy nextPolicy = next.copy();
        AuthMetadata authMetadata = (AuthMetadata)httpRequest.getContext().getMetadata("IO_CLIENTCORE_AUTH_METADATA");
        OAuthTokenRequestContext tokenRequestContext = this.context;
        if (authMetadata != null) {
            List<AuthScheme> authSchemes = authMetadata.getAuthSchemes();
            if (CoreUtils.isNullOrEmpty(authSchemes) || authSchemes.contains(AuthScheme.NO_AUTH)) {
                return next.process();
            }
            tokenRequestContext = this.mergeTokenRequestContext(authMetadata.getOAuthTokenRequestContext());
        }
        this.authorizeRequest(httpRequest, this.mergeTokenRequestContext(tokenRequestContext));
        Response<BinaryData> httpResponse = next.process();
        String authHeader = httpResponse.getHeaders().getValue(HttpHeaderName.WWW_AUTHENTICATE);
        if (httpResponse.getStatusCode() == 401 && authHeader != null) {
            if (this.authorizeRequestOnChallenge(httpRequest, httpResponse)) {
                httpResponse.close();
                return nextPolicy.process();
            }
            return httpResponse;
        }
        return httpResponse;
    }

    public boolean authorizeRequestOnChallenge(HttpRequest httpRequest, Response<BinaryData> response) {
        return false;
    }

    private OAuthTokenRequestContext mergeTokenRequestContext(OAuthTokenRequestContext oAuthTokenRequestContext) {
        if (oAuthTokenRequestContext != null) {
            List<String> mergedScopes = CoreUtils.isNullOrEmpty(oAuthTokenRequestContext.getScopes()) ? this.context.getScopes() : oAuthTokenRequestContext.getScopes();
            HashMap<String, Object> mergedParams = new HashMap<String, Object>();
            if (!CoreUtils.isNullOrEmpty(this.context.getParams())) {
                mergedParams.putAll(this.context.getParams());
            }
            if (!CoreUtils.isNullOrEmpty(oAuthTokenRequestContext.getParams())) {
                mergedParams.putAll(oAuthTokenRequestContext.getParams());
            }
            return new OAuthTokenRequestContext().setScopes(mergedScopes).setParams(mergedParams);
        }
        return this.context;
    }
}

