/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.pipeline;

import io.clientcore.core.http.client.HttpClient;
import io.clientcore.core.http.pipeline.HttpCredentialPolicy;
import io.clientcore.core.http.pipeline.HttpInstrumentationPolicy;
import io.clientcore.core.http.pipeline.HttpPipeline;
import io.clientcore.core.http.pipeline.HttpPipelinePolicy;
import io.clientcore.core.http.pipeline.HttpPipelinePosition;
import io.clientcore.core.http.pipeline.HttpRedirectPolicy;
import io.clientcore.core.http.pipeline.HttpRetryPolicy;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.utils.configuration.Configuration;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Objects;

public class HttpPipelineBuilder {
    private static final ClientLogger LOGGER = new ClientLogger(HttpPipelineBuilder.class);
    private HttpClient httpClient;
    private final LinkedList<HttpPipelinePolicy> beforeRedirect = new LinkedList();
    private HttpRedirectPolicy redirectPolicy;
    private final LinkedList<HttpPipelinePolicy> betweenRedirectAndRetry = new LinkedList();
    private HttpRetryPolicy retryPolicy;
    private final LinkedList<HttpPipelinePolicy> betweenRetryAndAuthentication = new LinkedList();
    private HttpCredentialPolicy credentialPolicy;
    private final LinkedList<HttpPipelinePolicy> betweenAuthenticationAndInstrumentation = new LinkedList();
    private HttpInstrumentationPolicy instrumentationPolicy;
    private final LinkedList<HttpPipelinePolicy> afterInstrumentation = new LinkedList();

    public HttpPipeline build() {
        ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>(this.beforeRedirect);
        if (this.redirectPolicy != null) {
            policies.add(this.redirectPolicy);
        }
        policies.addAll(this.betweenRedirectAndRetry);
        if (this.retryPolicy != null) {
            policies.add(this.retryPolicy);
        }
        policies.addAll(this.betweenRetryAndAuthentication);
        if (this.credentialPolicy != null) {
            policies.add(this.credentialPolicy);
        }
        policies.addAll(this.betweenAuthenticationAndInstrumentation);
        if (this.instrumentationPolicy != null) {
            policies.add(this.instrumentationPolicy);
        }
        policies.addAll(this.afterInstrumentation);
        HttpClient client = this.httpClient != null ? this.httpClient : (Boolean.parseBoolean(Configuration.getGlobalConfiguration().get("AZURE_HTTP_CLIENT_SHARING")) ? HttpClient.getSharedInstance() : HttpClient.getNewInstance());
        return new HttpPipeline(client, policies);
    }

    public HttpPipelineBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public HttpPipelineBuilder addPolicy(HttpPipelinePolicy policy) {
        Objects.requireNonNull(policy, "'policy' cannot be null.");
        if (this.tryAddPillar(policy)) {
            return this;
        }
        HttpPipelinePosition order = policy.getPipelinePosition();
        if (order == null) {
            throw LOGGER.throwableAtError().addKeyValue("policyType", policy.getClass().getCanonicalName()).log("Policy has invalid pipeline position - position cannot be null.", IllegalArgumentException::new);
        }
        if (order == HttpPipelinePosition.BEFORE_REDIRECT) {
            this.beforeRedirect.add(policy);
        } else if (order == HttpPipelinePosition.AFTER_REDIRECT) {
            this.betweenRedirectAndRetry.add(policy);
        } else if (order == HttpPipelinePosition.AFTER_RETRY) {
            this.betweenRetryAndAuthentication.add(policy);
        } else if (order == HttpPipelinePosition.AFTER_AUTHENTICATION) {
            this.betweenAuthenticationAndInstrumentation.add(policy);
        } else if (order == HttpPipelinePosition.AFTER_INSTRUMENTATION) {
            this.afterInstrumentation.add(policy);
        } else {
            throw LOGGER.throwableAtError().addKeyValue("policyType", policy.getClass().getCanonicalName()).addKeyValue("position", order.getValue()).log("Policy has unexpected position.", IllegalArgumentException::new);
        }
        return this;
    }

    private boolean tryAddPillar(HttpPipelinePolicy policy) {
        HttpPipelinePolicy previous = null;
        boolean added = false;
        HttpPipelinePosition order = policy.getPipelinePosition();
        if (order == HttpPipelinePosition.REDIRECT) {
            previous = this.redirectPolicy;
            this.redirectPolicy = (HttpRedirectPolicy)policy;
            added = true;
        } else if (order == HttpPipelinePosition.RETRY) {
            previous = this.retryPolicy;
            this.retryPolicy = (HttpRetryPolicy)policy;
            added = true;
        } else if (order == HttpPipelinePosition.AUTHENTICATION) {
            previous = this.credentialPolicy;
            this.credentialPolicy = (HttpCredentialPolicy)policy;
            added = true;
        } else if (order == HttpPipelinePosition.INSTRUMENTATION) {
            previous = this.instrumentationPolicy;
            this.instrumentationPolicy = (HttpInstrumentationPolicy)policy;
            added = true;
        }
        if (previous != null) {
            LOGGER.atWarning().addKeyValue("policyType", previous.getClass().getSimpleName()).log("A pillar policy was replaced in the pipeline.");
        }
        return added;
    }
}

