/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.pipeline;

import io.clientcore.core.http.client.HttpClient;
import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.http.pipeline.HttpPipelineNextPolicy;
import io.clientcore.core.http.pipeline.HttpPipelinePolicy;
import io.clientcore.core.implementation.http.HttpPipelineCallState;
import io.clientcore.core.models.binarydata.BinaryData;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class HttpPipeline {
    private final HttpClient httpClient;
    private final List<HttpPipelinePolicy> pipelinePolicies;

    HttpPipeline(HttpClient httpClient, List<HttpPipelinePolicy> pipelinePolicies) {
        Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
        Objects.requireNonNull(pipelinePolicies, "'pipelinePolicies' cannot be null.");
        this.httpClient = httpClient;
        this.pipelinePolicies = Collections.unmodifiableList(pipelinePolicies);
    }

    public List<HttpPipelinePolicy> getPolicies() {
        return this.pipelinePolicies;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public Response<BinaryData> send(HttpRequest request) {
        HttpPipelineNextPolicy next = new HttpPipelineNextPolicy(new HttpPipelineCallState(this, request));
        return next.process();
    }
}

