/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.utils;

import io.clientcore.core.http.models.HttpHeader;
import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpResponseException;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.implementation.utils.UriEscapers;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.instrumentation.logging.ExceptionLoggingEvent;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.serialization.SerializationFormat;
import io.clientcore.core.serialization.json.JsonSerializer;
import io.clientcore.core.serialization.xml.XmlSerializer;
import io.clientcore.core.utils.CoreUtils;
import io.clientcore.core.utils.UriBuilder;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class GeneratedCodeUtils {
    private static final String UNEXPECTED_SERVER_RESPONSE_MESSAGE = "Unexpected server response.";

    public static void addQueryParameter(UriBuilder uriBuilder, String name, boolean escapeName, Object value, boolean escapeValue) {
        String nameToAdd;
        if (value == null) {
            return;
        }
        String string = nameToAdd = escapeName ? UriEscapers.QUERY_ESCAPER.escape(name) : name;
        if (value instanceof List) {
            List valueList = (List)value;
            ArrayList<String> valuesToAdd = new ArrayList<String>(valueList.size());
            for (Object v : valueList) {
                String valueToAdd = escapeValue ? UriEscapers.QUERY_ESCAPER.escape(String.valueOf(v)) : String.valueOf(v);
                valuesToAdd.add(valueToAdd);
            }
            uriBuilder.addQueryParameterValues(nameToAdd, valuesToAdd);
        } else if (value instanceof OffsetDateTime) {
            uriBuilder.addQueryParameter(nameToAdd, ((OffsetDateTime)value).format(DateTimeFormatter.ISO_INSTANT));
        } else {
            String valueToAdd = escapeValue ? UriEscapers.QUERY_ESCAPER.escape(String.valueOf(value)) : String.valueOf(value);
            uriBuilder.addQueryParameter(nameToAdd, valueToAdd);
        }
    }

    public static void handleUnexpectedResponse(int responseCode, Response<BinaryData> networkResponse, JsonSerializer jsonSerializer, XmlSerializer xmlSerializer, ParameterizedType defaultErrorBodyType, Map<Integer, ParameterizedType> statusToExceptionTypeMap, ClientLogger logger) {
        BinaryData networkResponseValue = networkResponse.getValue();
        try {
            Object errorValue;
            ExceptionLoggingEvent loggedException;
            block9: {
                HttpHeader contentLengthHeader;
                loggedException = logger.throwableAtError().addKeyValue("http.response.status_code", networkResponse.getStatusCode());
                HttpHeader contentTypeHeader = networkResponse.getHeaders().get(HttpHeaderName.CONTENT_TYPE);
                if (contentTypeHeader != null) {
                    loggedException.addKeyValue("http.response.header.content-type", contentTypeHeader.getValue());
                }
                if ((contentLengthHeader = networkResponse.getHeaders().get(HttpHeaderName.CONTENT_LENGTH)) != null) {
                    loggedException.addKeyValue("http.response.header.content-length", contentLengthHeader.getValue());
                }
                if (networkResponseValue == null || networkResponseValue.toBytes().length == 0 || contentTypeHeader != null && "application/octet-stream".equalsIgnoreCase(contentTypeHeader.getValue())) {
                    throw loggedException.log(UNEXPECTED_SERVER_RESPONSE_MESSAGE, m -> GeneratedCodeUtils.createHttpResponseException(m, networkResponse, null));
                }
                ParameterizedType returnType = statusToExceptionTypeMap != null && statusToExceptionTypeMap.containsKey(responseCode) ? statusToExceptionTypeMap.get(responseCode) : (defaultErrorBodyType != null ? defaultErrorBodyType : CoreUtils.createParameterizedType(Object.class, new Type[0]));
                SerializationFormat serializationFormat = CoreUtils.serializationFormatFromContentType(networkResponse.getHeaders());
                try {
                    if (jsonSerializer.supportsFormat(serializationFormat)) {
                        errorValue = CoreUtils.decodeNetworkResponse(networkResponseValue, jsonSerializer, returnType);
                        break block9;
                    }
                    if (xmlSerializer.supportsFormat(serializationFormat)) {
                        errorValue = CoreUtils.decodeNetworkResponse(networkResponseValue, xmlSerializer, returnType);
                        break block9;
                    }
                    throw loggedException.addKeyValue("serializationFormat", serializationFormat.name()).log("None of the provided serializers support the format.", m -> new HttpResponseException((String)m, networkResponse, null));
                }
                catch (RuntimeException ex) {
                    throw loggedException.log("Error reading response body.", ex, (m, c) -> new HttpResponseException((String)m, networkResponse, (Throwable)c));
                }
            }
            throw loggedException.addKeyValue("http.response.body.content", new String(networkResponseValue.toBytes(), StandardCharsets.UTF_8)).log(UNEXPECTED_SERVER_RESPONSE_MESSAGE, null, (m, c) -> GeneratedCodeUtils.createHttpResponseException(m, networkResponse, errorValue));
        }
        catch (Throwable throwable) {
            networkResponse.close();
            throw throwable;
        }
    }

    private static HttpResponseException createHttpResponseException(String message, Response<BinaryData> response, Object decodedValue) {
        if (decodedValue instanceof Throwable) {
            return new HttpResponseException(message, response, (Throwable)decodedValue);
        }
        return new HttpResponseException(message, response, decodedValue);
    }

    private GeneratedCodeUtils() {
    }
}

