/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.serialization.json.implementation.jackson.core.io;

import io.clientcore.core.serialization.json.implementation.jackson.core.io.CharTypes;
import io.clientcore.core.serialization.json.implementation.jackson.core.util.ByteArrayBuilder;
import java.util.Arrays;

public final class JsonStringEncoder {
    private static final char[] HC = CharTypes.copyHexChars();
    private static final byte[] HB = CharTypes.copyHexBytes();
    private static final int SURR1_FIRST = 55296;
    private static final int SURR1_LAST = 56319;
    private static final int SURR2_FIRST = 56320;
    private static final int SURR2_LAST = 57343;
    static final int MIN_BYTE_BUFFER_SIZE = 24;
    static final int MAX_BYTE_BUFFER_SIZE = 32000;

    private JsonStringEncoder() {
    }

    public static void quoteAsString(CharSequence input, StringBuilder output) {
        int[] escCodes = CharTypes.get7BitOutputEscapes();
        int escCodeCount = escCodes.length;
        int inPtr = 0;
        int inputLen = input.length();
        char[] qbuf = null;
        block0: while (inPtr < inputLen) {
            char d;
            int escCode;
            char c;
            while ((c = input.charAt(inPtr)) >= escCodeCount || escCodes[c] == 0) {
                output.append(c);
                if (++inPtr < inputLen) continue;
                break block0;
            }
            if (qbuf == null) {
                qbuf = JsonStringEncoder._qbuf();
            }
            int length = (escCode = escCodes[d = input.charAt(inPtr++)]) < 0 ? JsonStringEncoder._appendNumeric(d, qbuf) : JsonStringEncoder._appendNamed(escCode, qbuf);
            output.append(qbuf, 0, length);
        }
    }

    public static byte[] quoteAsUTF8(String text) {
        int inputPtr = 0;
        int inputEnd = text.length();
        int outputPtr = 0;
        byte[] outputBuffer = new byte[JsonStringEncoder._initialByteBufSize(inputEnd)];
        ByteArrayBuilder bb = null;
        block0: while (inputPtr < inputEnd) {
            int ch;
            int[] escCodes = CharTypes.get7BitOutputEscapes();
            while ((ch = text.charAt(inputPtr)) <= 127 && escCodes[ch] == 0) {
                if (outputPtr >= outputBuffer.length) {
                    if (bb == null) {
                        bb = ByteArrayBuilder.fromInitial(outputBuffer, outputPtr);
                    }
                    outputBuffer = bb.finishCurrentSegment();
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)ch;
                if (++inputPtr < inputEnd) continue;
                break block0;
            }
            if (bb == null) {
                bb = ByteArrayBuilder.fromInitial(outputBuffer, outputPtr);
            }
            if (outputPtr >= outputBuffer.length) {
                outputBuffer = bb.finishCurrentSegment();
                outputPtr = 0;
            }
            if ((ch = text.charAt(inputPtr++)) <= 127) {
                int escape = escCodes[ch];
                outputPtr = JsonStringEncoder._appendByte(ch, escape, bb, outputPtr);
                outputBuffer = bb.getCurrentSegment();
                continue;
            }
            if (ch <= 2047) {
                outputBuffer[outputPtr++] = (byte)(0xC0 | ch >> 6);
            } else {
                if (ch < 55296 || ch > 57343) {
                    outputBuffer[outputPtr++] = (byte)(0xE0 | ch >> 12);
                } else {
                    if (ch > 56319) {
                        JsonStringEncoder._illegal(ch);
                    }
                    if (inputPtr >= inputEnd) {
                        JsonStringEncoder._illegal(ch);
                    }
                    if ((ch = JsonStringEncoder._convert(ch, text.charAt(inputPtr++))) > 0x10FFFF) {
                        JsonStringEncoder._illegal(ch);
                    }
                    outputBuffer[outputPtr++] = (byte)(0xF0 | ch >> 18);
                    if (outputPtr >= outputBuffer.length) {
                        outputBuffer = bb.finishCurrentSegment();
                        outputPtr = 0;
                    }
                    outputBuffer[outputPtr++] = (byte)(0x80 | ch >> 12 & 0x3F);
                }
                if (outputPtr >= outputBuffer.length) {
                    outputBuffer = bb.finishCurrentSegment();
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)(0x80 | ch >> 6 & 0x3F);
            }
            ch = 0x80 | ch & 0x3F;
            if (outputPtr >= outputBuffer.length) {
                outputBuffer = bb.finishCurrentSegment();
                outputPtr = 0;
            }
            outputBuffer[outputPtr++] = (byte)ch;
        }
        if (bb == null) {
            return Arrays.copyOfRange(outputBuffer, 0, outputPtr);
        }
        return bb.completeAndCoalesce(outputPtr);
    }

    private static char[] _qbuf() {
        char[] qbuf = new char[6];
        qbuf[0] = 92;
        qbuf[2] = 48;
        qbuf[3] = 48;
        return qbuf;
    }

    private static int _appendNumeric(int value, char[] qbuf) {
        qbuf[1] = 117;
        qbuf[4] = HC[value >> 4];
        qbuf[5] = HC[value & 0xF];
        return 6;
    }

    private static int _appendNamed(int esc, char[] qbuf) {
        qbuf[1] = (char)esc;
        return 2;
    }

    private static int _appendByte(int ch, int esc, ByteArrayBuilder bb, int ptr) {
        bb.setCurrentSegmentLength(ptr);
        bb.append(92);
        if (esc < 0) {
            bb.append(117);
            if (ch > 255) {
                int hi = ch >> 8;
                bb.append(HB[hi >> 4]);
                bb.append(HB[hi & 0xF]);
                ch &= 0xFF;
            } else {
                bb.append(48);
                bb.append(48);
            }
            bb.append(HB[ch >> 4]);
            bb.append(HB[ch & 0xF]);
        } else {
            bb.append((byte)esc);
        }
        return bb.getCurrentSegmentLength();
    }

    private static int _convert(int p1, int p2) {
        if (p2 < 56320 || p2 > 57343) {
            throw new IllegalArgumentException("Broken surrogate pair: first char 0x" + Integer.toHexString(p1) + ", second 0x" + Integer.toHexString(p2) + "; illegal combination");
        }
        return 65536 + (p1 - 55296 << 10) + (p2 - 56320);
    }

    private static void _illegal(int c) {
        throw new IllegalArgumentException(JsonStringEncoder.illegalSurrogateDesc(c));
    }

    static String illegalSurrogateDesc(int code) {
        if (code > 0x10FFFF) {
            return "Illegal character point (0x" + Integer.toHexString(code) + ") to output; max is 0x10FFFF as per RFC 4627";
        }
        if (code >= 55296) {
            if (code <= 56319) {
                return "Unmatched first part of surrogate pair (0x" + Integer.toHexString(code) + ")";
            }
            return "Unmatched second part of surrogate pair (0x" + Integer.toHexString(code) + ")";
        }
        return "Illegal character point (0x" + Integer.toHexString(code) + ") to output";
    }

    static int _initialByteBufSize(int strLen) {
        int doubled = Math.max(24, strLen + 6 + (strLen >> 1));
        return Math.min(doubled, 32000);
    }
}

