/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.instrumentation.logging;

import io.clientcore.core.implementation.AccessibleByteArrayOutputStream;
import io.clientcore.core.implementation.instrumentation.DefaultLogger;
import io.clientcore.core.implementation.instrumentation.Slf4jLoggerShim;
import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.logging.LogLevel;
import io.clientcore.core.serialization.json.JsonWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public final class LoggingEvent {
    private static final LoggingEvent NOOP = new LoggingEvent(null, null, null, false);
    private final Slf4jLoggerShim logger;
    private final LogLevel level;
    private final Map<String, Object> globalPairs;
    private final boolean isEnabled;
    private Map<String, Object> keyValuePairs;
    private InstrumentationContext context = null;
    private Throwable throwable = null;

    static LoggingEvent create(Slf4jLoggerShim logger, LogLevel level, Map<String, Object> globalContext) {
        if (logger.canLogAtLevel(level)) {
            return new LoggingEvent(logger, level, globalContext, true);
        }
        return NOOP;
    }

    LoggingEvent(Slf4jLoggerShim logger, LogLevel level, Map<String, Object> globalContext, boolean isEnabled) {
        this.logger = logger;
        this.level = level;
        this.isEnabled = isEnabled;
        this.globalPairs = globalContext;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public LoggingEvent addKeyValue(String key, String value) {
        if (this.isEnabled) {
            this.addKeyValueInternal(key, value);
        }
        return this;
    }

    public LoggingEvent addKeyValue(String key, Object value) {
        if (this.isEnabled) {
            this.addKeyValueInternal(key, value);
        }
        return this;
    }

    public LoggingEvent addKeyValue(String key, boolean value) {
        if (this.isEnabled) {
            this.addKeyValueInternal(key, value);
        }
        return this;
    }

    public LoggingEvent addKeyValue(String key, long value) {
        if (this.isEnabled) {
            this.addKeyValueInternal(key, value);
        }
        return this;
    }

    public LoggingEvent addKeyValue(String key, Supplier<String> valueSupplier) {
        if (this.isEnabled && valueSupplier != null) {
            this.addKeyValue(key, valueSupplier.get());
        }
        return this;
    }

    public LoggingEvent setInstrumentationContext(InstrumentationContext context) {
        this.context = context;
        return this;
    }

    public LoggingEvent setThrowable(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    public LoggingEvent setEventName(String eventName) {
        this.addKeyValueInternal("event.name", eventName);
        return this;
    }

    public void log() {
        this.log((String)null);
    }

    public void log(String message) {
        this.performLogging(message);
    }

    public void log(Supplier<String> message) {
        if (this.isEnabled) {
            this.performLogging(message.get());
        }
    }

    private void performLogging(String message) {
        if (this.logger != null && this.logger.canLogAtLevel(this.level)) {
            this.logger.performLogging(this.level, this.getMessageWithContext(message), this.logger.canLogAtLevel(LogLevel.VERBOSE) ? this.throwable : null);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getMessageWithContext(String message) {
        if (this.context != null && this.context.isValid()) {
            this.addKeyValue("trace.id", this.context.getTraceId());
            this.addKeyValue("span.id", this.context.getSpanId());
        }
        if (this.throwable != null) {
            this.recordExceptionDetails(this.throwable, this.throwable.getMessage());
        }
        int pairsCount = (this.keyValuePairs == null ? 0 : this.keyValuePairs.size()) + (this.globalPairs == null ? 0 : this.globalPairs.size());
        int messageLength = message == null ? 0 : message.length();
        int speculatedSize = 20 + pairsCount * 20 + messageLength;
        try (AccessibleByteArrayOutputStream outputStream = new AccessibleByteArrayOutputStream(speculatedSize);){
            String string;
            block16: {
                JsonWriter jsonWriter = JsonWriter.toStream(outputStream);
                try {
                    jsonWriter.writeStartObject();
                    if (message != null) {
                        jsonWriter.writeStringField("message", message);
                    }
                    this.writeContext(jsonWriter);
                    jsonWriter.writeEndObject().flush();
                    string = outputStream.toString(StandardCharsets.UTF_8);
                    if (jsonWriter == null) break block16;
                }
                catch (Throwable throwable) {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonWriter.close();
            }
            return string;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    void recordExceptionDetails(Throwable throwable, String message) {
        this.addKeyValueInternal("exception.type", throwable.getClass().getCanonicalName());
        if (message != null) {
            this.addKeyValueInternal("exception.message", message);
        }
        if (this.logger != null && this.logger.canLogAtLevel(LogLevel.VERBOSE)) {
            StringBuilder stackTrace = new StringBuilder();
            if (throwable.getStackTrace().length > 0) {
                DefaultLogger.appendThrowable(stackTrace, throwable);
            } else {
                stackTrace.append("stacktrace disabled");
            }
            this.addKeyValue("exception.stacktrace", stackTrace.toString());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    String getExceptionMessageWithContext(String shortMessage, Throwable cause) {
        int pairsCount;
        while (cause != null && cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause != null) {
            this.addKeyValue("cause.type", cause.getClass().getCanonicalName());
            this.addKeyValue("cause.message", cause.getMessage());
        }
        if ((pairsCount = (this.keyValuePairs == null ? 0 : this.keyValuePairs.size()) + (this.globalPairs == null ? 0 : this.globalPairs.size())) == 0) {
            return shortMessage;
        }
        int speculatedSize = 20 + pairsCount * 20;
        try (AccessibleByteArrayOutputStream outputStream = new AccessibleByteArrayOutputStream(speculatedSize);){
            String string;
            block16: {
                JsonWriter jsonWriter = JsonWriter.toStream(outputStream);
                try {
                    jsonWriter.writeStartObject();
                    this.writeContext(jsonWriter);
                    jsonWriter.writeEndObject().flush();
                    String context = outputStream.toString(StandardCharsets.UTF_8);
                    String string2 = string = shortMessage == null ? context : shortMessage + "; " + context;
                    if (jsonWriter == null) break block16;
                }
                catch (Throwable throwable) {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonWriter.close();
            }
            return string;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private void writeContext(JsonWriter jsonWriter) throws IOException {
        if (this.globalPairs != null) {
            for (Map.Entry<String, Object> kvp : this.globalPairs.entrySet()) {
                jsonWriter.writeUntypedField(kvp.getKey(), kvp.getValue());
            }
        }
        if (this.keyValuePairs != null) {
            for (Map.Entry<String, Object> kvp : this.keyValuePairs.entrySet()) {
                jsonWriter.writeUntypedField(kvp.getKey(), kvp.getValue());
            }
        }
    }

    private void addKeyValueInternal(String key, Object value) {
        if (this.keyValuePairs == null) {
            this.keyValuePairs = new HashMap<String, Object>();
        }
        this.keyValuePairs.put(key, value);
    }
}

