/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.utils;

import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.utils.AuthenticateChallenge;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public final class AuthenticateChallengeParser {
    private static final ClientLogger LOGGER = new ClientLogger(AuthenticateChallengeParser.class);
    private static final boolean[] VALID_TOKEN_CHARS = new boolean[128];
    private static final boolean[] VALID_TOKEN68_CHARS = new boolean[128];
    private final String challenge;
    private final int challengeLength;
    private State state = State.BEGINNING;
    private int currentIndex;
    private AuthenticateChallengeToken token;

    public AuthenticateChallengeParser(String challenge) {
        char currentCharacter;
        this.challenge = Objects.requireNonNull(challenge, "challenge cannot be null.");
        this.challengeLength = challenge.length();
        this.currentIndex = 0;
        while (this.currentIndex < this.challengeLength && ((currentCharacter = challenge.charAt(this.currentIndex)) == ',' || currentCharacter == ' ' || currentCharacter == '\t')) {
            ++this.currentIndex;
        }
    }

    public List<AuthenticateChallenge> parse() {
        ArrayList<AuthenticateChallenge> authenticateChallenges = new ArrayList<AuthenticateChallenge>();
        String scheme = null;
        String token68 = null;
        LinkedHashMap<String, String> parameters = null;
        while (this.next()) {
            if (this.token.scheme != null) {
                if (scheme != null) {
                    authenticateChallenges.add(this.createChallenge(scheme, token68, parameters));
                    parameters = null;
                    token68 = null;
                }
                scheme = this.token.scheme;
                continue;
            }
            if (this.token.token68 != null) {
                if (scheme == null) {
                    throw LOGGER.throwableAtError().addKeyValue("challenge", this.challenge).log("Challenge had token68 before scheme.", IllegalArgumentException::new);
                }
                if (token68 != null) {
                    throw LOGGER.throwableAtError().addKeyValue("challenge", this.challenge).log("Challenge had multiple token68s.", IllegalArgumentException::new);
                }
                token68 = this.token.token68;
                continue;
            }
            if (this.token.authParam == null) continue;
            if (scheme == null) {
                throw LOGGER.throwableAtError().addKeyValue("challenge", this.challenge).log("Challenge had auth-param before scheme.", IllegalArgumentException::new);
            }
            if (parameters == null) {
                parameters = new LinkedHashMap<String, String>();
            }
            if (parameters.put(this.token.authParam.getKey(), this.token.authParam.getValue()) == null) continue;
            throw LOGGER.throwableAtError().addKeyValue("challenge", this.challenge).log("Challenge had duplicate auth-param.", IllegalArgumentException::new);
        }
        if (scheme != null) {
            authenticateChallenges.add(this.createChallenge(scheme, token68, parameters));
        }
        return authenticateChallenges;
    }

    private AuthenticateChallenge createChallenge(String scheme, String token68, Map<String, String> parameters) {
        if (token68 == null && parameters == null) {
            return new AuthenticateChallenge(scheme);
        }
        if (token68 == null) {
            return new AuthenticateChallenge(scheme, parameters);
        }
        if (parameters == null) {
            return new AuthenticateChallenge(scheme, token68);
        }
        throw LOGGER.throwableAtError().addKeyValue("challenge", this.challenge).log("Challenge had both token68 and auth-params.", IllegalArgumentException::new);
    }

    boolean next() {
        if (this.currentIndex >= this.challengeLength) {
            return false;
        }
        if (this.state == State.BEGINNING) {
            this.handleBeginning();
        } else if (this.state == State.SCHEME) {
            this.handleScheme();
        } else if (this.state == State.CHALLENGE_SEPARATOR) {
            this.handleChallenge();
        }
        return true;
    }

    private char iterateUntil(Predicate<Character> until) {
        while (this.currentIndex < this.challengeLength) {
            char c = this.challenge.charAt(this.currentIndex);
            if (until.test(Character.valueOf(c))) {
                return c;
            }
            ++this.currentIndex;
        }
        return '\u0000';
    }

    private char iterateUntilNextNonSpace() {
        ++this.currentIndex;
        return this.iterateUntil(c -> c.charValue() != ' ' && c.charValue() != '\t');
    }

    private char iterateUntilEqualsSpaceOrComma() {
        return this.iterateUntil(c -> c.charValue() == '=' || c.charValue() == ' ' || c.charValue() == ',');
    }

    private void handleBeginning() {
        int start = this.currentIndex;
        char c = this.iterateUntil(c1 -> c1.charValue() == ' ' || c1.charValue() == '\t' || c1.charValue() == ',');
        this.token = this.handleSchemeToken(start, this.currentIndex, c, false);
    }

    private AuthenticateChallengeToken handleSchemeToken(int schemeStartInclusive, int schemeEndExclusive, char currentChar, boolean alreadyInNextState) {
        String scheme = this.challenge.substring(schemeStartInclusive, schemeEndExclusive);
        if (!AuthenticateChallengeParser.isValidToken(scheme)) {
            throw LOGGER.throwableAtError().addKeyValue("challenge", this.challenge).addKeyValue("scheme", scheme).log("Scheme contained an invalid character.", IllegalArgumentException::new);
        }
        char c = currentChar = alreadyInNextState || currentChar == ',' ? currentChar : this.iterateUntilNextNonSpace();
        if (this.currentIndex < this.challengeLength && currentChar == ',') {
            this.state = State.CHALLENGE_SEPARATOR;
            this.iterateUntilNextNonSpace();
        } else {
            this.state = State.SCHEME;
        }
        return new AuthenticateChallengeToken(scheme, null, null);
    }

    private void handleScheme() {
        int start = this.currentIndex;
        char c = this.iterateUntilEqualsSpaceOrComma();
        if (c == ',' || this.currentIndex == this.challengeLength) {
            this.token = new AuthenticateChallengeToken(null, AuthenticateChallengeParser.validateToken68(this.challenge, start, this.currentIndex), null);
        } else if (c == ' ') {
            int token68OrParamKeyEnd = this.currentIndex;
            c = this.iterateUntilNextNonSpace();
            if (c != '=' && c != ',' && this.currentIndex < this.challengeLength) {
                throw LOGGER.throwableAtError().addKeyValue("challenge", this.challenge).log("Challenge had more than one token68 or auth-param in the same comma separator.", IllegalArgumentException::new);
            }
            if (c == ',' || this.currentIndex == this.challengeLength) {
                String token68 = AuthenticateChallengeParser.validateToken68(this.challenge, start, this.currentIndex);
                this.token = new AuthenticateChallengeToken(null, token68, null);
            } else {
                this.createAuthParamToken(start, token68OrParamKeyEnd, this.iterateUntilNextNonSpace());
            }
        } else {
            int equalsIndex = this.currentIndex;
            if (this.currentIndex + 1 == this.challengeLength || this.challenge.charAt(this.currentIndex + 1) == '=') {
                c = this.iterateUntil(c1 -> c1.charValue() != '=');
                this.token = new AuthenticateChallengeToken(null, AuthenticateChallengeParser.validateToken68(this.challenge, start, this.currentIndex), null);
            } else {
                c = this.iterateUntilNextNonSpace();
                if (c == ',' || this.currentIndex == this.challengeLength) {
                    this.token = new AuthenticateChallengeToken(null, AuthenticateChallengeParser.validateToken68(this.challenge, start, equalsIndex + 1), null);
                } else {
                    c = this.createAuthParamToken(start, equalsIndex, c);
                }
            }
            char c2 = c = c == ',' || this.currentIndex == this.challengeLength ? c : this.iterateUntilNextNonSpace();
            if (this.currentIndex < this.challengeLength && c != ',') {
                throw LOGGER.throwableAtError().addKeyValue("challenge", this.challenge).log("Challenge had more than one token68 or auth-param in the same comma separator.", IllegalArgumentException::new);
            }
        }
        this.state = State.CHALLENGE_SEPARATOR;
        this.iterateUntilNextNonSpace();
    }

    private char createAuthParamToken(int keyStartInclusive, int keyEndExclusive, char currentChar) {
        String authParamValue;
        String authParamKey = this.challenge.substring(keyStartInclusive, keyEndExclusive);
        if (!AuthenticateChallengeParser.isValidToken(authParamKey)) {
            throw LOGGER.throwableAtError().addKeyValue("challenge", this.challenge).addKeyValue("authParamKey", authParamKey).log("Auth-param key contained an invalid character.", IllegalArgumentException::new);
        }
        int start = this.currentIndex++;
        if (currentChar == '\"') {
            ++start;
            currentChar = this.iterateUntil(c1 -> c1.charValue() == '\"' && this.challenge.charAt(this.currentIndex - 1) != '\\');
            if (currentChar != '\"') {
                throw LOGGER.throwableAtError().addKeyValue("challenge", this.challenge).log("Quoted-string in challenge was not terminated with a double quote.", IllegalArgumentException::new);
            }
            authParamValue = this.challenge.substring(start, this.currentIndex).replace("\\\\", "");
        } else {
            currentChar = this.iterateUntil(c1 -> c1.charValue() == ' ' || c1.charValue() == '\t' || c1.charValue() == ',');
            authParamValue = this.challenge.substring(start, this.currentIndex);
            if (!AuthenticateChallengeParser.isValidToken(authParamValue)) {
                throw LOGGER.throwableAtError().addKeyValue("challenge", this.challenge).addKeyValue("authParamValue", authParamValue).log("Auth-param value contained an invalid character.", IllegalArgumentException::new);
            }
        }
        char c = currentChar = currentChar == ',' ? currentChar : this.iterateUntilNextNonSpace();
        if (this.currentIndex < this.challengeLength && currentChar != ',') {
            throw LOGGER.throwableAtError().addKeyValue("challenge", this.challenge).log("Challenge had more than one token68 or auth-param in the same comma separator.", IllegalArgumentException::new);
        }
        this.token = new AuthenticateChallengeToken(null, null, new AbstractMap.SimpleEntry<String, String>(authParamKey, authParamValue));
        return currentChar;
    }

    private void handleChallenge() {
        int start = this.currentIndex;
        char c = this.iterateUntil(c1 -> c1.charValue() == ' ' || c1.charValue() == '\t' || c1.charValue() == ',' || c1.charValue() == '=');
        if (c == ',' || this.currentIndex == this.challengeLength) {
            this.token = this.handleSchemeToken(start, this.currentIndex, c, true);
        } else if (c == '=') {
            this.createAuthParamToken(start, this.currentIndex, this.iterateUntilNextNonSpace());
            this.state = State.CHALLENGE_SEPARATOR;
            this.iterateUntilNextNonSpace();
        } else {
            int end = this.currentIndex;
            c = this.iterateUntilNextNonSpace();
            if (c == '=') {
                this.createAuthParamToken(start, end, this.iterateUntilNextNonSpace());
                this.state = State.CHALLENGE_SEPARATOR;
                this.iterateUntilNextNonSpace();
            } else {
                this.token = this.handleSchemeToken(start, end, c, true);
            }
        }
    }

    private static boolean isValidTokenCharacter(char c) {
        return c < '\u0080' && VALID_TOKEN_CHARS[c];
    }

    private static boolean isValidToken(String token) {
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (AuthenticateChallengeParser.isValidTokenCharacter(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidToken68Character(char c) {
        return c < '\u0080' && VALID_TOKEN68_CHARS[c];
    }

    private static String validateToken68(String challenge, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = challenge.charAt(i);
            if (c == '=') {
                ++i;
                while (i < end) {
                    c = challenge.charAt(i);
                    if (c != '=') {
                        throw LOGGER.throwableAtError().addKeyValue("challenge", challenge).addKeyValue("token68", challenge.substring(start, end)).addKeyValue("character", c).addKeyValue("index", i).log("Token68 contained an invalid character.", IllegalArgumentException::new);
                    }
                    ++i;
                }
                continue;
            }
            if (AuthenticateChallengeParser.isValidToken68Character(c)) continue;
            throw LOGGER.throwableAtError().addKeyValue("challenge", challenge).addKeyValue("token68", challenge.substring(start, end)).addKeyValue("character", c).addKeyValue("index", i).log("Token68 contained an invalid character.", IllegalArgumentException::new);
        }
        return challenge.substring(start, end);
    }

    static {
        Arrays.fill(VALID_TOKEN68_CHARS, 48, 58, true);
        Arrays.fill(VALID_TOKEN68_CHARS, 65, 91, true);
        Arrays.fill(VALID_TOKEN68_CHARS, 97, 123, true);
        AuthenticateChallengeParser.VALID_TOKEN68_CHARS[45] = true;
        AuthenticateChallengeParser.VALID_TOKEN68_CHARS[46] = true;
        AuthenticateChallengeParser.VALID_TOKEN68_CHARS[95] = true;
        AuthenticateChallengeParser.VALID_TOKEN68_CHARS[126] = true;
        AuthenticateChallengeParser.VALID_TOKEN68_CHARS[43] = true;
        System.arraycopy(VALID_TOKEN68_CHARS, 0, VALID_TOKEN_CHARS, 0, 128);
        AuthenticateChallengeParser.VALID_TOKEN_CHARS[33] = true;
        AuthenticateChallengeParser.VALID_TOKEN_CHARS[35] = true;
        AuthenticateChallengeParser.VALID_TOKEN_CHARS[36] = true;
        AuthenticateChallengeParser.VALID_TOKEN_CHARS[37] = true;
        AuthenticateChallengeParser.VALID_TOKEN_CHARS[38] = true;
        AuthenticateChallengeParser.VALID_TOKEN_CHARS[39] = true;
        AuthenticateChallengeParser.VALID_TOKEN_CHARS[42] = true;
        AuthenticateChallengeParser.VALID_TOKEN_CHARS[94] = true;
        AuthenticateChallengeParser.VALID_TOKEN_CHARS[96] = true;
        AuthenticateChallengeParser.VALID_TOKEN_CHARS[124] = true;
        AuthenticateChallengeParser.VALID_TOKEN68_CHARS[47] = true;
    }

    private static enum State {
        BEGINNING,
        CHALLENGE_SEPARATOR,
        SCHEME;

    }

    private static class AuthenticateChallengeToken {
        final String scheme;
        final String token68;
        final Map.Entry<String, String> authParam;

        AuthenticateChallengeToken(String scheme, String token68, Map.Entry<String, String> authParam) {
            this.scheme = scheme;
            this.token68 = token68;
            this.authParam = authParam;
        }
    }
}

