/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.fallback;

import io.clientcore.core.http.models.RequestContext;
import io.clientcore.core.implementation.instrumentation.InstrumentationUtils;
import io.clientcore.core.implementation.instrumentation.NoopMeter;
import io.clientcore.core.implementation.instrumentation.SdkInstrumentationOptionsAccessHelper;
import io.clientcore.core.implementation.instrumentation.fallback.FallbackAttributes;
import io.clientcore.core.implementation.instrumentation.fallback.FallbackContextPropagator;
import io.clientcore.core.implementation.instrumentation.fallback.FallbackSpan;
import io.clientcore.core.implementation.instrumentation.fallback.FallbackSpanContext;
import io.clientcore.core.implementation.instrumentation.fallback.FallbackTracer;
import io.clientcore.core.instrumentation.Instrumentation;
import io.clientcore.core.instrumentation.InstrumentationAttributes;
import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.InstrumentationOptions;
import io.clientcore.core.instrumentation.SdkInstrumentationOptions;
import io.clientcore.core.instrumentation.metrics.Meter;
import io.clientcore.core.instrumentation.tracing.Span;
import io.clientcore.core.instrumentation.tracing.SpanBuilder;
import io.clientcore.core.instrumentation.tracing.SpanKind;
import io.clientcore.core.instrumentation.tracing.TraceContextPropagator;
import io.clientcore.core.instrumentation.tracing.Tracer;
import io.clientcore.core.instrumentation.tracing.TracingScope;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class FallbackInstrumentation
implements Instrumentation {
    public static final FallbackInstrumentation DEFAULT_INSTANCE = new FallbackInstrumentation(null, InstrumentationUtils.UNKNOWN_LIBRARY_OPTIONS, null, -1);
    private final boolean allowNestedSpans;
    private final boolean isTracingEnabled;
    private final FallbackTracer tracer;
    private final String serviceHost;
    private final int servicePort;

    public FallbackInstrumentation(InstrumentationOptions instrumentationOptions, SdkInstrumentationOptions sdkOptions, String host, int port) {
        this.allowNestedSpans = sdkOptions != null && SdkInstrumentationOptionsAccessHelper.isSpanSuppressionDisabled(sdkOptions);
        this.isTracingEnabled = instrumentationOptions == null || instrumentationOptions.isTracingEnabled();
        this.tracer = new FallbackTracer(instrumentationOptions, sdkOptions);
        this.serviceHost = host;
        this.servicePort = port;
    }

    @Override
    public Tracer getTracer() {
        return this.tracer;
    }

    @Override
    public Meter getMeter() {
        return NoopMeter.INSTANCE;
    }

    @Override
    public InstrumentationAttributes createAttributes(Map<String, Object> attributes) {
        return new FallbackAttributes(attributes);
    }

    @Override
    public TraceContextPropagator getW3CTraceContextPropagator() {
        return FallbackContextPropagator.W3C_TRACE_CONTEXT_PROPAGATOR;
    }

    @Override
    public <TResponse> TResponse instrumentWithResponse(String operationName, RequestContext requestContext, Function<RequestContext, TResponse> operation) {
        Objects.requireNonNull(operationName, "'operationName' cannot be null");
        Objects.requireNonNull(operation, "'operation' cannot be null");
        requestContext = requestContext == null ? RequestContext.none() : requestContext;
        InstrumentationContext context = requestContext.getInstrumentationContext();
        if (!this.shouldInstrument(SpanKind.CLIENT, context)) {
            return operation.apply(requestContext);
        }
        SpanBuilder builder = this.tracer.spanBuilder(operationName, SpanKind.CLIENT, context).setAttribute("server.address", this.serviceHost);
        if (this.servicePort > 0) {
            builder.setAttribute("server.port", this.servicePort);
        }
        Span span = builder.startSpan();
        RequestContext childContext = requestContext.toBuilder().setInstrumentationContext(span.getInstrumentationContext()).build();
        try (TracingScope scope = span.makeCurrent();){
            TResponse response = operation.apply(childContext);
            span.end();
            TResponse TResponse = response;
            return TResponse;
        }
    }

    @Override
    public <T> InstrumentationContext createInstrumentationContext(T context) {
        if (context instanceof InstrumentationContext) {
            return FallbackSpanContext.fromInstrumentationContext((InstrumentationContext)context);
        }
        if (context instanceof FallbackSpan) {
            return ((FallbackSpan)context).getInstrumentationContext();
        }
        return FallbackSpanContext.INVALID;
    }

    private boolean shouldInstrument(SpanKind spanKind, InstrumentationContext context) {
        if (!this.isTracingEnabled) {
            return false;
        }
        if (this.allowNestedSpans) {
            return true;
        }
        return spanKind != this.tryGetSpanKind(context);
    }

    private SpanKind tryGetSpanKind(InstrumentationContext context) {
        Span span;
        if (context instanceof FallbackSpanContext && (span = context.getSpan()) instanceof FallbackSpan) {
            return ((FallbackSpan)span).getSpanKind();
        }
        return null;
    }
}

