/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation.instrumentation.fallback;

import io.clientcore.core.implementation.instrumentation.fallback.FallbackSpanContext;
import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.instrumentation.tracing.Span;
import io.clientcore.core.instrumentation.tracing.TraceContextGetter;
import io.clientcore.core.instrumentation.tracing.TraceContextPropagator;
import io.clientcore.core.instrumentation.tracing.TraceContextSetter;

final class FallbackContextPropagator
implements TraceContextPropagator {
    private static final ClientLogger LOGGER = new ClientLogger(FallbackContextPropagator.class);
    static final TraceContextPropagator W3C_TRACE_CONTEXT_PROPAGATOR = new FallbackContextPropagator();

    private FallbackContextPropagator() {
    }

    @Override
    public <C> void inject(InstrumentationContext spanContext, C carrier, TraceContextSetter<C> setter) {
        if (spanContext.isValid()) {
            setter.set(carrier, "traceparent", "00-" + spanContext.getTraceId() + "-" + spanContext.getSpanId() + "-" + spanContext.getTraceFlags());
        }
    }

    @Override
    public <C> InstrumentationContext extract(InstrumentationContext context, C carrier, TraceContextGetter<C> getter) {
        String traceparent = getter.get(carrier, "traceparent");
        if (traceparent != null) {
            if (FallbackContextPropagator.isValidTraceparent(traceparent)) {
                String traceId = traceparent.substring(3, 35);
                String spanId = traceparent.substring(36, 52);
                String traceFlags = traceparent.substring(53, 55);
                return new FallbackSpanContext(traceId, spanId, traceFlags, true, Span.noop());
            }
            LOGGER.atVerbose().addKeyValue("http.request.header.traceparent", traceparent).log("Invalid traceparent header");
        }
        return context == null ? FallbackSpanContext.INVALID : context;
    }

    private static boolean isValidTraceparent(String traceparent) {
        char c;
        int i;
        if (traceparent == null || traceparent.length() != 55) {
            return false;
        }
        if (traceparent.charAt(0) != '0' || traceparent.charAt(1) != '0' || traceparent.charAt(2) != '-' || traceparent.charAt(35) != '-' || traceparent.charAt(52) != '-') {
            return false;
        }
        boolean isAllZero = true;
        for (i = 3; i < 35; ++i) {
            c = traceparent.charAt(i);
            if (c < '0' || c > 'f' || c > '9' && c < 'a') {
                return false;
            }
            if (c == '0') continue;
            isAllZero = false;
        }
        if (isAllZero) {
            return false;
        }
        isAllZero = true;
        for (i = 36; i < 52; ++i) {
            c = traceparent.charAt(i);
            if (c < '0' || c > 'f' || c > '9' && c < 'a') {
                return false;
            }
            if (c == '0') continue;
            isAllZero = false;
        }
        if (isAllZero) {
            return false;
        }
        for (i = 53; i < 55; ++i) {
            c = traceparent.charAt(i);
            if (c >= '0' && c <= 'f' && (c <= '9' || c >= 'a')) continue;
            return false;
        }
        return true;
    }
}

