/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.implementation;

import io.clientcore.core.implementation.ReflectionUtilsApi;
import io.clientcore.core.implementation.ReflectionUtilsClassic;
import io.clientcore.core.implementation.ReflectionUtilsMethodHandle;
import io.clientcore.core.implementation.ReflectiveInvoker;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public abstract class ReflectionUtils {
    private static final ClientLogger LOGGER;
    private static final ReflectionUtilsApi INSTANCE;

    public static ReflectiveInvoker getMethodInvoker(Class<?> targetClass, Method method) throws Exception {
        return ReflectionUtils.getMethodInvoker(targetClass, method, true);
    }

    public static ReflectiveInvoker getMethodInvoker(Class<?> targetClass, Method method, boolean scopeToClientCore) throws Exception {
        if (method == null) {
            throw LOGGER.throwableAtError().log("'method' cannot be null.", NullPointerException::new);
        }
        targetClass = targetClass == null ? method.getDeclaringClass() : targetClass;
        return INSTANCE.getMethodInvoker(targetClass, method, scopeToClientCore);
    }

    public static ReflectiveInvoker getConstructorInvoker(Class<?> targetClass, Constructor<?> constructor) throws Exception {
        return ReflectionUtils.getConstructorInvoker(targetClass, constructor, true);
    }

    public static ReflectiveInvoker getConstructorInvoker(Class<?> targetClass, Constructor<?> constructor, boolean scopeToClientCore) throws Exception {
        if (constructor == null) {
            throw LOGGER.throwableAtError().log("'constructor' cannot be null.", NullPointerException::new);
        }
        targetClass = targetClass == null ? constructor.getDeclaringClass() : targetClass;
        return INSTANCE.getConstructorInvoker(targetClass, constructor, scopeToClientCore);
    }

    public static boolean isModuleBased() {
        return INSTANCE.isModuleBased();
    }

    public static ReflectiveInvoker createNoOpInvoker() {
        return new NoOpReflectiveInvoker();
    }

    ReflectionUtils() {
    }

    static {
        ReflectionUtilsApi instance;
        LOGGER = new ClientLogger(ReflectionUtils.class);
        try {
            LOGGER.atVerbose().log("Attempting to use java.lang.invoke package to handle reflection.");
            instance = new ReflectionUtilsMethodHandle();
            LOGGER.atVerbose().log("Successfully used java.lang.invoke package to handle reflection.");
        }
        catch (LinkageError ignored) {
            LOGGER.atVerbose().log("Failed to use java.lang.invoke package to handle reflection. Falling back to java.lang.reflect package to handle reflection.");
            instance = new ReflectionUtilsClassic();
            LOGGER.atVerbose().log("Successfully used java.lang.reflect package to handle reflection.");
        }
        INSTANCE = instance;
    }

    private static final class NoOpReflectiveInvoker
    implements ReflectiveInvoker {
        private NoOpReflectiveInvoker() {
        }

        @Override
        public Object invokeStatic(Object ... args) {
            return null;
        }

        @Override
        public Object invokeWithArguments(Object target, Object ... args) {
            return null;
        }

        @Override
        public Object invoke() {
            return null;
        }

        @Override
        public Object invoke(Object argOrTarget) {
            return null;
        }

        @Override
        public Object invoke(Object argOrTarget, Object arg1) {
            return null;
        }

        @Override
        public Object invoke(Object argOrTarget, Object arg1, Object arg2) {
            return null;
        }

        @Override
        public Object invoke(Object argOrTarget, Object arg1, Object arg2, Object arg3) {
            return null;
        }

        @Override
        public int getParameterCount() {
            return 0;
        }
    }
}

