/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.paging;

import io.clientcore.core.http.paging.PagedResponse;
import io.clientcore.core.http.paging.PagingOptions;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class PagedIterable<T>
implements Iterable<T> {
    private final Function<PagingContext, PagedResponse<T>> pageRetriever = context -> ((PagingContext)context).getNextLink() == null ? (PagedResponse)firstPageRetriever.apply(((PagingContext)context).getPagingOptions()) : (PagedResponse)nextPageRetriever.apply(((PagingContext)context).getPagingOptions(), ((PagingContext)context).getNextLink());

    public PagedIterable(Function<PagingOptions, PagedResponse<T>> firstPageRetriever) {
        this(firstPageRetriever, (pagingOptions, nextLink) -> null);
    }

    public PagedIterable(Function<PagingOptions, PagedResponse<T>> firstPageRetriever, BiFunction<PagingOptions, String, PagedResponse<T>> nextPageRetriever) {
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterableByItemInternal(null).iterator();
    }

    public Iterable<PagedResponse<T>> iterableByPage() {
        return this.iterableByPageInternal(null);
    }

    public Iterable<PagedResponse<T>> iterableByPage(PagingOptions pagingOptions) {
        return this.iterableByPageInternal(pagingOptions);
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.iterableByItemInternal(null).spliterator(), false);
    }

    public Stream<PagedResponse<T>> streamByPage() {
        return StreamSupport.stream(this.iterableByPage().spliterator(), false);
    }

    public Stream<PagedResponse<T>> streamByPage(PagingOptions pagingOptions) {
        return StreamSupport.stream(this.iterableByPage(pagingOptions).spliterator(), false);
    }

    private Iterable<T> iterableByItemInternal(PagingOptions pagingOptions) {
        return () -> new PagedIterator<T, T>(this.pageRetriever, pagingOptions){
            private Iterator<T> nextPage;
            private Iterator<T> currentPage;

            @Override
            boolean needToRequestPage() {
                return (this.currentPage == null || !this.currentPage.hasNext()) && this.nextPage == null;
            }

            @Override
            boolean isNextAvailable() {
                return this.currentPage != null && this.currentPage.hasNext() || this.nextPage != null;
            }

            @Override
            T getNext() {
                if (!(this.currentPage != null && this.currentPage.hasNext() || this.nextPage == null)) {
                    this.currentPage = this.nextPage;
                    this.nextPage = null;
                }
                return this.currentPage.next();
            }

            @Override
            void addPage(PagedResponse<T> page) {
                Iterator pageValues = ((List)page.getValue()).iterator();
                if (pageValues.hasNext()) {
                    this.nextPage = pageValues;
                }
            }
        };
    }

    private Iterable<PagedResponse<T>> iterableByPageInternal(PagingOptions pagingOptions) {
        return () -> new PagedIterator<T, PagedResponse<T>>(this.pageRetriever, pagingOptions){
            private PagedResponse<T> nextPage;

            @Override
            boolean needToRequestPage() {
                return this.nextPage == null;
            }

            @Override
            boolean isNextAvailable() {
                return this.nextPage != null;
            }

            @Override
            PagedResponse<T> getNext() {
                PagedResponse currentPage = this.nextPage;
                this.nextPage = null;
                return currentPage;
            }

            @Override
            void addPage(PagedResponse<T> page) {
                this.nextPage = page;
            }
        };
    }

    private static final class PagingContext {
        private final PagingOptions pagingOptions;
        private final String nextLink;

        private PagingContext(PagingOptions pagingOptions, String nextLink) {
            this.pagingOptions = pagingOptions;
            this.nextLink = nextLink;
        }

        private PagingOptions getPagingOptions() {
            return this.pagingOptions;
        }

        private String getNextLink() {
            return this.nextLink;
        }
    }

    private static abstract class PagedIterator<T, E>
    implements Iterator<E> {
        private static final ClientLogger LOGGER = new ClientLogger(PagedIterator.class);
        private final Function<PagingContext, PagedResponse<T>> pageRetriever;
        private final Long pageSize;
        private String continuationToken;
        private String nextLink;
        private boolean done;

        PagedIterator(Function<PagingContext, PagedResponse<T>> pageRetriever, PagingOptions pagingOptions) {
            this.pageRetriever = pageRetriever;
            this.pageSize = pagingOptions == null ? null : pagingOptions.getPageSize();
            this.continuationToken = pagingOptions == null ? null : pagingOptions.getContinuationToken();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw LOGGER.throwableAtError().log("Iterator contains no more elements.", NoSuchElementException::new);
            }
            return this.getNext();
        }

        @Override
        public boolean hasNext() {
            while (!this.done && this.needToRequestPage()) {
                this.requestPage();
            }
            return this.isNextAvailable();
        }

        abstract boolean needToRequestPage();

        abstract boolean isNextAvailable();

        abstract E getNext();

        void requestPage() {
            boolean receivedPages = false;
            PagingOptions pagingOptions = new PagingOptions();
            pagingOptions.setPageSize(this.pageSize);
            pagingOptions.setContinuationToken(this.continuationToken);
            PagedResponse<T> page = this.pageRetriever.apply(new PagingContext(pagingOptions, this.nextLink));
            if (page != null) {
                this.receivePage(page);
                receivedPages = true;
            }
            this.done = this.done || !receivedPages && !this.isNextAvailable();
        }

        abstract void addPage(PagedResponse<T> var1);

        private void receivePage(PagedResponse<T> page) {
            this.addPage(page);
            this.nextLink = page.getNextLink();
            this.continuationToken = page.getContinuationToken();
            this.done = !(this.nextLink != null && !this.nextLink.isEmpty() || this.continuationToken != null && !this.continuationToken.isEmpty());
        }
    }
}

