/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.models;

import io.clientcore.core.http.models.HttpHeaders;
import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import io.clientcore.core.models.CoreException;
import java.io.Closeable;
import java.io.IOException;

public class Response<T>
implements Closeable {
    private static final ClientLogger LOGGER = new ClientLogger(Response.class);
    private final HttpHeaders headers;
    private final HttpRequest request;
    private final int statusCode;
    private final T value;

    public Response(HttpRequest request, int statusCode, HttpHeaders headers, T value) {
        this.request = request;
        this.statusCode = statusCode;
        this.headers = headers;
        this.value = value;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final HttpHeaders getHeaders() {
        return this.headers;
    }

    public final HttpRequest getRequest() {
        return this.request;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public void close() {
        if (this.value instanceof Closeable) {
            try {
                ((Closeable)this.value).close();
            }
            catch (IOException e) {
                throw LOGGER.throwableAtError().log(e, (msg, cause) -> CoreException.from(msg, cause, false));
            }
        }
    }
}

