/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.http.models;

import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.implementation.utils.InternalContext;
import io.clientcore.core.implementation.utils.UriEscapers;
import io.clientcore.core.instrumentation.InstrumentationContext;
import io.clientcore.core.instrumentation.logging.ClientLogger;
import java.util.Objects;
import java.util.function.Consumer;

public final class RequestContext {
    private static final RequestContext NONE = new RequestContext();
    private final Consumer<HttpRequest> requestCallback;
    private final InternalContext context;
    private final ClientLogger logger;
    private final InstrumentationContext instrumentationContext;

    private RequestContext() {
        this(r -> {}, null, null, InternalContext.empty());
    }

    private RequestContext(Consumer<HttpRequest> requestCallback, ClientLogger logger, InstrumentationContext instrumentationContext, InternalContext context) {
        Objects.requireNonNull(requestCallback, "'requestCallback' cannot be null.");
        Objects.requireNonNull(context, "'context' cannot be null.");
        this.requestCallback = requestCallback;
        this.context = context;
        this.logger = logger;
        this.instrumentationContext = instrumentationContext;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this.requestCallback, this.logger, this.instrumentationContext, this.context);
    }

    public Consumer<HttpRequest> getRequestCallback() {
        return this.requestCallback;
    }

    public ClientLogger getLogger() {
        return this.logger;
    }

    public static RequestContext none() {
        return NONE;
    }

    public InstrumentationContext getInstrumentationContext() {
        return this.instrumentationContext;
    }

    public Object getMetadata(String key) {
        Objects.requireNonNull(key, "'key' cannot be null.");
        return this.context.get(key);
    }

    public static class Builder {
        private Consumer<HttpRequest> requestCallback;
        private InternalContext context;
        private ClientLogger logger;
        private InstrumentationContext instrumentationContext;

        Builder() {
            this.requestCallback = r -> {};
            this.context = InternalContext.empty();
            this.logger = null;
            this.instrumentationContext = null;
        }

        Builder(Consumer<HttpRequest> requestCallback, ClientLogger logger, InstrumentationContext instrumentationContext, InternalContext context) {
            this.requestCallback = r -> {};
            this.context = InternalContext.empty();
            this.requestCallback = requestCallback;
            this.logger = logger;
            this.instrumentationContext = instrumentationContext;
            this.context = context;
        }

        public Builder addRequestCallback(Consumer<HttpRequest> requestCallback) {
            this.requestCallback = this.requestCallback.andThen(requestCallback);
            return this;
        }

        public Builder setLogger(ClientLogger logger) {
            this.logger = logger;
            return this;
        }

        public Builder setInstrumentationContext(InstrumentationContext instrumentationContext) {
            this.instrumentationContext = instrumentationContext;
            return this;
        }

        public Builder putMetadata(String key, Object value) {
            Objects.requireNonNull(key, "'key' cannot be null.");
            this.context = this.context.put(key, value);
            return this;
        }

        public Builder setHeader(HttpHeaderName name, String value) {
            Objects.requireNonNull(name, "'name' cannot be null.");
            Objects.requireNonNull(value, "'value' cannot be null.");
            this.requestCallback = this.requestCallback.andThen(request -> request.getHeaders().set(name, value));
            return this;
        }

        public Builder addQueryParam(String parameterName, String value) {
            return this.addQueryParam(parameterName, value, false);
        }

        public Builder addQueryParam(String parameterName, String value, boolean encoded) {
            Objects.requireNonNull(parameterName, "'parameterName' cannot be null.");
            this.requestCallback = this.requestCallback.andThen(request -> {
                String uri = request.getUri().toString();
                String encodedParameterName = encoded ? parameterName : UriEscapers.QUERY_ESCAPER.escape(parameterName);
                String encodedParameterValue = encoded ? value : UriEscapers.QUERY_ESCAPER.escape(value);
                request.setUri(uri + (uri.contains("?") ? "&" : "?") + encodedParameterName + "=" + encodedParameterValue);
            });
            return this;
        }

        public RequestContext build() {
            return new RequestContext(this.requestCallback, this.logger, this.instrumentationContext, this.context);
        }
    }
}

