/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.credentials.oauth;

import io.clientcore.core.credentials.oauth.AccessTokenType;
import java.time.OffsetDateTime;

public class AccessToken {
    private final String token;
    private final OffsetDateTime expiresAt;
    private final OffsetDateTime refreshAt;
    private final AccessTokenType tokenType;

    public AccessToken(String token, OffsetDateTime expiresAt) {
        this(token, expiresAt, null, AccessTokenType.BEARER);
    }

    public AccessToken(String token, OffsetDateTime expiresAt, OffsetDateTime refreshAt) {
        this(token, expiresAt, refreshAt, AccessTokenType.BEARER);
    }

    public AccessToken(String token, OffsetDateTime expiresAt, OffsetDateTime refreshAt, AccessTokenType tokenType) {
        this.token = token;
        this.expiresAt = expiresAt;
        this.refreshAt = refreshAt;
        this.tokenType = tokenType;
    }

    public String getToken() {
        return this.token;
    }

    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public OffsetDateTime getRefreshAt() {
        return this.refreshAt;
    }

    public boolean isExpired() {
        return OffsetDateTime.now().isAfter(this.expiresAt);
    }

    public AccessTokenType getTokenType() {
        return this.tokenType;
    }
}

