/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.core.credentials;

import io.clientcore.core.instrumentation.logging.ClientLogger;
import java.util.Objects;

public class KeyCredential {
    private static final ClientLogger LOGGER = new ClientLogger(KeyCredential.class);
    private volatile String key;

    public KeyCredential(String key) {
        Objects.requireNonNull(key, "'key' cannot be null.");
        if (key.isEmpty()) {
            throw LOGGER.throwableAtError().log("'key' cannot be empty.", IllegalArgumentException::new);
        }
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public KeyCredential update(String key) {
        Objects.requireNonNull(key, "'key' cannot be null.");
        if (key.isEmpty()) {
            throw LOGGER.throwableAtError().log("'key' cannot be empty.", IllegalArgumentException::new);
        }
        this.key = key;
        return this;
    }
}

