/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.annotation.processor.utils;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.TryStmt;
import io.clientcore.annotation.processor.models.HttpRequestContext;
import io.clientcore.annotation.processor.utils.AnnotationProcessorUtils;
import io.clientcore.annotation.processor.utils.TypeConverter;
import io.clientcore.core.http.models.HttpMethod;
import io.clientcore.core.implementation.TypeUtil;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.serialization.SerializationFormat;
import io.clientcore.core.utils.Base64Uri;
import io.clientcore.core.utils.CoreUtils;
import io.clientcore.core.utils.GeneratedCodeUtils;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class ResponseHandler {
    public static void generateResponseHandling(BlockStmt body, TypeMirror returnType, HttpRequestContext method, boolean serializationFormatSet) {
        Type entityType = TypeConverter.getEntityType(returnType);
        boolean usingTryWithResources = ResponseHandler.useTryWithResources(entityType, method);
        if (usingTryWithResources) {
            TryStmt statement = StaticJavaParser.parseStatement((String)"try (Response<BinaryData> networkResponse = this.httpPipeline.send(httpRequest)) {}").asTryStmt();
            statement.setLineComment("\n Send the request through the httpPipeline");
            body.addStatement((Statement)statement);
            body = statement.getTryBlock();
        } else {
            Statement statement = StaticJavaParser.parseStatement((String)"Response<BinaryData> networkResponse = this.httpPipeline.send(httpRequest);");
            statement.setLineComment("\n Send the request through the httpPipeline");
            body.addStatement(statement);
        }
        ResponseHandler.validateResponseStatus(body, method, usingTryWithResources);
        ResponseHandler.handleRequestReturn(body, returnType, entityType, method, serializationFormatSet);
    }

    private static boolean useTryWithResources(Type entityType, HttpRequestContext method) {
        if (TypeUtil.isTypeOrSubTypeOf((Type)entityType, InputStream.class) || TypeUtil.isTypeOrSubTypeOf((Type)entityType, BinaryData.class)) {
            return false;
        }
        return entityType == Void.class || method.getHttpMethod() == HttpMethod.HEAD && ResponseHandler.isBooleanType(entityType) || TypeUtil.isTypeOrSubTypeOf((Type)entityType, byte[].class);
    }

    private static void validateResponseStatus(BlockStmt body, HttpRequestContext method, boolean usingTryWithResources) {
        ResponseHandler.addStatusCodeCheck(body, method);
        ResponseHandler.addExceptionHandling(body, method, usingTryWithResources);
    }

    private static void addStatusCodeCheck(BlockStmt body, HttpRequestContext method) {
        body.addStatement(StaticJavaParser.parseStatement((String)"int responseCode = networkResponse.getStatusCode();"));
        String expectedResponseCheck = AnnotationProcessorUtils.generateExpectedResponseCheck(method.getExpectedStatusCodes());
        body.addStatement(StaticJavaParser.parseStatement((String)("boolean expectedResponse = " + expectedResponseCheck + ";")));
    }

    private static void addExceptionHandling(BlockStmt body, HttpRequestContext method, boolean usingTryWithResources) {
        BlockStmt errorBlock = new BlockStmt();
        body.tryAddImportToParentCompilationUnit(GeneratedCodeUtils.class);
        Map<Integer, HttpRequestContext.ExceptionBodyTypeInfo> mappings = method.getExceptionBodyMappings();
        if (!mappings.isEmpty() && method.getDefaultExceptionBodyType() != null) {
            ResponseHandler.getStatusCodeMapping(body, errorBlock, mappings);
            errorBlock.addStatement("java.lang.reflect.ParameterizedType defaultErrorBodyType = " + AnnotationProcessorUtils.createParameterizedTypeStatement(method.getDefaultExceptionBodyType(), body) + ";");
            errorBlock.addStatement("GeneratedCodeUtils.handleUnexpectedResponse(responseCode, networkResponse, jsonSerializer, xmlSerializer, defaultErrorBodyType, statusToExceptionTypeMap, LOGGER);");
        } else if (!mappings.isEmpty()) {
            ResponseHandler.getStatusCodeMapping(body, errorBlock, mappings);
            errorBlock.addStatement("GeneratedCodeUtils.handleUnexpectedResponse(responseCode, networkResponse, jsonSerializer, xmlSerializer, null, statusToExceptionTypeMap, LOGGER);");
        } else if (method.getDefaultExceptionBodyType() != null) {
            errorBlock.addStatement("java.lang.reflect.ParameterizedType defaultErrorBodyType = " + AnnotationProcessorUtils.createParameterizedTypeStatement(method.getDefaultExceptionBodyType(), body) + ";");
            errorBlock.addStatement("GeneratedCodeUtils.handleUnexpectedResponse(responseCode, networkResponse, jsonSerializer, xmlSerializer, defaultErrorBodyType, null, LOGGER);");
        } else {
            Statement stmt = StaticJavaParser.parseStatement((String)"GeneratedCodeUtils.handleUnexpectedResponse(responseCode, networkResponse, jsonSerializer, xmlSerializer, null, null, LOGGER);");
            stmt.setLineComment("\n Handle unexpected response");
            errorBlock.addStatement(stmt);
        }
        if (!usingTryWithResources) {
            ResponseHandler.closeResponse(errorBlock);
        }
        IfStmt ifStmt = new IfStmt().setCondition((Expression)new UnaryExpr((Expression)new NameExpr("expectedResponse"), UnaryExpr.Operator.LOGICAL_COMPLEMENT)).setThenStmt((Statement)errorBlock);
        body.addStatement((Statement)ifStmt);
    }

    private static void getStatusCodeMapping(BlockStmt body, BlockStmt errorBlock, Map<Integer, HttpRequestContext.ExceptionBodyTypeInfo> mappings) {
        body.tryAddImportToParentCompilationUnit(Map.class);
        body.tryAddImportToParentCompilationUnit(HashMap.class);
        body.tryAddImportToParentCompilationUnit(CoreUtils.class);
        errorBlock.addStatement("Map<Integer, java.lang.reflect.ParameterizedType> statusToExceptionTypeMap = new HashMap<>();");
        for (Map.Entry<Integer, HttpRequestContext.ExceptionBodyTypeInfo> entry : mappings.entrySet()) {
            if (entry.getValue().isDefaultObject() || entry.getValue().getTypeMirror() == null) {
                errorBlock.addStatement("statusToExceptionTypeMap.put(" + entry.getKey() + ", CoreUtils.createParameterizedType(Object.class));");
                continue;
            }
            errorBlock.addStatement("statusToExceptionTypeMap.put(" + entry.getKey() + ", " + AnnotationProcessorUtils.createParameterizedTypeStatement(entry.getValue().getTypeMirror(), body) + ");");
        }
    }

    private static void handleRequestReturn(BlockStmt body, TypeMirror returnType, Type entityType, HttpRequestContext method, boolean serializationFormatSet) {
        boolean returnIsResponse = TypeConverter.isResponseType(returnType);
        if (returnType.getKind() == TypeKind.VOID) {
            ResponseHandler.closeResponse(body);
        } else if (entityType == Void.TYPE || entityType == Void.class) {
            ResponseHandler.addReturnStatement(body, returnIsResponse, "null");
        } else if (method.getHttpMethod() == HttpMethod.HEAD && ResponseHandler.isBooleanType(entityType)) {
            ResponseHandler.addReturnStatement(body, returnIsResponse, "expectedResponse");
        } else if (TypeUtil.isTypeOrSubTypeOf((Type)entityType, byte[].class)) {
            String returnExpr;
            body.addStatement(StaticJavaParser.parseStatement((String)"BinaryData responseBody = networkResponse.getValue();"));
            boolean isBase64Uri = false;
            TypeMirror wireType = method.getReturnValueWireType();
            if (wireType != null && wireType.getKind() == TypeKind.DECLARED) {
                DeclaredType declaredWireType = (DeclaredType)wireType;
                TypeElement wireTypeElement = (TypeElement)declaredWireType.asElement();
                isBase64Uri = Base64Uri.class.getCanonicalName().equals(wireTypeElement.getQualifiedName().toString());
            }
            if (isBase64Uri) {
                body.tryAddImportToParentCompilationUnit(Base64Uri.class);
                returnExpr = "responseBody != null ? new Base64Uri(responseBody.toBytes()).decodedBytes() : null";
            } else {
                returnExpr = "responseBody != null ? responseBody.toBytes() : null";
            }
            ResponseHandler.addReturnStatement(body, returnIsResponse, returnExpr);
        } else if (TypeUtil.isTypeOrSubTypeOf((Type)entityType, InputStream.class)) {
            ResponseHandler.addReturnStatement(body, returnIsResponse, "networkResponse.getValue().toStream()");
        } else if (TypeUtil.isTypeOrSubTypeOf((Type)entityType, BinaryData.class)) {
            if (returnIsResponse) {
                DeclaredType declaredType;
                if (returnType instanceof DeclaredType && !(declaredType = (DeclaredType)returnType).getTypeArguments().isEmpty() && ((TypeElement)((DeclaredType)declaredType.getTypeArguments().get(0)).asElement()).getQualifiedName().contentEquals(List.class.getCanonicalName())) {
                    ResponseHandler.handleDeclaredTypes(body, returnType, serializationFormatSet, true, true);
                    return;
                }
                body.addStatement(StaticJavaParser.parseStatement((String)"return networkResponse;"));
            } else {
                body.addStatement(StaticJavaParser.parseStatement((String)"return networkResponse.getValue();"));
            }
        } else {
            ResponseHandler.handleDeclaredTypes(body, returnType, serializationFormatSet, returnIsResponse, false);
        }
    }

    private static void handleDeclaredTypes(BlockStmt body, TypeMirror returnType, boolean serializationFormatSet, boolean returnIsResponse, boolean closeResponse) {
        String typeCast = ResponseHandler.determineTypeCast(returnType, body);
        body.addStatement(StaticJavaParser.parseStatement((String)(typeCast + " deserializedResult;")));
        ResponseHandler.handleDeclaredTypeResponse(body, (DeclaredType)returnType, serializationFormatSet, typeCast);
        if (closeResponse) {
            body.addStatement(StaticJavaParser.parseStatement((String)"networkResponse.close();"));
        }
        ResponseHandler.addReturnStatement(body, returnIsResponse, "deserializedResult");
    }

    private static void addReturnStatement(BlockStmt body, boolean returnIsResponse, String responseValue) {
        if (returnIsResponse) {
            body.addStatement(StaticJavaParser.parseStatement((String)("return new Response<>(networkResponse.getRequest(), responseCode, networkResponse.getHeaders(), " + responseValue + ");")));
        } else {
            body.addStatement(StaticJavaParser.parseStatement((String)("return " + responseValue + ";")));
        }
    }

    private static String determineTypeCast(TypeMirror returnType, BlockStmt body) {
        if (returnType instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)returnType;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            body.tryAddImportToParentCompilationUnit(CoreUtils.class);
            if (!declaredType.getTypeArguments().isEmpty()) {
                TypeMirror firstGenericType = declaredType.getTypeArguments().get(0);
                if (firstGenericType.getKind() == TypeKind.ARRAY) {
                    ArrayType arrayType = (ArrayType)firstGenericType;
                    String componentTypeName = arrayType.getComponentType().toString();
                    return componentTypeName + "[]";
                }
                if (firstGenericType instanceof DeclaredType) {
                    DeclaredType genericDeclaredType = (DeclaredType)firstGenericType;
                    TypeElement genericTypeElement = (TypeElement)genericDeclaredType.asElement();
                    body.findCompilationUnit().ifPresent(compilationUnit -> compilationUnit.addImport(genericTypeElement.getQualifiedName().toString()));
                    if (genericTypeElement.getQualifiedName().contentEquals(List.class.getCanonicalName())) {
                        String typeArgs = genericDeclaredType.getTypeArguments().stream().map(arg -> ((DeclaredType)arg).asElement().getSimpleName().toString()).collect(Collectors.joining(", "));
                        return ((DeclaredType)firstGenericType).asElement().getSimpleName().toString() + "<" + typeArgs + ">";
                    }
                    return genericTypeElement.getSimpleName().toString();
                }
            }
            return typeElement.getSimpleName().toString();
        }
        return returnType.toString();
    }

    private static boolean isBooleanType(Type entityType) {
        return TypeUtil.isTypeOrSubTypeOf((Type)entityType, Boolean.TYPE) || TypeUtil.isTypeOrSubTypeOf((Type)entityType, Boolean.class);
    }

    private static void handleDeclaredTypeResponse(BlockStmt body, DeclaredType returnType, boolean serializationFormatSet, String typeCast) {
        body.tryAddImportToParentCompilationUnit(CoreUtils.class);
        body.tryAddImportToParentCompilationUnit(ParameterizedType.class);
        if (!returnType.getTypeArguments().isEmpty()) {
            body.addStatement(StaticJavaParser.parseStatement((String)("ParameterizedType returnType = " + AnnotationProcessorUtils.createParameterizedTypeStatement(returnType, body) + ";")));
        } else {
            body.addStatement("ParameterizedType returnType = CoreUtils.createParameterizedType(" + typeCast + ".class);");
        }
        if (serializationFormatSet) {
            ResponseHandler.addSerializationFormatResponseBodyStatements(body);
        } else {
            body.tryAddImportToParentCompilationUnit(SerializationFormat.class);
            body.addStatement("SerializationFormat serializationFormat = CoreUtils.serializationFormatFromContentType(networkResponse.getHeaders());");
            ResponseHandler.addSerializationFormatResponseBodyStatements(body);
        }
    }

    private static void closeResponse(BlockStmt body) {
        body.addStatement(StaticJavaParser.parseStatement((String)"networkResponse.close();"));
    }

    private static void addSerializationFormatResponseBodyStatements(BlockStmt body) {
        body.addStatement("if (jsonSerializer.supportsFormat(serializationFormat)) {     deserializedResult = CoreUtils.decodeNetworkResponse(networkResponse.getValue(), jsonSerializer, returnType); } else if (xmlSerializer.supportsFormat(serializationFormat)) {     deserializedResult = CoreUtils.decodeNetworkResponse(networkResponse.getValue(), xmlSerializer, returnType); } else {     throw LOGGER.throwableAtError().addKeyValue(\"serializationFormat\", serializationFormat.name())\n                .log(\"None of the provided serializers support the format.\", UnsupportedOperationException::new);}");
    }

    private ResponseHandler() {
    }
}

