/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.annotation.processor.utils;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import io.clientcore.annotation.processor.models.HttpRequestContext;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.serialization.SerializationFormat;
import io.clientcore.core.utils.CoreUtils;
import java.nio.ByteBuffer;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public final class RequestBodyHandler {
    public static boolean configureRequestBody(BlockStmt body, HttpRequestContext requestContext, ProcessingEnvironment processingEnv) {
        HttpRequestContext.Body requestBody = requestContext.getBody();
        if (requestBody == null) {
            return false;
        }
        TypeMirror parameterType = requestBody.getParameterType();
        if (parameterType == null) {
            RequestBodyHandler.setEmptyBody(body);
            return false;
        }
        Optional<HttpRequestContext.MethodParameter> contentTypeParamParamOpt = requestContext.getParameters().stream().filter(p -> p.getName().equals("contentType")).findFirst();
        if (parameterType.getKind().isPrimitive()) {
            return RequestBodyHandler.addRequestBodyStatements(body, parameterType, requestBody, processingEnv.getElementUtils(), processingEnv.getTypeUtils(), contentTypeParamParamOpt);
        }
        RequestBodyHandler.addRequestBodyWithNullCheck(body, parameterType, requestBody, processingEnv.getElementUtils(), processingEnv.getTypeUtils(), contentTypeParamParamOpt);
        return false;
    }

    public static boolean isBinaryDataType(TypeMirror parameterType, Elements elementUtils, Types typeUtils) {
        return typeUtils.isSameType(parameterType, elementUtils.getTypeElement("io.clientcore.core.models.binarydata.BinaryData").asType());
    }

    public static void addBinaryDataRequestBody(BlockStmt body, String parameterName) {
        body.tryAddImportToParentCompilationUnit(BinaryData.class);
        body.addStatement(StaticJavaParser.parseStatement((String)String.format("BinaryData binaryData = %s;", parameterName)));
        body.addStatement(StaticJavaParser.parseStatement((String)"if (binaryData.getLength() != null) { httpRequest.getHeaders().set(HttpHeaderName.CONTENT_LENGTH, String.valueOf(binaryData.getLength())); httpRequest.setBody(binaryData); }"));
    }

    public static boolean isByteArray(TypeMirror parameterType) {
        return parameterType.getKind() == TypeKind.ARRAY && "byte".equals(((ArrayType)parameterType).getComponentType().toString());
    }

    public static void addByteArrayRequestBody(BlockStmt body, String parameterName) {
        body.addStatement(StaticJavaParser.parseStatement((String)String.format("httpRequest.setBody(BinaryData.fromBytes(%s));", parameterName)));
    }

    public static boolean isStringType(TypeMirror parameterType, Elements elementUtils, Types typeUtils) {
        TypeElement stringElement = RequestBodyHandler.getTypeElement(elementUtils, "java.lang.String");
        if (stringElement == null) {
            return false;
        }
        return typeUtils.isSameType(parameterType, stringElement.asType());
    }

    private static TypeElement getTypeElement(Elements elementUtils, String name) {
        return elementUtils.getTypeElement(name);
    }

    public static void addStringRequestBody(BlockStmt body, String parameterName) {
        body.addStatement(StaticJavaParser.parseStatement((String)String.format("httpRequest.setBody(BinaryData.fromString(%s));", parameterName)));
    }

    public static boolean isByteBufferType(TypeMirror parameterType, Elements elementUtils, Types typeUtils) {
        TypeElement byteBufferElement = RequestBodyHandler.getTypeElement(elementUtils, "java.nio.ByteBuffer");
        if (byteBufferElement == null) {
            return false;
        }
        return typeUtils.isSameType(parameterType, byteBufferElement.asType());
    }

    public static void addByteBufferRequestBody(BlockStmt body, String parameterName) {
        body.tryAddImportToParentCompilationUnit(ByteBuffer.class);
        body.addStatement(StaticJavaParser.parseStatement((String)String.format("httpRequest.setBody(BinaryData.fromBytes(%s.array()));", parameterName)));
    }

    private static void setEmptyBody(BlockStmt body) {
        body.addStatement(StaticJavaParser.parseStatement((String)"httpRequest.getHeaders().set(HttpHeaderName.CONTENT_LENGTH, \"0\");"));
    }

    public static void setContentTypeHeader(BlockStmt body, String contentType) {
        body.addStatement(StaticJavaParser.parseStatement((String)String.format("httpRequest.getHeaders().set(HttpHeaderName.CONTENT_TYPE, \"%s\");", contentType)));
    }

    public static void handleRequestBodySerialization(BlockStmt body, String parameterName) {
        body.tryAddImportToParentCompilationUnit(SerializationFormat.class);
        body.addStatement(StaticJavaParser.parseStatement((String)"SerializationFormat serializationFormat = CoreUtils.serializationFormatFromContentType(httpRequest.getHeaders());"));
        body.addStatement(StaticJavaParser.parseStatement((String)String.format("if (xmlSerializer.supportsFormat(serializationFormat)) {httpRequest.setBody(BinaryData.fromObject(%s, xmlSerializer));} else {httpRequest.setBody(BinaryData.fromObject(%s, jsonSerializer));}", parameterName, parameterName)));
    }

    private static void addRequestBodyWithNullCheck(BlockStmt body, TypeMirror parameterType, HttpRequestContext.Body requestBody, Elements elementUtils, Types typeUtils, Optional<HttpRequestContext.MethodParameter> contentTypeParam) {
        body.tryAddImportToParentCompilationUnit(SerializationFormat.class);
        body.tryAddImportToParentCompilationUnit(CoreUtils.class);
        String parameterName = requestBody.getParameterName();
        BlockStmt ifBlock = new BlockStmt();
        IfStmt ifStatement = new IfStmt(StaticJavaParser.parseExpression((String)(parameterName + " != null")), (Statement)ifBlock, null);
        RequestBodyHandler.addRequestBodyStatements(ifBlock, parameterType, requestBody, elementUtils, typeUtils, contentTypeParam);
        body.addStatement((Statement)ifStatement);
    }

    private static boolean addRequestBodyStatements(BlockStmt body, TypeMirror parameterType, HttpRequestContext.Body requestBody, Elements elementUtils, Types typeUtils, Optional<HttpRequestContext.MethodParameter> contentTypeParam) {
        String bodyContentType = requestBody.getContentType();
        String parameterName = requestBody.getParameterName();
        if (contentTypeParam.isPresent()) {
            String paramType = contentTypeParam.get().getShortTypeName();
            if ("String".equals(paramType)) {
                body.addStatement(StaticJavaParser.parseStatement((String)"httpRequest.getHeaders().set(HttpHeaderName.CONTENT_TYPE, contentType);"));
            } else {
                body.addStatement(StaticJavaParser.parseStatement((String)"httpRequest.getHeaders().set(HttpHeaderName.CONTENT_TYPE, String.valueOf(contentType));"));
            }
        } else {
            RequestBodyHandler.setContentTypeHeader(body, bodyContentType == null ? "application/json" : bodyContentType);
        }
        if (bodyContentType != null && bodyContentType.trim().equalsIgnoreCase("application/json")) {
            RequestBodyHandler.handleRequestBodySerialization(body, parameterName);
            return true;
        }
        if (RequestBodyHandler.handleTypeBasedRequestBody(body, parameterType, parameterName, elementUtils, typeUtils)) {
            return false;
        }
        RequestBodyHandler.handleRequestBodySerialization(body, parameterName);
        return true;
    }

    private static boolean handleTypeBasedRequestBody(BlockStmt body, TypeMirror parameterType, String parameterName, Elements elementUtils, Types typeUtils) {
        if (RequestBodyHandler.isBinaryDataType(parameterType, elementUtils, typeUtils)) {
            RequestBodyHandler.addBinaryDataRequestBody(body, parameterName);
            return true;
        }
        if (RequestBodyHandler.isByteArray(parameterType)) {
            RequestBodyHandler.addByteArrayRequestBody(body, parameterName);
            return true;
        }
        if (RequestBodyHandler.isStringType(parameterType, elementUtils, typeUtils)) {
            RequestBodyHandler.addStringRequestBody(body, parameterName);
            return true;
        }
        if (RequestBodyHandler.isByteBufferType(parameterType, elementUtils, typeUtils)) {
            RequestBodyHandler.addByteBufferRequestBody(body, parameterName);
            return true;
        }
        return false;
    }

    private RequestBodyHandler() {
    }
}

