/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.annotation.processor;

import io.clientcore.annotation.processor.models.HttpRequestContext;
import io.clientcore.annotation.processor.models.Substitution;
import io.clientcore.annotation.processor.models.TemplateInput;
import io.clientcore.annotation.processor.templating.TemplateProcessor;
import io.clientcore.annotation.processor.utils.PathBuilder;
import io.clientcore.core.annotations.ServiceInterface;
import io.clientcore.core.http.annotations.BodyParam;
import io.clientcore.core.http.annotations.HeaderParam;
import io.clientcore.core.http.annotations.HostParam;
import io.clientcore.core.http.annotations.HttpRequestInformation;
import io.clientcore.core.http.annotations.PathParam;
import io.clientcore.core.http.annotations.QueryParam;
import io.clientcore.core.http.annotations.UnexpectedResponseExceptionDetail;
import io.clientcore.core.http.annotations.UnexpectedResponseExceptionDetails;
import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpMethod;
import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.http.pipeline.HttpPipeline;
import io.clientcore.core.implementation.utils.UriEscapers;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.utils.CoreUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"io.clientcore.core.annotations.*"})
public class AnnotationProcessor
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set elementsToProcess = annotations.stream().flatMap(annotation -> roundEnv.getElementsAnnotatedWith((TypeElement)annotation).stream()).filter(element -> element.getKind().isInterface()).collect(Collectors.toSet());
        if (elementsToProcess.isEmpty()) {
            return false;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "[Clientcore SDK AnnotationProcessor] Starting annotation processing for service interfaces.");
        for (Element element2 : elementsToProcess) {
            this.processServiceInterface(element2);
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "[Clientcore SDK AnnotationProcessor] Completed annotation processing.");
        return true;
    }

    private void processServiceInterface(Element serviceInterface) {
        if (serviceInterface == null || serviceInterface.getKind() != ElementKind.INTERFACE) {
            throw new IllegalArgumentException("Invalid service interface provided.");
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generating client implementation for: " + serviceInterface.asType().toString());
        TemplateInput templateInput = new TemplateInput();
        String serviceInterfaceFQN = serviceInterface.asType().toString();
        int lastDot = serviceInterfaceFQN.lastIndexOf(46);
        String packageName = lastDot > 0 ? serviceInterfaceFQN.substring(0, lastDot) : "default.generated";
        String serviceInterfaceShortName = serviceInterfaceFQN.substring(lastDot + 1);
        String serviceInterfaceImplFQN = serviceInterfaceFQN + "Impl";
        String serviceInterfaceImplShortName = serviceInterfaceImplFQN.substring(lastDot + 1);
        templateInput.setPackageName(packageName);
        templateInput.setServiceInterfaceFQN(serviceInterfaceFQN);
        templateInput.setServiceInterfaceShortName(serviceInterfaceShortName);
        templateInput.setServiceInterfaceImplShortName(serviceInterfaceImplShortName);
        ServiceInterface annotation = serviceInterface.getAnnotation(ServiceInterface.class);
        if (annotation != null && annotation.host() != null) {
            templateInput.setHost(annotation.host());
        }
        this.addImports(templateInput);
        List httpRequestMethods = serviceInterface.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.METHOD).filter(element -> element.getAnnotation(HttpRequestInformation.class) != null).map(ExecutableElement.class::cast).collect(Collectors.toList());
        templateInput.setHttpRequestContexts(httpRequestMethods.stream().map(e -> this.createHttpRequestContext((ExecutableElement)e, templateInput)).filter(Objects::nonNull).collect(Collectors.toList()));
        templateInput.setUnexpectedResponseExceptionDetails(httpRequestMethods.stream().map(e -> e.getAnnotation(UnexpectedResponseExceptionDetail.class)).filter(Objects::nonNull).collect(Collectors.toList()));
        TemplateProcessor.getInstance().process(templateInput, this.processingEnv);
    }

    private void addImports(TemplateInput templateInput) {
        templateInput.addImport(BinaryData.class.getName());
        templateInput.addImport(HttpPipeline.class.getName());
        templateInput.addImport(HttpHeaderName.class.getName());
        templateInput.addImport(HttpMethod.class.getName());
        templateInput.addImport(HttpRequest.class.getName());
        templateInput.addImport(Response.class.getName());
        templateInput.addImport(Void.class.getName());
        templateInput.addImport(UriEscapers.class.getTypeName());
    }

    private HttpRequestContext createHttpRequestContext(ExecutableElement requestMethod, TemplateInput templateInput) {
        HttpRequestContext method = new HttpRequestContext();
        method.setTemplateHasHost(!CoreUtils.isNullOrEmpty((CharSequence)templateInput.getHost()));
        method.setHost(templateInput.getHost());
        method.setMethodName(requestMethod.getSimpleName().toString());
        method.setIsConvenience(requestMethod.isDefault());
        HttpRequestInformation httpRequestInfo = requestMethod.getAnnotation(HttpRequestInformation.class);
        method.setPath(httpRequestInfo.path());
        method.setHttpMethod(httpRequestInfo.method());
        method.setExpectedStatusCodes(httpRequestInfo.expectedStatusCodes());
        method.addStaticHeaders(httpRequestInfo.headers());
        method.addStaticQueryParams(httpRequestInfo.queryParams());
        TypeMirror returnValueWireType = null;
        try {
            Class clazz = httpRequestInfo.returnValueWireType();
        }
        catch (MirroredTypeException mte) {
            TypeMirror typeMirror;
            returnValueWireType = typeMirror = mte.getTypeMirror();
        }
        method.setReturnValueWireType(returnValueWireType);
        templateInput.addImport(requestMethod.getReturnType());
        method.setMethodReturnType(requestMethod.getReturnType());
        List<UnexpectedResponseExceptionDetail> details = this.getUnexpectedResponseExceptionDetails(requestMethod);
        TypeMirror defaultExceptionBodyType = null;
        for (UnexpectedResponseExceptionDetail unexpectedResponseExceptionDetail : details) {
            TypeMirror exceptionBodyType = null;
            boolean isDefaultObject = false;
            try {
                Class clazz = unexpectedResponseExceptionDetail.exceptionBodyClass();
            }
            catch (MirroredTypeException mte) {
                TypeMirror typeMirror = mte.getTypeMirror();
                String typeStr = typeMirror.toString();
                if ("void".equals(typeStr) || "java.lang.Void".equals(typeStr)) continue;
                if ("java.lang.Object".equals(typeStr)) {
                    isDefaultObject = true;
                }
                exceptionBodyType = typeMirror;
            }
            HttpRequestContext.ExceptionBodyTypeInfo info = new HttpRequestContext.ExceptionBodyTypeInfo(exceptionBodyType, isDefaultObject);
            if (unexpectedResponseExceptionDetail.statusCode().length == 0) {
                defaultExceptionBodyType = exceptionBodyType;
                continue;
            }
            for (Object code : (TypeMirror)unexpectedResponseExceptionDetail.statusCode()) {
                method.addExceptionBodyMapping((int)code, info);
            }
        }
        method.setDefaultExceptionBodyType(defaultExceptionBodyType);
        for (VariableElement variableElement : requestMethod.getParameters()) {
            String key;
            HostParam hostParam = variableElement.getAnnotation(HostParam.class);
            PathParam pathParam = variableElement.getAnnotation(PathParam.class);
            HeaderParam headerParam = variableElement.getAnnotation(HeaderParam.class);
            QueryParam queryParam = variableElement.getAnnotation(QueryParam.class);
            BodyParam bodyParam = variableElement.getAnnotation(BodyParam.class);
            if (hostParam != null) {
                method.addSubstitution(new Substitution(hostParam.value(), variableElement.getSimpleName().toString(), !hostParam.encoded()));
            } else if (pathParam != null) {
                if (pathParam.value() == null) {
                    throw new IllegalArgumentException("Path parameter '" + variableElement.getSimpleName().toString() + "' must not be null.");
                }
                method.addSubstitution(new Substitution(pathParam.value(), variableElement.getSimpleName().toString(), !pathParam.encoded()));
            } else if (headerParam != null) {
                key = headerParam.value();
                if (!method.getHeaders().containsKey(key)) {
                    method.addHeader(headerParam.value(), variableElement.getSimpleName().toString());
                }
            } else if (queryParam != null) {
                key = queryParam.value();
                if (!method.getQueryParams().containsKey(key)) {
                    method.addQueryParam(key, variableElement.getSimpleName().toString(), queryParam.multipleQueryParams(), !queryParam.encoded(), false);
                }
            } else if (bodyParam != null) {
                method.setBody(new HttpRequestContext.Body(bodyParam.value(), variableElement.asType(), variableElement.getSimpleName().toString()));
            }
            String shortParamName = templateInput.addImport(variableElement.asType());
            method.addParameter(new HttpRequestContext.MethodParameter(variableElement.asType(), shortParamName, variableElement.getSimpleName().toString(), variableElement));
        }
        templateInput.addImport(UriEscapers.class.getSimpleName());
        method.setHost(this.getHost(method));
        return method;
    }

    private String getHost(HttpRequestContext method) {
        String path = method.getPath();
        String hostPath = method.getHost();
        if (hostPath != null && !hostPath.isEmpty() && !"/".equals(hostPath)) {
            if (path == null || path.isEmpty() || "/".equals(path)) {
                method.setPath(hostPath + "/");
            } else if (path.contains("://")) {
                method.setPath(path);
            } else if (path.startsWith("/")) {
                method.setPath(hostPath + path);
            } else {
                method.setPath(hostPath + "/" + path);
            }
        }
        return PathBuilder.buildPath(method.getPath(), method);
    }

    private List<UnexpectedResponseExceptionDetail> getUnexpectedResponseExceptionDetails(ExecutableElement requestMethod) {
        UnexpectedResponseExceptionDetails multiDetail;
        ArrayList<UnexpectedResponseExceptionDetail> details = new ArrayList<UnexpectedResponseExceptionDetail>();
        UnexpectedResponseExceptionDetail singleDetail = requestMethod.getAnnotation(UnexpectedResponseExceptionDetail.class);
        if (singleDetail != null) {
            details.add(singleDetail);
        }
        if ((multiDetail = requestMethod.getAnnotation(UnexpectedResponseExceptionDetails.class)) != null) {
            Collections.addAll(details, multiDetail.value());
        }
        return details;
    }
}

