/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.annotation.processor.utils;

import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class AnnotationProcessorUtils {
    public static String createParameterizedTypeStatement(TypeMirror returnType, BlockStmt body) {
        if (returnType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)returnType;
            String outerType = ((TypeElement)declaredType.asElement()).getQualifiedName().toString() + ".class";
            if (!declaredType.getTypeArguments().isEmpty()) {
                TypeMirror firstGenericType = declaredType.getTypeArguments().get(0);
                if (firstGenericType.getKind() == TypeKind.ARRAY) {
                    ArrayType arrayType = (ArrayType)firstGenericType;
                    String componentTypeName = arrayType.getComponentType().toString();
                    return "CoreUtils.createParameterizedType(" + outerType + ", " + componentTypeName + "[].class)";
                }
                if (firstGenericType instanceof DeclaredType) {
                    DeclaredType genericDeclaredType = (DeclaredType)firstGenericType;
                    TypeElement genericTypeElement = (TypeElement)genericDeclaredType.asElement();
                    body.findCompilationUnit().ifPresent(compilationUnit -> compilationUnit.addImport(genericTypeElement.getQualifiedName().toString()));
                    String genericType = ((DeclaredType)declaredType.getTypeArguments().get(0)).asElement().getSimpleName().toString();
                    if (genericTypeElement.getQualifiedName().contentEquals(List.class.getCanonicalName())) {
                        if (!genericDeclaredType.getTypeArguments().isEmpty()) {
                            String innerType = ((DeclaredType)genericDeclaredType.getTypeArguments().get(0)).asElement().getSimpleName().toString();
                            return "CoreUtils.createParameterizedType(" + genericType + ".class, " + innerType + ".class)";
                        }
                    } else {
                        return "CoreUtils.createParameterizedType(" + outerType + ", " + genericType + ".class)";
                    }
                }
            }
            return "CoreUtils.createParameterizedType(" + outerType + ")";
        }
        return "null;";
    }

    public static String generateExpectedResponseCheck(List<Integer> expectedStatusCodes) {
        if (expectedStatusCodes == null || expectedStatusCodes.isEmpty()) {
            return "responseCode >= 200 && responseCode < 300";
        }
        if (expectedStatusCodes.size() == 1) {
            return "responseCode == " + expectedStatusCodes.get(0);
        }
        return expectedStatusCodes.stream().map(code -> "responseCode == " + code).collect(Collectors.joining(" || ", "(", ")"));
    }

    private AnnotationProcessorUtils() {
    }
}

