/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.annotation.processor.utils;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import io.clientcore.annotation.processor.models.HttpRequestContext;
import io.clientcore.annotation.processor.utils.TypeConverter;
import io.clientcore.core.http.models.HttpMethod;
import io.clientcore.core.implementation.TypeUtil;
import io.clientcore.core.models.binarydata.BinaryData;
import io.clientcore.core.serialization.SerializationFormat;
import io.clientcore.core.utils.CoreUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class ResponseHandler {
    public static void generateResponseHandling(BlockStmt body, TypeMirror returnType, HttpRequestContext method, boolean serializationFormatSet) {
        if (ResponseHandler.isVoidReturnType(returnType)) {
            ResponseHandler.closeResponse(body);
            if (returnType.toString().equals("java.lang.Void")) {
                body.addStatement((Statement)new ReturnStmt("null"));
            }
        } else if (TypeConverter.isResponseType(returnType)) {
            ResponseHandler.handleResponseType(body, returnType, method, serializationFormatSet);
        } else {
            ResponseHandler.handleNonResponseType(body, returnType, method, serializationFormatSet);
        }
    }

    private static boolean isVoidReturnType(TypeMirror returnType) {
        return returnType.getKind() == TypeKind.VOID || returnType.toString().equals("java.lang.Void");
    }

    private static void handleResponseType(BlockStmt body, TypeMirror returnType, HttpRequestContext method, boolean serializationFormatSet) {
        Type bodyType = TypeConverter.getEntityType(returnType);
        if (returnType.toString().contains("Void")) {
            ResponseHandler.closeResponse(body);
            body.addStatement(StaticJavaParser.parseStatement((String)"return new Response<>(networkResponse.getRequest(), responseCode, networkResponse.getHeaders(), null);"));
        } else {
            ResponseHandler.handleResponseBody(body, returnType, bodyType, method, serializationFormatSet);
            ResponseHandler.createResponseIfNecessary(body);
        }
    }

    private static void handleResponseBody(BlockStmt body, TypeMirror returnType, Type entityType, HttpRequestContext method, boolean serializationFormatSet) {
        String typeCast = ResponseHandler.determineTypeCast(returnType, entityType, method, body);
        body.addStatement("Object result = " + ResponseHandler.determineResultExpression(entityType, method));
        if (returnType instanceof DeclaredType) {
            ResponseHandler.handleDeclaredTypeResponse(body, (DeclaredType)returnType, serializationFormatSet);
            if (!((DeclaredType)returnType).getTypeArguments().isEmpty()) {
                body.addStatement(StaticJavaParser.parseStatement((String)("return new Response<>(networkResponse.getRequest(), responseCode, networkResponse.getHeaders(), (" + typeCast + ") result);")));
            } else {
                ResponseHandler.closeResponse(body);
                CastExpr castExpr = new CastExpr(StaticJavaParser.parseType((String)returnType.toString()), (Expression)new NameExpr("result"));
                body.addStatement((Statement)new ReturnStmt((Expression)castExpr));
            }
        }
    }

    private static String determineTypeCast(TypeMirror returnType, Type entityType, HttpRequestContext method, BlockStmt body) {
        if (method.getHttpMethod() == HttpMethod.HEAD && ResponseHandler.isBooleanType(entityType)) {
            return "Boolean";
        }
        if (TypeUtil.isTypeOrSubTypeOf((Type)entityType, byte[].class)) {
            return "byte[]";
        }
        if (TypeUtil.isTypeOrSubTypeOf((Type)entityType, InputStream.class)) {
            return "InputStream";
        }
        if (TypeUtil.isTypeOrSubTypeOf((Type)entityType, BinaryData.class)) {
            return "BinaryData";
        }
        if (returnType instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)returnType;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            body.tryAddImportToParentCompilationUnit(CoreUtils.class);
            if (!declaredType.getTypeArguments().isEmpty()) {
                TypeMirror firstGenericType = declaredType.getTypeArguments().get(0);
                DeclaredType genericDeclaredType = (DeclaredType)firstGenericType;
                TypeElement genericTypeElement = (TypeElement)genericDeclaredType.asElement();
                body.findCompilationUnit().ifPresent(compilationUnit -> compilationUnit.addImport(genericTypeElement.getQualifiedName().toString()));
                if (genericTypeElement.getQualifiedName().contentEquals(List.class.getCanonicalName())) {
                    String typeArgs = genericDeclaredType.getTypeArguments().stream().map(arg -> ((DeclaredType)arg).asElement().getSimpleName().toString()).collect(Collectors.joining(", "));
                    return ((DeclaredType)firstGenericType).asElement().getSimpleName().toString() + "<" + typeArgs + ">";
                }
                return genericTypeElement.getSimpleName().toString();
            }
            return typeElement.getSimpleName().toString();
        }
        return returnType.toString();
    }

    private static String determineResultExpression(Type entityType, HttpRequestContext method) {
        if (method.getHttpMethod() == HttpMethod.HEAD && ResponseHandler.isBooleanType(entityType)) {
            return "(responseStatusCode / 100) == 2;";
        }
        if (TypeUtil.isTypeOrSubTypeOf((Type)entityType, byte[].class)) {
            return "responseBody != null ? responseBody.toBytes() : null;";
        }
        if (TypeUtil.isTypeOrSubTypeOf((Type)entityType, InputStream.class)) {
            return "responseBody.toStream();";
        }
        if (TypeUtil.isTypeOrSubTypeOf((Type)entityType, BinaryData.class)) {
            return "networkResponse.getValue();";
        }
        return "null;";
    }

    private static boolean isBooleanType(Type entityType) {
        return TypeUtil.isTypeOrSubTypeOf((Type)entityType, Boolean.TYPE) || TypeUtil.isTypeOrSubTypeOf((Type)entityType, Boolean.class);
    }

    private static void handleDeclaredTypeResponse(BlockStmt body, DeclaredType returnType, boolean serializationFormatSet) {
        TypeElement typeElement = (TypeElement)returnType.asElement();
        body.tryAddImportToParentCompilationUnit(CoreUtils.class);
        if (!returnType.getTypeArguments().isEmpty()) {
            TypeMirror firstGenericType = returnType.getTypeArguments().get(0);
            if (firstGenericType instanceof DeclaredType) {
                DeclaredType genericDeclaredType = (DeclaredType)firstGenericType;
                TypeElement genericTypeElement = (TypeElement)genericDeclaredType.asElement();
                body.findCompilationUnit().ifPresent(compilationUnit -> compilationUnit.addImport(genericTypeElement.getQualifiedName().toString()));
                if (genericTypeElement.getQualifiedName().contentEquals(List.class.getCanonicalName())) {
                    if (!genericDeclaredType.getTypeArguments().isEmpty()) {
                        String innerType = ((DeclaredType)genericDeclaredType.getTypeArguments().get(0)).asElement().getSimpleName().toString();
                        body.addStatement("ParameterizedType returnType = CoreUtils.createParameterizedType(" + genericTypeElement.getSimpleName() + ".class, " + innerType + ".class);");
                    }
                } else {
                    String genericType = ((DeclaredType)returnType.getTypeArguments().get(0)).asElement().getSimpleName().toString();
                    body.addStatement("ParameterizedType returnType = CoreUtils.createParameterizedType(" + typeElement.getSimpleName() + ".class, " + genericType + ".class);");
                }
            }
        } else {
            body.addStatement("ParameterizedType returnType = CoreUtils.createParameterizedType(" + returnType + ".class);");
        }
        if (serializationFormatSet) {
            ResponseHandler.addSerializationFormatResponseBodyStatements(body);
        } else {
            body.tryAddImportToParentCompilationUnit(SerializationFormat.class);
            body.addStatement("SerializationFormat serializationFormat = CoreUtils.serializationFormatFromContentType(httpRequest.getHeaders());");
            ResponseHandler.addSerializationFormatResponseBodyStatements(body);
        }
    }

    private static void addSerializationFormatResponseBodyStatements(BlockStmt body) {
        body.addStatement("if (jsonSerializer.supportsFormat(serializationFormat)) {     result = decodeNetworkResponse(networkResponse.getValue(), jsonSerializer, returnType); } else if (xmlSerializer.supportsFormat(serializationFormat)) {     result = decodeNetworkResponse(networkResponse.getValue(), xmlSerializer, returnType); } else {     throw new RuntimeException(new UnsupportedOperationException(        \"None of the provided serializers support the format: \" + serializationFormat + \".\")); }");
    }

    private static void handleNonResponseType(BlockStmt body, TypeMirror returnType, HttpRequestContext method, boolean serializationFormatSet) {
        Type entityType = TypeConverter.getEntityType(returnType);
        ResponseHandler.processEntityReturnType(body, returnType, entityType, method, serializationFormatSet);
        if (!returnType.getKind().isPrimitive() && returnType.getKind() != TypeKind.ARRAY && returnType.getKind() != TypeKind.DECLARED) {
            ResponseHandler.closeResponse(body);
            CastExpr castExpr = new CastExpr(StaticJavaParser.parseType((String)returnType.toString()), (Expression)new NameExpr("result"));
            body.addStatement((Statement)new ReturnStmt((Expression)castExpr));
        }
    }

    private static void processEntityReturnType(BlockStmt body, TypeMirror returnType, Type entityType, HttpRequestContext method, boolean serializationFormatSet) {
        if (ResponseHandler.isHeadRequestWithBooleanResponse(method, entityType)) {
            ResponseHandler.closeResponse(body);
            body.addStatement((Statement)new ReturnStmt("expectedResponse"));
        } else if (TypeUtil.isTypeOrSubTypeOf((Type)entityType, byte[].class)) {
            ResponseHandler.handleByteArrayResponse(body);
        } else if (TypeUtil.isTypeOrSubTypeOf((Type)entityType, InputStream.class)) {
            ResponseHandler.handleInputStreamResponse(body);
        } else if (TypeUtil.isTypeOrSubTypeOf((Type)entityType, BinaryData.class)) {
            body.tryAddImportToParentCompilationUnit(BinaryData.class);
            body.addStatement(StaticJavaParser.parseStatement((String)"BinaryData responseBody = networkResponse.getValue();"));
            ResponseHandler.closeResponse(body);
        } else {
            ResponseHandler.handleResponseBody(body, returnType, entityType, method, serializationFormatSet);
        }
    }

    private static boolean isHeadRequestWithBooleanResponse(HttpRequestContext method, Type entityType) {
        return method.getHttpMethod() == HttpMethod.HEAD && (TypeUtil.isTypeOrSubTypeOf((Type)entityType, Boolean.TYPE) || TypeUtil.isTypeOrSubTypeOf((Type)entityType, Boolean.class));
    }

    private static void handleByteArrayResponse(BlockStmt body) {
        body.addStatement(StaticJavaParser.parseStatement((String)"BinaryData responseBody = networkResponse.getValue();"));
        body.addStatement(StaticJavaParser.parseStatement((String)"byte[] responseBodyBytes = responseBody != null ? responseBody.toBytes() : null;"));
        body.addStatement(StaticJavaParser.parseStatement((String)"return responseBodyBytes != null ? (responseBodyBytes.length == 0 ? null : responseBodyBytes) : null;"));
    }

    private static void handleInputStreamResponse(BlockStmt body) {
        body.addStatement(StaticJavaParser.parseStatement((String)"BinaryData responseBody = networkResponse.getValue();"));
        body.addStatement(StaticJavaParser.parseStatement((String)"return responseBody.toStream();"));
    }

    private static void closeResponse(BlockStmt body) {
        body.tryAddImportToParentCompilationUnit(IOException.class);
        body.tryAddImportToParentCompilationUnit(UncheckedIOException.class);
        body.addStatement(StaticJavaParser.parseStatement((String)"try { networkResponse.close(); } catch (IOException e) { throw LOGGER.logThrowableAsError(new UncheckedIOException(e)); }"));
    }

    private static void createResponseIfNecessary(BlockStmt body) {
        if (((Statement)body.getStatements().get(body.getStatements().size() - 1)).toString().contains("return")) {
            return;
        }
        body.addStatement(StaticJavaParser.parseStatement((String)"return response;"));
    }

    private ResponseHandler() {
    }
}

