/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.annotation.processor.models;

import io.clientcore.annotation.processor.models.Substitution;
import io.clientcore.core.http.models.HttpMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.type.TypeMirror;

public final class HttpRequestContext {
    private String methodName;
    private TypeMirror methodReturnType;
    private final List<MethodParameter> parameters = new ArrayList<MethodParameter>();
    private HttpMethod httpMethod;
    private boolean isConvenience;
    private String host;
    private String path;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Map<String, QueryParameter> queryParams = new LinkedHashMap<String, QueryParameter>();
    private final Map<String, Substitution> substitutions = new HashMap<String, Substitution>();
    private int[] expectedStatusCodes;
    private Body body;

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public TypeMirror getMethodReturnType() {
        return this.methodReturnType;
    }

    public void setMethodReturnType(TypeMirror methodReturnType) {
        this.methodReturnType = methodReturnType;
    }

    public void addParameter(MethodParameter parameter) {
        this.parameters.add(parameter);
    }

    public List<MethodParameter> getParameters() {
        return this.parameters;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public Map<String, QueryParameter> getQueryParams() {
        return this.queryParams;
    }

    public void addQueryParam(String key, String value, boolean isMultiple, boolean shouldEncode) {
        if (this.queryParams.containsKey(key)) {
            throw new IllegalArgumentException("Cannot add duplicate query parameter '" + key + "'");
        }
        this.queryParams.put(key, new QueryParameter(value, isMultiple, shouldEncode));
    }

    public void addSubstitution(Substitution substitution) {
        if (this.substitutions.containsKey(substitution.getParameterName())) {
            throw new IllegalArgumentException("Cannot add duplicate substitution for parameter '" + substitution.getParameterName() + "'");
        }
        this.substitutions.put(substitution.getParameterName(), substitution);
    }

    public Substitution getSubstitution(String parameterName) {
        return this.substitutions.get(parameterName);
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public Body getBody() {
        return this.body;
    }

    public void setExpectedStatusCodes(int[] expectedStatusCodes) {
        if (expectedStatusCodes != null) {
            Arrays.sort(expectedStatusCodes);
        }
        this.expectedStatusCodes = expectedStatusCodes;
    }

    public List<Integer> getExpectedStatusCodes() {
        return Arrays.stream(this.expectedStatusCodes).boxed().collect(Collectors.toList());
    }

    public boolean isConvenience() {
        return this.isConvenience;
    }

    public void setIsConvenience(boolean isConvenience) {
        this.isConvenience = isConvenience;
    }

    public static class QueryParameter {
        private final String value;
        private final boolean isMultiple;
        private final boolean shouldEncode;

        public QueryParameter(String value, boolean isMultiple, boolean shouldEncode) {
            this.value = value;
            this.isMultiple = isMultiple;
            this.shouldEncode = shouldEncode;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isMultiple() {
            return this.isMultiple;
        }

        public boolean shouldEncode() {
            return this.shouldEncode;
        }
    }

    public static class Body {
        private final String contentType;
        private final TypeMirror parameterType;
        private final String parameterName;

        public Body(String contentType, TypeMirror parameterType, String parameterName) {
            this.contentType = contentType;
            this.parameterType = parameterType;
            this.parameterName = parameterName;
        }

        public String getContentType() {
            return this.contentType;
        }

        public TypeMirror getParameterType() {
            return this.parameterType;
        }

        public String getParameterName() {
            return this.parameterName;
        }
    }

    public static class MethodParameter {
        private final TypeMirror type;
        private final String shortTypeName;
        private final String name;

        public MethodParameter(TypeMirror type, String shortTypeName, String name) {
            this.type = type;
            this.shortTypeName = shortTypeName;
            this.name = name;
        }

        public TypeMirror getTypeMirror() {
            return this.type;
        }

        public String getShortTypeName() {
            return this.shortTypeName;
        }

        public String getName() {
            return this.name;
        }
    }
}

