/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.annotation.processor;

import io.clientcore.annotation.processor.models.HttpRequestContext;
import io.clientcore.annotation.processor.models.Substitution;
import io.clientcore.annotation.processor.models.TemplateInput;
import io.clientcore.annotation.processor.templating.TemplateProcessor;
import io.clientcore.annotation.processor.utils.PathBuilder;
import io.clientcore.core.annotations.ServiceInterface;
import io.clientcore.core.http.annotations.BodyParam;
import io.clientcore.core.http.annotations.HeaderParam;
import io.clientcore.core.http.annotations.HostParam;
import io.clientcore.core.http.annotations.HttpRequestInformation;
import io.clientcore.core.http.annotations.PathParam;
import io.clientcore.core.http.annotations.QueryParam;
import io.clientcore.core.http.annotations.UnexpectedResponseExceptionDetail;
import io.clientcore.core.http.models.HttpHeaderName;
import io.clientcore.core.http.models.HttpMethod;
import io.clientcore.core.http.models.HttpRequest;
import io.clientcore.core.http.models.Response;
import io.clientcore.core.http.pipeline.HttpPipeline;
import io.clientcore.core.models.binarydata.BinaryData;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@SupportedAnnotationTypes(value={"io.clientcore.core.annotations.*"})
public class AnnotationProcessor
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        annotations.stream().map(roundEnv::getElementsAnnotatedWith).flatMap(Collection::stream).filter(element -> element.getKind().isInterface()).forEach(element -> {
            if (element.getAnnotation(ServiceInterface.class) != null) {
                this.processServiceInterface((Element)element);
            }
        });
        return true;
    }

    private void processServiceInterface(Element serviceInterface) {
        if (serviceInterface == null || serviceInterface.getKind() != ElementKind.INTERFACE) {
            throw new IllegalArgumentException("Invalid service interface provided.");
        }
        TemplateInput templateInput = new TemplateInput();
        String serviceInterfaceFQN = serviceInterface.asType().toString();
        int lastDot = serviceInterfaceFQN.lastIndexOf(46);
        String packageName = lastDot > 0 ? serviceInterfaceFQN.substring(0, lastDot) : "default.generated";
        String serviceInterfaceShortName = serviceInterfaceFQN.substring(lastDot + 1);
        String serviceInterfaceImplFQN = serviceInterfaceFQN + "Impl";
        String serviceInterfaceImplShortName = serviceInterfaceImplFQN.substring(lastDot + 1);
        templateInput.setPackageName(packageName);
        templateInput.setServiceInterfaceFQN(serviceInterfaceFQN);
        templateInput.setServiceInterfaceShortName(serviceInterfaceShortName);
        templateInput.setServiceInterfaceImplShortName(serviceInterfaceImplShortName);
        ServiceInterface annotation = serviceInterface.getAnnotation(ServiceInterface.class);
        if (annotation != null && annotation.host() != null) {
            templateInput.setHost(annotation.host());
        }
        this.addImports(templateInput);
        List httpRequestMethods = serviceInterface.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.METHOD).filter(element -> element.getAnnotation(HttpRequestInformation.class) != null).map(ExecutableElement.class::cast).collect(Collectors.toList());
        templateInput.setHttpRequestContexts(httpRequestMethods.stream().map(e -> this.createHttpRequestContext((ExecutableElement)e, templateInput)).filter(Objects::nonNull).collect(Collectors.toList()));
        templateInput.setUnexpectedResponseExceptionDetails(httpRequestMethods.stream().map(e -> e.getAnnotation(UnexpectedResponseExceptionDetail.class)).filter(Objects::nonNull).collect(Collectors.toList()));
        TemplateProcessor.getInstance().process(templateInput, this.processingEnv);
    }

    private void addImports(TemplateInput templateInput) {
        templateInput.addImport(BinaryData.class.getName());
        templateInput.addImport(HttpPipeline.class.getName());
        templateInput.addImport(HttpHeaderName.class.getName());
        templateInput.addImport(HttpMethod.class.getName());
        templateInput.addImport(HttpRequest.class.getName());
        templateInput.addImport(Response.class.getName());
        templateInput.addImport(Void.class.getName());
    }

    private HttpRequestContext createHttpRequestContext(ExecutableElement requestMethod, TemplateInput templateInput) {
        HttpRequestContext method = new HttpRequestContext();
        method.setHost(templateInput.getHost());
        method.setMethodName(requestMethod.getSimpleName().toString());
        method.setIsConvenience(requestMethod.isDefault());
        HttpRequestInformation httpRequestInfo = requestMethod.getAnnotation(HttpRequestInformation.class);
        method.setPath(httpRequestInfo.path());
        method.setHttpMethod(httpRequestInfo.method());
        method.setExpectedStatusCodes(httpRequestInfo.expectedStatusCodes());
        method.setMethodReturnType(requestMethod.getReturnType());
        for (VariableElement variableElement : requestMethod.getParameters()) {
            HostParam hostParam = variableElement.getAnnotation(HostParam.class);
            PathParam pathParam = variableElement.getAnnotation(PathParam.class);
            HeaderParam headerParam = variableElement.getAnnotation(HeaderParam.class);
            QueryParam queryParam = variableElement.getAnnotation(QueryParam.class);
            BodyParam bodyParam = variableElement.getAnnotation(BodyParam.class);
            if (hostParam != null) {
                method.addSubstitution(new Substitution(hostParam.value(), variableElement.getSimpleName().toString(), !hostParam.encoded()));
            } else if (pathParam != null) {
                if (pathParam.value() == null) {
                    throw new IllegalArgumentException("Path parameter '" + variableElement.getSimpleName().toString() + "' must not be null.");
                }
                method.addSubstitution(new Substitution(pathParam.value(), variableElement.getSimpleName().toString(), !pathParam.encoded()));
            } else if (headerParam != null) {
                method.addHeader(headerParam.value(), variableElement.getSimpleName().toString());
            } else if (queryParam != null) {
                method.addQueryParam(queryParam.value(), variableElement.getSimpleName().toString(), queryParam.multipleQueryParams(), !queryParam.encoded());
            } else if (bodyParam != null) {
                method.setBody(new HttpRequestContext.Body(bodyParam.value(), variableElement.asType(), variableElement.getSimpleName().toString()));
            }
            String shortParamName = templateInput.addImport(variableElement.asType());
            method.addParameter(new HttpRequestContext.MethodParameter(variableElement.asType(), shortParamName, variableElement.getSimpleName().toString()));
        }
        method.setHost(AnnotationProcessor.getHost(method));
        return method;
    }

    private static String getHost(HttpRequestContext method) {
        String path = method.getPath();
        if (path != null && !path.isEmpty() && !"/".equals(path)) {
            String hostPath = method.getHost();
            if (hostPath == null || hostPath.isEmpty() || "/".equals(hostPath) || path.contains("://")) {
                method.setPath(path);
            } else if (path.startsWith("/")) {
                method.setPath(hostPath + path);
            } else {
                method.setPath(hostPath + "/" + path);
            }
        }
        return PathBuilder.buildPath(method.getPath(), method);
    }
}

