/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.container;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBufferedMessageStartEventBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnCompensationSubscriptionBehaviour;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnProcessResultSenderBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.util.Either;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.agrona.DirectBuffer;

public final class ProcessProcessor
implements BpmnElementContainerProcessor<ExecutableFlowElementContainer> {
    private static final Consumer<BpmnElementContext> NOOP = context -> {};
    private final BpmnStateBehavior stateBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnProcessResultSenderBehavior processResultSenderBehavior;
    private final BpmnBufferedMessageStartEventBehavior bufferedMessageStartEventBehavior;
    private final BpmnCompensationSubscriptionBehaviour compensationSubscriptionBehaviour;
    private final BpmnJobBehavior jobBehavior;

    public ProcessProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.processResultSenderBehavior = bpmnBehaviors.processResultSenderBehavior();
        this.bufferedMessageStartEventBehavior = bpmnBehaviors.bufferedMessageStartEventBehavior();
        this.compensationSubscriptionBehaviour = bpmnBehaviors.compensationSubscriptionBehaviour();
        this.jobBehavior = bpmnBehaviors.jobBehavior();
    }

    @Override
    public Class<ExecutableFlowElementContainer> getType() {
        return ExecutableFlowElementContainer.class;
    }

    @Override
    public Either<Failure, ?> finalizeActivation(ExecutableFlowElementContainer element, BpmnElementContext context) {
        BpmnElementContext activatedContext = this.stateTransitionBehavior.transitionToActivated(context, element.getEventType());
        this.activateStartEvent(element, activatedContext);
        return SUCCESS;
    }

    @Override
    public Either<Failure, ?> onComplete(ExecutableFlowElementContainer element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        this.compensationSubscriptionBehaviour.deleteSubscriptionsOfProcessInstance(context);
        return SUCCESS;
    }

    @Override
    public Either<Failure, ?> finalizeCompletion(ExecutableFlowElementContainer element, BpmnElementContext context) {
        this.processResultSenderBehavior.sendResult(context);
        return this.transitionTo(element, context, completing -> this.stateTransitionBehavior.transitionToCompleted(element, (BpmnElementContext)completing));
    }

    @Override
    public void onTerminate(ExecutableFlowElementContainer element, BpmnElementContext context) {
        if (element.hasExecutionListeners()) {
            this.jobBehavior.cancelJob(context);
        }
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        this.incidentBehavior.resolveIncidents(context);
        this.compensationSubscriptionBehaviour.deleteSubscriptionsOfProcessInstance(context);
        boolean noActiveChildInstances = this.stateTransitionBehavior.terminateChildInstances(context);
        if (noActiveChildInstances) {
            this.transitionTo(element, context, terminating -> Either.right((Object)this.stateTransitionBehavior.transitionToTerminated((BpmnElementContext)terminating, element.getEventType())));
        }
    }

    private void activateStartEvent(ExecutableFlowElementContainer element, BpmnElementContext activated) {
        if (element.hasMessageStartEvent() || element.hasTimerStartEvent() || element.hasSignalStartEvent()) {
            this.eventSubscriptionBehavior.findEventTriggerForStartEvent(activated.getProcessDefinitionKey(), activated.getProcessInstanceKey()).ifPresentOrElse(eventTrigger -> this.eventSubscriptionBehavior.activateTriggeredStartEvent(activated, (EventTrigger)((Object)eventTrigger)), () -> this.activateNoneStartEvent(element, activated));
        } else {
            this.activateNoneStartEvent(element, activated);
        }
    }

    private void activateNoneStartEvent(ExecutableFlowElementContainer element, BpmnElementContext context) {
        ExecutableStartEvent noneStartEvent = element.getNoneStartEvent();
        if (noneStartEvent == null) {
            throw new BpmnProcessingException(context, "Expected to activate the none start event of the process but not found.");
        }
        this.stateTransitionBehavior.activateChildInstance(context, noneStartEvent);
    }

    @Override
    public void afterExecutionPathCompleted(ExecutableFlowElementContainer element, BpmnElementContext flowScopeContext, BpmnElementContext childContext, Boolean satisfiesCompletionCondition) {
        if (this.stateBehavior.canBeCompleted(childContext)) {
            this.stateTransitionBehavior.completeElement(flowScopeContext);
        }
    }

    @Override
    public void onChildTerminated(ExecutableFlowElementContainer element, BpmnElementContext flowScopeContext, BpmnElementContext childContext) {
        ElementInstance flowScopeInstance = this.stateBehavior.getElementInstance(flowScopeContext);
        if (this.stateBehavior.isInterrupted(flowScopeContext)) {
            boolean interruptedByTerminateEndEvent = this.stateBehavior.isInterruptedByTerminateEndEvent(flowScopeContext, flowScopeInstance);
            if (interruptedByTerminateEndEvent && this.stateBehavior.canBeTerminated(childContext)) {
                this.stateTransitionBehavior.completeElement(flowScopeContext);
            } else {
                this.eventSubscriptionBehavior.findEventTrigger(flowScopeContext).ifPresent(eventTrigger -> this.eventSubscriptionBehavior.activateTriggeredEvent(flowScopeContext.getElementInstanceKey(), flowScopeContext.getElementInstanceKey(), (EventTrigger)((Object)eventTrigger), flowScopeContext));
            }
        } else if (this.stateBehavior.canBeTerminated(childContext) && flowScopeInstance.isTerminating()) {
            this.transitionTo(element, flowScopeContext, context -> Either.right((Object)this.stateTransitionBehavior.transitionToTerminated((BpmnElementContext)context, element.getEventType())));
        }
    }

    private Either<Failure, ?> transitionTo(ExecutableFlowElementContainer element, BpmnElementContext context, Function<BpmnElementContext, Either<Failure, BpmnElementContext>> transitionOperation) {
        Consumer<BpmnElementContext> postTransitionAction = this.getPostTransitionAction(element, context);
        return transitionOperation.apply(context).thenDo(postTransitionAction);
    }

    private Consumer<BpmnElementContext> getPostTransitionAction(ExecutableFlowElementContainer processElement, BpmnElementContext context) {
        long parentProcessInstanceKey = context.getParentProcessInstanceKey();
        if (parentProcessInstanceKey > 0L) {
            BpmnElementContext parentInstanceContext = this.stateBehavior.getParentElementInstanceContext(context);
            return postTransitionContext -> {
                if (postTransitionContext.getIntent() == ProcessInstanceIntent.ELEMENT_COMPLETED) {
                    this.stateTransitionBehavior.onCalledProcessCompleted((BpmnElementContext)postTransitionContext, parentInstanceContext);
                } else {
                    this.stateTransitionBehavior.onCalledProcessTerminated((BpmnElementContext)postTransitionContext, parentInstanceContext);
                }
            };
        }
        if (processElement.hasMessageStartEvent()) {
            Optional<DirectBuffer> correlationKey = this.bufferedMessageStartEventBehavior.findCorrelationKey(context);
            return postTransitionContext -> correlationKey.ifPresent(key -> this.bufferedMessageStartEventBehavior.correlateMessage((BpmnElementContext)postTransitionContext, (DirectBuffer)key));
        }
        return NOOP;
    }
}

