/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.container;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnCompensationSubscriptionBehaviour;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCallActivity;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeBindingType;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Optional;
import org.agrona.DirectBuffer;

public final class CallActivityProcessor
implements BpmnElementContainerProcessor<ExecutableCallActivity> {
    public static final String MAX_DEPTH_EXCEEDED_MESSAGE = "The call activity has reached the maximum depth of %d. This is likely due to a recursive call. Cancel the root process instance if this was unintentional. Otherwise, consider increasing the maximum depth, or use process instance modification to adjust the process instance.";
    private static final String UNABLE_TO_COMPLETE_FROM_STATE_MESSAGE = "Expected to complete call activity after child completed, but call activity cannot be completed from state '%s'";
    private static final String UNABLE_TO_TERMINATE_FROM_STATE_MESSAGE = "Expected to terminate call activity after child terminated, but call activity cannot be terminated from state '%s'";
    private final ExpressionProcessor expressionProcessor;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnCompensationSubscriptionBehaviour compensationSubscriptionBehaviour;
    private final BpmnJobBehavior jobBehavior;
    private final int maxProcessDepth;

    public CallActivityProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior, int maxProcessDepth) {
        this.expressionProcessor = bpmnBehaviors.expressionBehavior();
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
        this.compensationSubscriptionBehaviour = bpmnBehaviors.compensationSubscriptionBehaviour();
        this.jobBehavior = bpmnBehaviors.jobBehavior();
        this.maxProcessDepth = maxProcessDepth;
    }

    @Override
    public Class<ExecutableCallActivity> getType() {
        return ExecutableCallActivity.class;
    }

    @Override
    public Either<Failure, ?> onActivate(ExecutableCallActivity element, BpmnElementContext context) {
        return this.variableMappingBehavior.applyInputMappings(context, element).flatMap(ok -> this.validateProcessDepth(context));
    }

    @Override
    public Either<Failure, ?> finalizeActivation(ExecutableCallActivity element, BpmnElementContext context) {
        return this.evaluateProcessId(context, element).flatMap(processId -> this.getCalledProcess((DirectBuffer)processId, element.getBindingType(), element.getVersionTag(), context)).flatMap(this::checkProcessHasNoneStartEvent).flatMap(p -> this.eventSubscriptionBehavior.subscribeToEvents(element, context).map(ok -> p)).thenDo(process -> {
            BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(context, element.getEventType());
            long childProcessInstanceKey = this.stateTransitionBehavior.createChildProcessInstance((DeployedProcess)process, context);
            boolean propagateAllParentVariablesEnabled = element.isPropagateAllParentVariablesEnabled();
            Optional<Expression> inputMappings = element.getInputMappings();
            long callActivityInstanceKey = activated.getElementInstanceKey();
            if (propagateAllParentVariablesEnabled) {
                this.stateBehavior.copyAllVariablesToProcessInstance(callActivityInstanceKey, childProcessInstanceKey, (DeployedProcess)process);
            } else if (inputMappings.isPresent()) {
                this.stateBehavior.copyLocalVariablesToProcessInstance(callActivityInstanceKey, childProcessInstanceKey, (DeployedProcess)process);
            }
        });
    }

    @Override
    public Either<Failure, ?> onComplete(ExecutableCallActivity element, BpmnElementContext context) {
        return this.variableMappingBehavior.applyOutputMappings(context, element).thenDo(ok -> this.eventSubscriptionBehavior.unsubscribeFromEvents(context));
    }

    @Override
    public Either<Failure, ?> finalizeCompletion(ExecutableCallActivity element, BpmnElementContext context) {
        this.compensationSubscriptionBehaviour.createCompensationSubscription(element, context);
        return this.stateTransitionBehavior.transitionToCompleted(element, context).thenDo(completed -> {
            this.compensationSubscriptionBehaviour.completeCompensationHandler((BpmnElementContext)completed);
            this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed);
        });
    }

    @Override
    public void onTerminate(ExecutableCallActivity element, BpmnElementContext context) {
        if (element.hasExecutionListeners()) {
            this.jobBehavior.cancelJob(context);
        }
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        this.incidentBehavior.resolveIncidents(context);
        this.stateTransitionBehavior.terminateChildProcessInstance(this, element, context);
    }

    @Override
    public void afterExecutionPathCompleted(ExecutableCallActivity element, BpmnElementContext callActivityContext, BpmnElementContext childContext, Boolean satisfiesCompletionCondition) {
        ProcessInstanceIntent currentState = callActivityContext.getIntent();
        if (currentState == ProcessInstanceIntent.ELEMENT_ACTIVATED) {
            this.stateTransitionBehavior.completeElement(callActivityContext);
        } else if (currentState == ProcessInstanceIntent.ELEMENT_TERMINATING) {
            this.transitionToTerminated(element, callActivityContext);
        } else {
            String message = String.format(UNABLE_TO_COMPLETE_FROM_STATE_MESSAGE, currentState);
            throw new BpmnProcessingException(callActivityContext, message);
        }
    }

    @Override
    public void onChildTerminated(ExecutableCallActivity element, BpmnElementContext callActivityContext, BpmnElementContext childContext) {
        ProcessInstanceIntent currentState = callActivityContext.getIntent();
        if (currentState != ProcessInstanceIntent.ELEMENT_TERMINATING) {
            String message = String.format(UNABLE_TO_TERMINATE_FROM_STATE_MESSAGE, currentState);
            throw new BpmnProcessingException(callActivityContext, message);
        }
        this.transitionToTerminated(element, callActivityContext);
    }

    private Either<Failure, Void> validateProcessDepth(BpmnElementContext context) {
        boolean isExceedingMaxDepth;
        ElementInstance processInstance = this.stateBehavior.getElementInstance(context.getProcessInstanceKey());
        int processDepth = processInstance.getProcessDepth();
        boolean bl = isExceedingMaxDepth = processDepth + 1 > this.maxProcessDepth;
        if (isExceedingMaxDepth) {
            String message = MAX_DEPTH_EXCEEDED_MESSAGE.formatted(this.maxProcessDepth);
            return Either.left((Object)new Failure(message, ErrorType.CALLED_ELEMENT_ERROR));
        }
        return Either.right(null);
    }

    private void transitionToTerminated(ExecutableCallActivity element, BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.stateBehavior.getFlowScopeInstance(context);
        this.eventSubscriptionBehavior.findEventTrigger(context).filter(eventTrigger -> flowScopeInstance.isActive()).filter(eventTrigger -> !flowScopeInstance.isInterrupted()).ifPresentOrElse(eventTrigger -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context, element.getEventType());
            this.eventSubscriptionBehavior.activateTriggeredEvent(context.getElementInstanceKey(), terminated.getFlowScopeKey(), (EventTrigger)((Object)eventTrigger), terminated);
        }, () -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context, element.getEventType());
            this.stateTransitionBehavior.onElementTerminated(element, terminated);
        });
    }

    private Either<Failure, DirectBuffer> evaluateProcessId(BpmnElementContext context, ExecutableCallActivity element) {
        Expression processIdExpression = element.getCalledElementProcessId();
        long scopeKey = context.getElementInstanceKey();
        return this.expressionProcessor.evaluateStringExpressionAsDirectBuffer(processIdExpression, scopeKey);
    }

    private Either<Failure, DeployedProcess> getCalledProcess(DirectBuffer processId, ZeebeBindingType bindingType, String versionTag, BpmnElementContext context) {
        return switch (bindingType) {
            default -> throw new MatchException(null, null);
            case ZeebeBindingType.deployment -> this.getProcessVersionInSameDeployment(processId, context);
            case ZeebeBindingType.latest -> this.getLatestProcessVersion(processId, context.getTenantId());
            case ZeebeBindingType.versionTag -> this.getLatestProcessVersionWithVersionTag(processId, versionTag, context.getTenantId());
        };
    }

    private Either<Failure, DeployedProcess> getProcessVersionInSameDeployment(DirectBuffer processId, BpmnElementContext context) {
        return this.stateBehavior.getDeploymentKey(context.getProcessDefinitionKey(), context.getTenantId()).flatMap(deploymentKey -> this.stateBehavior.getProcessByProcessIdAndDeploymentKey(processId, (long)deploymentKey, context.getTenantId()).map(Either::right).orElseGet(() -> Either.left((Object)new Failure(String.format("Expected to call process with BPMN process id '%s' with binding type 'deployment', but no such process found in the deployment with key %s which contained the current process. To resolve this incident, migrate the process instance to a process definition that is deployed together with the intended process definition to call.", BufferUtil.bufferAsString((DirectBuffer)processId), deploymentKey), ErrorType.CALLED_ELEMENT_ERROR))));
    }

    private Either<Failure, DeployedProcess> getLatestProcessVersion(DirectBuffer processId, String tenantId) {
        Optional<DeployedProcess> process = this.stateBehavior.getLatestProcessVersion(processId, tenantId);
        return process.map(Either::right).orElseGet(() -> Either.left((Object)new Failure(String.format("Expected process with BPMN process id '%s' to be deployed, but not found.", BufferUtil.bufferAsString((DirectBuffer)processId)), ErrorType.CALLED_ELEMENT_ERROR)));
    }

    private Either<Failure, DeployedProcess> getLatestProcessVersionWithVersionTag(DirectBuffer processId, String versionTag, String tenantId) {
        Optional<DeployedProcess> process = this.stateBehavior.getProcessByProcessIdAndVersionTag(processId, versionTag, tenantId);
        return process.map(Either::right).orElseGet(() -> Either.left((Object)new Failure(String.format("Expected to call process with BPMN process id '%s' and version tag '%s', but no such process found. To resolve this incident, deploy a process with the given process id and version tag.", BufferUtil.bufferAsString((DirectBuffer)processId), versionTag), ErrorType.CALLED_ELEMENT_ERROR)));
    }

    private Either<Failure, DeployedProcess> checkProcessHasNoneStartEvent(DeployedProcess process) {
        if (process.getProcess().getNoneStartEvent() == null) {
            return Either.left((Object)new Failure(String.format("Expected process with BPMN process id '%s' to have a none start event, but not found.", BufferUtil.bufferAsString((DirectBuffer)process.getBpmnProcessId())), ErrorType.CALLED_ELEMENT_ERROR));
        }
        return Either.right((Object)process);
    }
}

