/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.authorization;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.authorization.PersistedAuthorization;
import io.camunda.zeebe.engine.state.authorization.ResourceIdentifiers;
import io.camunda.zeebe.engine.state.immutable.AuthorizationState;
import io.camunda.zeebe.engine.state.mutable.MutableAuthorizationState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.record.value.AuthorizationOwnerType;
import io.camunda.zeebe.protocol.record.value.AuthorizationResourceType;
import io.camunda.zeebe.protocol.record.value.PermissionType;
import java.util.List;
import java.util.Optional;

public class DbAuthorizationState
implements AuthorizationState,
MutableAuthorizationState {
    private final PersistedAuthorization persistedAuthorization = new PersistedAuthorization();
    private final ResourceIdentifiers resourceIdentifiers = new ResourceIdentifiers();
    private final DbLong ownerKey = new DbLong();
    private final DbString resourceType = new DbString();
    private final DbString permissionType = new DbString();
    private final DbCompositeKey<DbString, DbString> resourceTypeAndPermissionCompositeKey = new DbCompositeKey((DbKey)this.resourceType, (DbKey)this.permissionType);
    private final DbCompositeKey<DbLong, DbCompositeKey<DbString, DbString>> ownerKeyAndResourceTypeAndPermissionCompositeKey = new DbCompositeKey((DbKey)this.ownerKey, this.resourceTypeAndPermissionCompositeKey);
    private final ColumnFamily<DbCompositeKey<DbLong, DbCompositeKey<DbString, DbString>>, ResourceIdentifiers> resourceIdsByOwnerKeyResourceTypeAndPermissionColumnFamily;
    private final DbString resourceId;
    private final DbCompositeKey<DbString, DbCompositeKey<DbLong, DbCompositeKey<DbString, DbString>>> resourceIdAndOwnerKeyAndResourceTypeAndPermissionTypeCompositeKey;
    private final ColumnFamily<DbCompositeKey<DbString, DbCompositeKey<DbLong, DbCompositeKey<DbString, DbString>>>, DbNil> authorizationKeyByResourceIdColumnFamily;
    private final DbString ownerType;
    private final ColumnFamily<DbLong, DbString> ownerTypeByOwnerKeyColumnFamily;

    public DbAuthorizationState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.resourceIdsByOwnerKeyResourceTypeAndPermissionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.RESOURCE_IDS_BY_OWNER_KEY_RESOURCE_TYPE_AND_PERMISSION, transactionContext, this.ownerKeyAndResourceTypeAndPermissionCompositeKey, (DbValue)this.resourceIdentifiers);
        this.resourceId = new DbString();
        this.resourceIdAndOwnerKeyAndResourceTypeAndPermissionTypeCompositeKey = new DbCompositeKey((DbKey)this.resourceId, this.ownerKeyAndResourceTypeAndPermissionCompositeKey);
        this.authorizationKeyByResourceIdColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.AUTHORIZATION_KEY_BY_RESOURCE_ID, transactionContext, this.resourceIdAndOwnerKeyAndResourceTypeAndPermissionTypeCompositeKey, (DbValue)DbNil.INSTANCE);
        this.ownerType = new DbString();
        this.ownerTypeByOwnerKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.OWNER_TYPE_BY_OWNER_KEY, transactionContext, (DbKey)this.ownerKey, (DbValue)this.ownerType);
    }

    @Override
    public void createOrAddPermission(long ownerKey, AuthorizationResourceType resourceType, PermissionType permissionType, List<String> resourceIds) {
        this.ownerKey.wrapLong(ownerKey);
        this.resourceType.wrapString(resourceType.name());
        this.permissionType.wrapString(permissionType.name());
        ResourceIdentifiers identifiers = Optional.ofNullable((ResourceIdentifiers)this.resourceIdsByOwnerKeyResourceTypeAndPermissionColumnFamily.get(this.ownerKeyAndResourceTypeAndPermissionCompositeKey)).orElse(new ResourceIdentifiers());
        identifiers.addResourceIdentifiers(resourceIds);
        this.resourceIdsByOwnerKeyResourceTypeAndPermissionColumnFamily.upsert(this.ownerKeyAndResourceTypeAndPermissionCompositeKey, (DbValue)identifiers);
        resourceIds.forEach(resourceId -> {
            this.resourceId.wrapString(resourceId);
            this.authorizationKeyByResourceIdColumnFamily.insert(this.resourceIdAndOwnerKeyAndResourceTypeAndPermissionTypeCompositeKey, (DbValue)DbNil.INSTANCE);
        });
    }

    @Override
    public void insertOwnerTypeByKey(long ownerKey, AuthorizationOwnerType ownerType) {
        this.ownerKey.wrapLong(ownerKey);
        this.ownerType.wrapString(ownerType.name());
        this.ownerTypeByOwnerKeyColumnFamily.insert((DbKey)this.ownerKey, (DbValue)this.ownerType);
    }

    @Override
    public ResourceIdentifiers getResourceIdentifiers(Long ownerKey, AuthorizationResourceType resourceType, PermissionType permissionType) {
        this.ownerKey.wrapLong(ownerKey.longValue());
        this.resourceType.wrapString(resourceType.name());
        this.permissionType.wrapString(permissionType.name());
        ResourceIdentifiers persistedPermissions = (ResourceIdentifiers)this.resourceIdsByOwnerKeyResourceTypeAndPermissionColumnFamily.get(this.ownerKeyAndResourceTypeAndPermissionCompositeKey);
        return persistedPermissions == null ? null : persistedPermissions.copy();
    }

    @Override
    public Optional<AuthorizationOwnerType> getOwnerType(long ownerKey) {
        this.ownerKey.wrapLong(ownerKey);
        DbString ownerType = (DbString)this.ownerTypeByOwnerKeyColumnFamily.get((DbKey)this.ownerKey);
        if (ownerType == null) {
            return Optional.empty();
        }
        return Optional.of(AuthorizationOwnerType.valueOf((String)ownerType.toString()));
    }
}

