/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.streamprocessor.writers;

import io.camunda.zeebe.engine.processing.streamprocessor.writers.ResultBuilderBackedEventApplyingStateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.ResultBuilderBackedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.ResultBuilderBackedSideEffectWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.ResultBuilderBackedTypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.ResultBuilderBackedTypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.SideEffectWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.state.EventApplier;
import io.camunda.zeebe.stream.api.ProcessingResultBuilder;
import java.util.function.Supplier;

public final class Writers {
    private final TypedCommandWriter commandWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final StateWriter stateWriter;
    private final TypedResponseWriter responseWriter;
    private final SideEffectWriter sideEffectWriter;

    public Writers(Supplier<ProcessingResultBuilder> resultBuilderSupplier, EventApplier eventApplier) {
        this.commandWriter = new ResultBuilderBackedTypedCommandWriter(resultBuilderSupplier);
        this.rejectionWriter = new ResultBuilderBackedRejectionWriter(resultBuilderSupplier);
        this.stateWriter = new ResultBuilderBackedEventApplyingStateWriter(resultBuilderSupplier, eventApplier);
        this.responseWriter = new ResultBuilderBackedTypedResponseWriter(resultBuilderSupplier);
        this.sideEffectWriter = new ResultBuilderBackedSideEffectWriter(resultBuilderSupplier);
    }

    public TypedCommandWriter command() {
        return this.commandWriter;
    }

    public TypedRejectionWriter rejection() {
        return this.rejectionWriter;
    }

    public SideEffectWriter sideEffect() {
        return this.sideEffectWriter;
    }

    public StateWriter state() {
        return this.stateWriter;
    }

    public TypedResponseWriter response() {
        return this.responseWriter;
    }
}

