/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job.behaviour;

import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.util.Either;
import java.time.InstantSource;
import java.util.Optional;

public class JobUpdateBehaviour {
    public static final String NO_JOB_FOUND_MESSAGE = "Expected to update job with key '%d', but no such job was found";
    public static final String NO_DEADLINE_FOUND_MESSAGE = "Expected to update the timeout of job with key '%d', but it is not active";
    private static final String NEGATIVE_RETRIES_MESSAGE = "Expected to update retries for job with key '%d' with a positive amount of retries, but the amount given was '%d'";
    private final JobState jobState;
    private final TypedRejectionWriter rejectionWriter;
    private final InstantSource clock;

    public JobUpdateBehaviour(JobState jobState, Writers writers, InstantSource clock) {
        this.jobState = jobState;
        this.rejectionWriter = writers.rejection();
        this.clock = clock;
    }

    public Either<String, JobRecord> getJob(long jobKey, TypedRecord<JobRecord> command) {
        JobRecord job = this.jobState.getJob(jobKey, command.getAuthorizations());
        if (job != null) {
            return Either.right((Object)job);
        }
        this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, NO_JOB_FOUND_MESSAGE.formatted(jobKey));
        return Either.left((Object)NO_JOB_FOUND_MESSAGE.formatted(jobKey));
    }

    public Optional<String> updateJobRetries(long jobKey, int retries, JobRecord jobRecord) {
        if (retries < 1) {
            return Optional.of(NEGATIVE_RETRIES_MESSAGE.formatted(jobKey, retries));
        }
        jobRecord.setRetries(retries);
        return Optional.empty();
    }

    public Optional<String> updateJobTimeout(long jobKey, long timeout, JobRecord jobRecord) {
        long oldDeadline = jobRecord.getDeadline();
        if (!this.jobState.jobDeadlineExists(jobKey, oldDeadline)) {
            return Optional.of(NO_DEADLINE_FOUND_MESSAGE.formatted(jobKey));
        }
        long newDeadline = this.clock.millis() + timeout;
        jobRecord.setDeadline(newDeadline);
        return Optional.empty();
    }
}

