/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.identity;

import io.camunda.zeebe.engine.processing.distribution.CommandDistributionBehavior;
import io.camunda.zeebe.engine.processing.streamprocessor.DistributedTypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.distribution.DistributionQueue;
import io.camunda.zeebe.engine.state.immutable.AuthorizationState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.authorization.AuthorizationRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.AuthorizationIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.AuthorizationOwnerType;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;

public final class AuthorizationAddPermissionProcessor
implements DistributedTypedRecordProcessor<AuthorizationRecord> {
    private final KeyGenerator keyGenerator;
    private final AuthorizationState authorizationState;
    private final CommandDistributionBehavior distributionBehavior;
    private final StateWriter stateWriter;
    private final TypedResponseWriter responseWriter;
    private final TypedRejectionWriter rejectionWriter;

    public AuthorizationAddPermissionProcessor(Writers writers, KeyGenerator keyGenerator, ProcessingState processingState, CommandDistributionBehavior distributionBehavior) {
        this.keyGenerator = keyGenerator;
        this.authorizationState = processingState.getAuthorizationState();
        this.distributionBehavior = distributionBehavior;
        this.stateWriter = writers.state();
        this.responseWriter = writers.response();
        this.rejectionWriter = writers.rejection();
    }

    @Override
    public void processNewCommand(TypedRecord<AuthorizationRecord> command) {
        AuthorizationRecord authorizationRecord = (AuthorizationRecord)command.getValue();
        AuthorizationOwnerType ownerType = this.authorizationState.getOwnerType(authorizationRecord.getOwnerKey()).orElseThrow(() -> new OwnerNotFoundException(authorizationRecord.getOwnerKey()));
        authorizationRecord.setOwnerType(ownerType);
        long key = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(key, (Intent)AuthorizationIntent.PERMISSION_ADDED, (RecordValue)authorizationRecord);
        this.distributionBehavior.withKey(key).inQueue(DistributionQueue.IDENTITY.getQueueId()).distribute(command);
        this.responseWriter.writeEventOnCommand(key, (Intent)AuthorizationIntent.PERMISSION_ADDED, (UnpackedObject)authorizationRecord, command);
    }

    @Override
    public void processDistributedCommand(TypedRecord<AuthorizationRecord> command) {
        this.stateWriter.appendFollowUpEvent(command.getKey(), (Intent)AuthorizationIntent.PERMISSION_ADDED, (RecordValue)command.getValue());
        this.distributionBehavior.acknowledgeCommand(command);
    }

    @Override
    public TypedRecordProcessor.ProcessingError tryHandleError(TypedRecord<AuthorizationRecord> command, Throwable error) {
        if (error instanceof OwnerNotFoundException) {
            OwnerNotFoundException exception = (OwnerNotFoundException)error;
            this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, exception.getMessage());
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.NOT_FOUND, exception.getMessage());
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }
        return TypedRecordProcessor.ProcessingError.UNEXPECTED_ERROR;
    }

    private static final class OwnerNotFoundException
    extends RuntimeException {
        public static final String OWNER_NOT_FOUND_MESSAGE = "Expected to find owner with key: '%d', but none was found";

        public OwnerNotFoundException(long ownerKey) {
            super(OWNER_NOT_FOUND_MESSAGE.formatted(ownerKey));
        }
    }
}

