/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.transform;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.transform.DeploymentResourceTransformer;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.state.immutable.FormState;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.impl.record.value.deployment.FormMetadataRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.FormRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.FormIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.agrona.DirectBuffer;

public final class FormResourceTransformer
implements DeploymentResourceTransformer {
    private static final int INITIAL_VERSION = 1;
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private final KeyGenerator keyGenerator;
    private final StateWriter stateWriter;
    private final Function<byte[], DirectBuffer> checksumGenerator;
    private final FormState formState;

    public FormResourceTransformer(KeyGenerator keyGenerator, StateWriter stateWriter, Function<byte[], DirectBuffer> checksumGenerator, FormState formState) {
        this.keyGenerator = keyGenerator;
        this.stateWriter = stateWriter;
        this.checksumGenerator = checksumGenerator;
        this.formState = formState;
    }

    @Override
    public Either<Failure, Void> createMetadata(DeploymentResource resource, DeploymentRecord deployment) {
        return this.parseForm(resource).flatMap(form -> this.checkForDuplicateFormId(form.id, resource, deployment).map(noDuplicates -> {
            FormMetadataRecord formRecord = (FormMetadataRecord)deployment.formMetadata().add();
            this.appendMetadataToFormRecord(formRecord, (Form)form, resource, deployment);
            return null;
        }));
    }

    @Override
    public Either<Failure, Void> writeRecords(DeploymentResource resource, DeploymentRecord deployment) {
        if (deployment.hasDuplicatesOnly()) {
            return Either.right(null);
        }
        DirectBuffer checksum = this.checksumGenerator.apply(resource.getResource());
        deployment.formMetadata().stream().filter(metadata -> checksum.equals((Object)metadata.getChecksumBuffer())).findFirst().ifPresent(metadata -> {
            long key = metadata.getFormKey();
            if (metadata.isDuplicate()) {
                key = this.keyGenerator.nextKey();
                metadata.setFormKey(key).setVersion(this.formState.getNextFormVersion(metadata.getFormId(), metadata.getTenantId())).setDuplicate(false).setDeploymentKey(deployment.getDeploymentKey());
            }
            this.writeFormRecord((FormMetadataRecord)metadata, resource);
        });
        return Either.right(null);
    }

    private Either<Failure, Form> parseForm(DeploymentResource resource) {
        try {
            Form form = (Form)JSON_MAPPER.readValue(resource.getResource(), Form.class);
            return this.validateForm(form);
        }
        catch (JsonProcessingException e) {
            String failureMessage = String.format("Failed to parse form JSON. '%s': %s", resource.getResourceName(), e.getCause().getMessage());
            return Either.left((Object)new Failure(failureMessage));
        }
        catch (IOException e) {
            String failureMessage = String.format("'%s': %s", resource.getResourceName(), e.getCause().getMessage());
            return Either.left((Object)new Failure(failureMessage));
        }
    }

    private Either<Failure, ?> checkForDuplicateFormId(String formId, DeploymentResource resource, DeploymentRecord record) {
        return record.getFormMetadata().stream().filter(metadata -> metadata.getFormId().equals(formId)).findFirst().map(duplicatedForm -> {
            String failureMessage = String.format("Expected the form ids to be unique within a deployment but found a duplicated id '%s' in the resources '%s' and '%s'.", formId, duplicatedForm.getResourceName(), resource.getResourceName());
            return Either.left((Object)new Failure(failureMessage));
        }).orElse(Either.right(null));
    }

    private void appendMetadataToFormRecord(FormMetadataRecord formRecord, Form form, DeploymentResource resource, DeploymentRecord deployment) {
        LongSupplier newFormKey = () -> ((KeyGenerator)this.keyGenerator).nextKey();
        DirectBuffer checksum = this.checksumGenerator.apply(resource.getResource());
        String tenantId = deployment.getTenantId();
        formRecord.setFormId(form.id);
        formRecord.setChecksum(checksum);
        formRecord.setResourceName(resource.getResourceName());
        formRecord.setTenantId(tenantId);
        Optional.ofNullable(form.versionTag).ifPresent(arg_0 -> ((FormMetadataRecord)formRecord).setVersionTag(arg_0));
        this.formState.findLatestFormById(BufferUtil.wrapString((String)formRecord.getFormId()), tenantId).ifPresentOrElse(latestForm -> {
            boolean isDuplicate;
            boolean bl = isDuplicate = latestForm.getChecksum().equals((Object)formRecord.getChecksumBuffer()) && latestForm.getResourceName().equals((Object)formRecord.getResourceNameBuffer());
            if (isDuplicate) {
                int latestVersion = latestForm.getVersion();
                formRecord.setFormKey(latestForm.getFormKey()).setVersion(latestVersion).setDeploymentKey(latestForm.getDeploymentKey()).setDuplicate(true);
            } else {
                formRecord.setFormKey(newFormKey.getAsLong()).setVersion(this.formState.getNextFormVersion(form.id, tenantId)).setDeploymentKey(deployment.getDeploymentKey());
            }
        }, () -> formRecord.setFormKey(newFormKey.getAsLong()).setVersion(1).setDeploymentKey(deployment.getDeploymentKey()));
    }

    private void writeFormRecord(FormMetadataRecord formRecord, DeploymentResource resource) {
        this.stateWriter.appendFollowUpEvent(formRecord.getFormKey(), (Intent)FormIntent.CREATED, (RecordValue)new FormRecord().wrap(formRecord, resource.getResource()));
    }

    private Either<Failure, Form> validateForm(Form form) {
        if (form.id == null) {
            return Either.left((Object)new Failure("Expected the form id to be present, but none given"));
        }
        if (form.id.isBlank()) {
            return Either.left((Object)new Failure("Expected the form id to be filled, but it is blank"));
        }
        return Either.right((Object)form);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private record Form(String id, String versionTag) {
    }
}

