/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.processing.deployment.model.BpmnFactory;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.BpmnTransformer;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.deployment.Digest;
import io.camunda.zeebe.engine.state.deployment.PersistedProcess;
import io.camunda.zeebe.engine.state.deployment.VersionManager;
import io.camunda.zeebe.engine.state.mutable.MutableProcessState;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.io.DirectBufferInputStream;

public final class DbProcessState
implements MutableProcessState {
    private static final int DEFAULT_VERSION_VALUE = 0;
    private final BpmnTransformer transformer = BpmnFactory.createTransformer();
    private final ProcessRecord processRecordForDeployments = new ProcessRecord();
    private final Map<String, Map<DirectBuffer, Long2ObjectHashMap<DeployedProcess>>> processesByTenantAndProcessIdAndVersionCache = new HashMap<String, Map<DirectBuffer, Long2ObjectHashMap<DeployedProcess>>>();
    private final Map<String, Long2ObjectHashMap<DeployedProcess>> processByTenantAndKeyCache;
    private final ColumnFamily<DbTenantAwareKey<DbLong>, PersistedProcess> processColumnFamily;
    private final DbLong processDefinitionKey;
    private final PersistedProcess persistedProcess;
    private final DbString tenantIdKey;
    private final DbTenantAwareKey<DbLong> tenantAwareProcessDefinitionKey;
    private final ColumnFamily<DbTenantAwareKey<DbCompositeKey<DbString, DbLong>>, PersistedProcess> processByIdAndVersionColumnFamily;
    private final DbLong processVersion;
    private final DbCompositeKey<DbString, DbLong> idAndVersionKey;
    private final DbTenantAwareKey<DbCompositeKey<DbString, DbLong>> tenantAwareProcessIdAndVersionKey;
    private final DbString processId;
    private final DbTenantAwareKey<DbString> tenantAwareProcessId;
    private final DbForeignKey<DbTenantAwareKey<DbString>> fkTenantAwareProcessId;
    private final ColumnFamily<DbForeignKey<DbTenantAwareKey<DbString>>, Digest> digestByIdColumnFamily;
    private final Digest digest = new Digest();
    private final VersionManager versionManager;

    public DbProcessState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.processDefinitionKey = new DbLong();
        this.persistedProcess = new PersistedProcess();
        this.tenantIdKey = new DbString();
        this.tenantAwareProcessDefinitionKey = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.processDefinitionKey, DbTenantAwareKey.PlacementType.PREFIX);
        this.processColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_CACHE, transactionContext, this.tenantAwareProcessDefinitionKey, (DbValue)this.persistedProcess);
        this.processId = new DbString();
        this.processVersion = new DbLong();
        this.idAndVersionKey = new DbCompositeKey((DbKey)this.processId, (DbKey)this.processVersion);
        this.tenantAwareProcessIdAndVersionKey = new DbTenantAwareKey(this.tenantIdKey, this.idAndVersionKey, DbTenantAwareKey.PlacementType.PREFIX);
        this.processByIdAndVersionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_CACHE_BY_ID_AND_VERSION, transactionContext, this.tenantAwareProcessIdAndVersionKey, (DbValue)this.persistedProcess);
        this.tenantAwareProcessId = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.processId, DbTenantAwareKey.PlacementType.PREFIX);
        this.fkTenantAwareProcessId = new DbForeignKey(this.tenantAwareProcessId, (Enum)ZbColumnFamilies.PROCESS_CACHE_BY_ID_AND_VERSION, DbForeignKey.MatchType.Prefix);
        this.digestByIdColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_CACHE_DIGEST_BY_ID, transactionContext, this.fkTenantAwareProcessId, (DbValue)this.digest);
        this.processByTenantAndKeyCache = new HashMap<String, Long2ObjectHashMap<DeployedProcess>>();
        this.versionManager = new VersionManager(0L, zeebeDb, ZbColumnFamilies.PROCESS_VERSION, transactionContext);
    }

    @Override
    public void putDeployment(DeploymentRecord deploymentRecord) {
        for (ProcessMetadata metadata : deploymentRecord.processesMetadata()) {
            for (DeploymentResource resource : deploymentRecord.getResources()) {
                if (!resource.getResourceName().equals(metadata.getResourceName())) continue;
                this.processRecordForDeployments.reset();
                this.processRecordForDeployments.wrap(metadata, resource.getResource());
                this.putProcess(metadata.getKey(), this.processRecordForDeployments);
            }
        }
    }

    @Override
    public void putLatestVersionDigest(ProcessRecord processRecord) {
        this.tenantIdKey.wrapString(processRecord.getTenantId());
        this.processId.wrapBuffer(processRecord.getBpmnProcessIdBuffer());
        this.digest.set(processRecord.getChecksumBuffer());
        this.digestByIdColumnFamily.upsert(this.fkTenantAwareProcessId, (DbValue)this.digest);
    }

    @Override
    public void putProcess(long key, ProcessRecord processRecord) {
        this.persistProcess(key, processRecord);
        this.updateLatestVersion(processRecord);
        this.putLatestVersionDigest(processRecord);
    }

    @Override
    public void updateProcessState(ProcessRecord processRecord, PersistedProcess.PersistedProcessState state) {
        this.tenantIdKey.wrapString(processRecord.getTenantId());
        this.processDefinitionKey.wrapLong(processRecord.getProcessDefinitionKey());
        PersistedProcess process = (PersistedProcess)this.processColumnFamily.get(this.tenantAwareProcessDefinitionKey);
        process.setState(state);
        this.processColumnFamily.update(this.tenantAwareProcessDefinitionKey, (DbValue)process);
        this.updateInMemoryState(process);
    }

    @Override
    public void deleteProcess(ProcessRecord processRecord) {
        this.tenantIdKey.wrapString(processRecord.getTenantId());
        this.processDefinitionKey.wrapLong(processRecord.getProcessDefinitionKey());
        this.processId.wrapString(processRecord.getBpmnProcessId());
        this.processVersion.wrapLong((long)processRecord.getVersion());
        this.processColumnFamily.deleteExisting(this.tenantAwareProcessDefinitionKey);
        this.processByIdAndVersionColumnFamily.deleteExisting(this.tenantAwareProcessIdAndVersionKey);
        ((Map)this.processesByTenantAndProcessIdAndVersionCache.getOrDefault(processRecord.getTenantId(), new HashMap())).remove(processRecord.getBpmnProcessIdBuffer());
        this.processByTenantAndKeyCache.getOrDefault(processRecord.getTenantId(), (Long2ObjectHashMap<DeployedProcess>)new Long2ObjectHashMap()).remove(processRecord.getProcessDefinitionKey());
        long latestVersion = this.versionManager.getLatestResourceVersion(processRecord.getBpmnProcessId(), processRecord.getTenantId());
        if (latestVersion == (long)processRecord.getVersion()) {
            this.digestByIdColumnFamily.deleteIfExists(this.fkTenantAwareProcessId);
        }
        this.versionManager.deleteResourceVersion(processRecord.getBpmnProcessId(), processRecord.getVersion(), processRecord.getTenantId());
    }

    private void persistProcess(long processDefinitionKey, ProcessRecord processRecord) {
        this.tenantIdKey.wrapString(processRecord.getTenantId());
        this.persistedProcess.wrap(processRecord, processDefinitionKey);
        this.processDefinitionKey.wrapLong(processDefinitionKey);
        this.processColumnFamily.upsert(this.tenantAwareProcessDefinitionKey, (DbValue)this.persistedProcess);
        this.processId.wrapBuffer(processRecord.getBpmnProcessIdBuffer());
        this.processVersion.wrapLong((long)processRecord.getVersion());
        this.processByIdAndVersionColumnFamily.upsert(this.tenantAwareProcessIdAndVersionKey, (DbValue)this.persistedProcess);
    }

    private void updateLatestVersion(ProcessRecord processRecord) {
        this.processId.wrapBuffer(processRecord.getBpmnProcessIdBuffer());
        String bpmnProcessId = processRecord.getBpmnProcessId();
        int version = processRecord.getVersion();
        this.versionManager.addResourceVersion(bpmnProcessId, version, processRecord.getTenantId());
    }

    private DeployedProcess updateInMemoryState(PersistedProcess persistedProcess) {
        byte[] bytes = new byte[persistedProcess.getLength()];
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        persistedProcess.write((MutableDirectBuffer)buffer, 0);
        PersistedProcess copiedProcess = new PersistedProcess();
        copiedProcess.wrap((DirectBuffer)buffer, 0, persistedProcess.getLength());
        BpmnModelInstance modelInstance = this.readModelInstanceFromBuffer(copiedProcess.getResource());
        List<ExecutableProcess> definitions = this.transformer.transformDefinitions(modelInstance);
        ExecutableProcess executableProcess = definitions.stream().filter(process -> BufferUtil.equals((DirectBuffer)persistedProcess.getBpmnProcessId(), (DirectBuffer)process.getId())).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("Expected to find executable process in persisted process with key '%s', but after transformation no such executable process could be found.", persistedProcess.getKey())));
        DeployedProcess deployedProcess = new DeployedProcess(executableProcess, copiedProcess);
        this.addProcessToInMemoryState(deployedProcess);
        return deployedProcess;
    }

    private BpmnModelInstance readModelInstanceFromBuffer(DirectBuffer buffer) {
        try (DirectBufferInputStream stream = new DirectBufferInputStream(buffer);){
            BpmnModelInstance bpmnModelInstance = Bpmn.readModelFromStream((InputStream)stream);
            return bpmnModelInstance;
        }
    }

    private void addProcessToInMemoryState(DeployedProcess deployedProcess) {
        DirectBuffer bpmnProcessId = deployedProcess.getBpmnProcessId();
        Long2ObjectHashMap keyMap = this.processByTenantAndKeyCache.computeIfAbsent(deployedProcess.getTenantId(), key -> new Long2ObjectHashMap());
        keyMap.put(deployedProcess.getKey(), (Object)deployedProcess);
        Long2ObjectHashMap versionMap = this.processesByTenantAndProcessIdAndVersionCache.computeIfAbsent(deployedProcess.getTenantId(), key -> new HashMap()).computeIfAbsent(bpmnProcessId, key -> new Long2ObjectHashMap());
        int version = deployedProcess.getVersion();
        versionMap.put((long)version, (Object)deployedProcess);
    }

    @Override
    public DeployedProcess getLatestProcessVersionByProcessId(DirectBuffer processIdBuffer, String tenantId) {
        DeployedProcess deployedProcess;
        Long2ObjectHashMap versionMap = (Long2ObjectHashMap)((Map)this.processesByTenantAndProcessIdAndVersionCache.getOrDefault(tenantId, new HashMap())).get(processIdBuffer);
        this.processId.wrapBuffer(processIdBuffer);
        long latestVersion = this.versionManager.getLatestResourceVersion(processIdBuffer, tenantId);
        if (versionMap == null) {
            deployedProcess = this.lookupProcessByIdAndPersistedVersion(latestVersion, tenantId);
        } else {
            deployedProcess = (DeployedProcess)versionMap.get(latestVersion);
            if (deployedProcess == null) {
                deployedProcess = this.lookupProcessByIdAndPersistedVersion(latestVersion, tenantId);
            }
        }
        return deployedProcess;
    }

    @Override
    public DeployedProcess getProcessByProcessIdAndVersion(DirectBuffer processId, int version, String tenantId) {
        Long2ObjectHashMap versionMap = (Long2ObjectHashMap)((Map)this.processesByTenantAndProcessIdAndVersionCache.getOrDefault(tenantId, new HashMap())).get(processId);
        if (versionMap != null) {
            DeployedProcess deployedProcess = (DeployedProcess)versionMap.get((long)version);
            return deployedProcess != null ? deployedProcess : this.lookupPersistenceState(processId, version, tenantId);
        }
        return this.lookupPersistenceState(processId, version, tenantId);
    }

    @Override
    public DeployedProcess getProcessByKeyAndTenant(long key, String tenantId) {
        DeployedProcess deployedProcess = (DeployedProcess)this.processByTenantAndKeyCache.getOrDefault(tenantId, (Long2ObjectHashMap<DeployedProcess>)new Long2ObjectHashMap()).get(key);
        if (deployedProcess != null) {
            return deployedProcess;
        }
        return this.lookupPersistenceStateForProcessByKey(key, tenantId);
    }

    @Override
    public DirectBuffer getLatestVersionDigest(DirectBuffer processIdBuffer, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        this.processId.wrapBuffer(processIdBuffer);
        Digest latestDigest = (Digest)this.digestByIdColumnFamily.get(this.fkTenantAwareProcessId);
        return latestDigest == null || this.digest.get().byteArray() == null ? null : latestDigest.get();
    }

    @Override
    public int getLatestProcessVersion(String bpmnProcessId, String tenantId) {
        return (int)this.versionManager.getLatestResourceVersion(bpmnProcessId, tenantId);
    }

    @Override
    public int getNextProcessVersion(String bpmnProcessId, String tenantId) {
        return (int)this.versionManager.getHighestResourceVersion(bpmnProcessId, tenantId) + 1;
    }

    @Override
    public Optional<Integer> findProcessVersionBefore(String bpmnProcessId, long version, String tenantId) {
        return this.versionManager.findResourceVersionBefore(bpmnProcessId, version, tenantId);
    }

    @Override
    public <T extends ExecutableFlowElement> T getFlowElement(long processDefinitionKey, String tenantId, DirectBuffer elementId, Class<T> elementType) {
        DeployedProcess deployedProcess = this.getProcessByKeyAndTenant(processDefinitionKey, tenantId);
        if (deployedProcess == null) {
            throw new IllegalStateException(String.format("Expected to find a process deployed with key '%d' but not found.", processDefinitionKey));
        }
        ExecutableProcess process = deployedProcess.getProcess();
        T element = process.getElementById(elementId, elementType);
        if (element == null) {
            throw new IllegalStateException(String.format("Expected to find a flow element with id '%s' in process with key '%d' but not found.", BufferUtil.bufferAsString((DirectBuffer)elementId), processDefinitionKey));
        }
        return element;
    }

    @Override
    public void clearCache() {
        this.processByTenantAndKeyCache.clear();
        this.processesByTenantAndProcessIdAndVersionCache.clear();
        this.versionManager.clear();
    }

    private DeployedProcess lookupProcessByIdAndPersistedVersion(long latestVersion, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        this.processVersion.wrapLong(latestVersion);
        PersistedProcess processWithVersionAndId = (PersistedProcess)this.processByIdAndVersionColumnFamily.get(this.tenantAwareProcessIdAndVersionKey);
        if (processWithVersionAndId != null) {
            return this.updateInMemoryState(processWithVersionAndId);
        }
        return null;
    }

    private DeployedProcess lookupPersistenceState(DirectBuffer processIdBuffer, int version, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        this.processId.wrapBuffer(processIdBuffer);
        this.processVersion.wrapLong((long)version);
        PersistedProcess processWithVersionAndId = (PersistedProcess)this.processByIdAndVersionColumnFamily.get(this.tenantAwareProcessIdAndVersionKey);
        if (processWithVersionAndId != null) {
            this.updateInMemoryState(processWithVersionAndId);
            Long2ObjectHashMap newVersionMap = (Long2ObjectHashMap)((Map)this.processesByTenantAndProcessIdAndVersionCache.getOrDefault(tenantId, new HashMap())).get(processIdBuffer);
            if (newVersionMap != null) {
                return (DeployedProcess)newVersionMap.get((long)version);
            }
        }
        return null;
    }

    private DeployedProcess lookupPersistenceStateForProcessByKey(long processDefinitionKey, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        this.processDefinitionKey.wrapLong(processDefinitionKey);
        PersistedProcess processWithKey = (PersistedProcess)this.processColumnFamily.get(this.tenantAwareProcessDefinitionKey);
        if (processWithKey != null) {
            this.updateInMemoryState(processWithKey);
            return (DeployedProcess)this.processByTenantAndKeyCache.getOrDefault(tenantId, (Long2ObjectHashMap<DeployedProcess>)new Long2ObjectHashMap()).get(processDefinitionKey);
        }
        return null;
    }
}

