/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.auth.impl.TenantAuthorizationCheckerImpl;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.EventScopeInstanceState;
import io.camunda.zeebe.engine.state.immutable.IncidentState;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.VariableState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.spec.MsgPackHelper;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceMigrationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.impl.record.value.variable.VariableRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceMigrationIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceMigrationRecordValue;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class ProcessInstanceMigrationMigrateProcessor
implements TypedRecordProcessor<ProcessInstanceMigrationRecord> {
    private static final EnumSet<BpmnElementType> SUPPORTED_ELEMENT_TYPES = EnumSet.of(BpmnElementType.PROCESS, BpmnElementType.SERVICE_TASK);
    private static final Set<BpmnElementType> UNSUPPORTED_ELEMENT_TYPES = EnumSet.complementOf(SUPPORTED_ELEMENT_TYPES);
    private static final String ERROR_MESSAGE_PROCESS_INSTANCE_NOT_FOUND = "Expected to migrate process instance but no process instance found with key '%d'";
    private static final String ERROR_MESSAGE_PROCESS_DEFINITION_NOT_FOUND = "Expected to migrate process instance to process definition but no process definition found with key '%d'";
    private static final String ERROR_MESSAGE_DUPLICATE_SOURCE_ELEMENT_IDS = "Expected to migrate process instance '%s' but the mapping instructions contain duplicate source element ids '%s'.";
    private static final String ERROR_MESSAGE_EVENT_SUBPROCESS_NOT_SUPPORTED_IN_PROCESS_INSTANCE = "Expected to migrate process instance but process instance has an event subprocess. Process instances with event subprocesses cannot be migrated yet.";
    private static final String ERROR_MESSAGE_EVENT_SUBPROCESS_NOT_SUPPORTED_IN_TARGET_PROCESS = "Expected to migrate process instance but target process has an event subprocess. Target processes with event subprocesses cannot be migrated yet.";
    private static final long NO_PARENT = -1L;
    private static final Map<Class<? extends Exception>, RejectionType> MIGRATION_EXCEPTIONS = Map.ofEntries(Map.entry(UnsupportedElementMigrationException.class, RejectionType.INVALID_STATE), Map.entry(UnmappedActiveElementException.class, RejectionType.INVALID_STATE), Map.entry(ElementTypeChangedException.class, RejectionType.INVALID_STATE), Map.entry(ElementWithIncidentException.class, RejectionType.INVALID_STATE), Map.entry(ChangedElementFlowScopeException.class, RejectionType.INVALID_STATE), Map.entry(ChildProcessMigrationException.class, RejectionType.INVALID_STATE), Map.entry(NonExistingElementException.class, RejectionType.INVALID_ARGUMENT), Map.entry(EventSubscriptionMigrationNotSupportedException.class, RejectionType.INVALID_STATE), Map.entry(ConcurrentCommandException.class, RejectionType.INVALID_STATE));
    private static final UnsafeBuffer NIL_VALUE = new UnsafeBuffer(MsgPackHelper.NIL);
    private final VariableRecord variableRecord = new VariableRecord().setValue((DirectBuffer)NIL_VALUE);
    private final StateWriter stateWriter;
    private final TypedResponseWriter responseWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final ElementInstanceState elementInstanceState;
    private final ProcessState processState;
    private final JobState jobState;
    private final VariableState variableState;
    private final IncidentState incidentState;
    private final EventScopeInstanceState eventScopeInstanceState;

    public ProcessInstanceMigrationMigrateProcessor(Writers writers, ProcessingState processingState) {
        this.stateWriter = writers.state();
        this.responseWriter = writers.response();
        this.rejectionWriter = writers.rejection();
        this.elementInstanceState = processingState.getElementInstanceState();
        this.processState = processingState.getProcessState();
        this.jobState = processingState.getJobState();
        this.variableState = processingState.getVariableState();
        this.incidentState = processingState.getIncidentState();
        this.eventScopeInstanceState = processingState.getEventScopeInstanceState();
    }

    @Override
    public void processRecord(TypedRecord<ProcessInstanceMigrationRecord> command) {
        boolean targetProcessHasEventSubprocess;
        boolean processInstanceHasEventSubprocess;
        ProcessInstanceMigrationRecord value = (ProcessInstanceMigrationRecord)command.getValue();
        long processInstanceKey = value.getProcessInstanceKey();
        long targetProcessDefinitionKey = value.getTargetProcessDefinitionKey();
        List mappingInstructions = value.getMappingInstructions();
        ElementInstance processInstance = this.elementInstanceState.getInstance(processInstanceKey);
        if (processInstance == null) {
            String reason = String.format(ERROR_MESSAGE_PROCESS_INSTANCE_NOT_FOUND, processInstanceKey);
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.NOT_FOUND, reason);
            this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, reason);
            return;
        }
        boolean isTenantAuthorized = TenantAuthorizationCheckerImpl.fromAuthorizationMap((Map)command.getAuthorizations()).isAuthorized(processInstance.getValue().getTenantId());
        if (!isTenantAuthorized) {
            String reason = String.format(ERROR_MESSAGE_PROCESS_INSTANCE_NOT_FOUND, processInstanceKey);
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.NOT_FOUND, reason);
            this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, reason);
            return;
        }
        if (processInstance.getValue().getParentProcessInstanceKey() != -1L) {
            throw new ChildProcessMigrationException(processInstanceKey);
        }
        DeployedProcess targetProcessDefinition = this.processState.getProcessByKeyAndTenant(targetProcessDefinitionKey, processInstance.getValue().getTenantId());
        if (targetProcessDefinition == null) {
            String reason = String.format(ERROR_MESSAGE_PROCESS_DEFINITION_NOT_FOUND, targetProcessDefinitionKey);
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.NOT_FOUND, reason);
            this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, reason);
            return;
        }
        Map<String, Long> countBySourceElementId = mappingInstructions.stream().collect(Collectors.groupingBy(ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue::getSourceElementId, Collectors.counting()));
        List<String> duplicateSourceElementIds = countBySourceElementId.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).toList();
        if (!duplicateSourceElementIds.isEmpty()) {
            String reason = String.format(ERROR_MESSAGE_DUPLICATE_SOURCE_ELEMENT_IDS, processInstanceKey, duplicateSourceElementIds);
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.INVALID_ARGUMENT, reason);
            this.rejectionWriter.appendRejection(command, RejectionType.INVALID_ARGUMENT, reason);
            return;
        }
        DeployedProcess sourceProcessDefinition = this.processState.getProcessByKeyAndTenant(processInstance.getValue().getProcessDefinitionKey(), processInstance.getValue().getTenantId());
        mappingInstructions.forEach(instruction -> {
            String sourceElementId = instruction.getSourceElementId();
            if (sourceProcessDefinition.getProcess().getElementById(sourceElementId) == null) {
                throw new NonExistingElementException(processInstanceKey, sourceElementId, "source");
            }
            String targetElementId = instruction.getTargetElementId();
            if (targetProcessDefinition.getProcess().getElementById(targetElementId) == null) {
                throw new NonExistingElementException(processInstanceKey, targetElementId, "target");
            }
        });
        boolean bl = processInstanceHasEventSubprocess = !sourceProcessDefinition.getProcess().getEventSubprocesses().isEmpty();
        if (processInstanceHasEventSubprocess) {
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.INVALID_STATE, ERROR_MESSAGE_EVENT_SUBPROCESS_NOT_SUPPORTED_IN_PROCESS_INSTANCE);
            this.rejectionWriter.appendRejection(command, RejectionType.INVALID_STATE, ERROR_MESSAGE_EVENT_SUBPROCESS_NOT_SUPPORTED_IN_PROCESS_INSTANCE);
            return;
        }
        boolean bl2 = targetProcessHasEventSubprocess = !targetProcessDefinition.getProcess().getEventSubprocesses().isEmpty();
        if (targetProcessHasEventSubprocess) {
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.INVALID_STATE, ERROR_MESSAGE_EVENT_SUBPROCESS_NOT_SUPPORTED_IN_TARGET_PROCESS);
            this.rejectionWriter.appendRejection(command, RejectionType.INVALID_STATE, ERROR_MESSAGE_EVENT_SUBPROCESS_NOT_SUPPORTED_IN_TARGET_PROCESS);
            return;
        }
        Map<String, String> mappedElementIds = this.mapElementIds(mappingInstructions, processInstance, targetProcessDefinition);
        ArrayDeque<ElementInstance> elementInstances = new ArrayDeque<ElementInstance>(List.of(processInstance));
        while (!elementInstances.isEmpty()) {
            ElementInstance elementInstance = elementInstances.poll();
            this.tryMigrateElementInstance(elementInstance, sourceProcessDefinition, targetProcessDefinition, mappedElementIds);
            List<ElementInstance> children = this.elementInstanceState.getChildren(elementInstance.getKey());
            elementInstances.addAll(children);
        }
        this.stateWriter.appendFollowUpEvent(processInstanceKey, (Intent)ProcessInstanceMigrationIntent.MIGRATED, (RecordValue)value);
        this.responseWriter.writeEventOnCommand(processInstanceKey, (Intent)ProcessInstanceMigrationIntent.MIGRATED, (UnpackedObject)value, command);
    }

    @Override
    public TypedRecordProcessor.ProcessingError tryHandleError(TypedRecord<ProcessInstanceMigrationRecord> command, Throwable error) {
        return MIGRATION_EXCEPTIONS.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isInstance(error)).findFirst().map(entry -> {
            RejectionType rejectionType = (RejectionType)entry.getValue();
            this.rejectionWriter.appendRejection((TypedRecord<? extends RecordValue>)command, rejectionType, error.getMessage());
            this.responseWriter.writeRejectionOnCommand(command, rejectionType, error.getMessage());
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }).orElse(TypedRecordProcessor.ProcessingError.UNEXPECTED_ERROR);
    }

    private Map<String, String> mapElementIds(List<ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> mappingInstructions, ElementInstance processInstance, DeployedProcess targetProcessDefinition) {
        Map<String, String> mappedElementIds = mappingInstructions.stream().collect(Collectors.toMap(ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue::getSourceElementId, ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue::getTargetElementId));
        mappedElementIds.put(processInstance.getValue().getBpmnProcessId(), BufferUtil.bufferAsString((DirectBuffer)targetProcessDefinition.getBpmnProcessId()));
        return mappedElementIds;
    }

    private void tryMigrateElementInstance(ElementInstance elementInstance, DeployedProcess sourceProcessDefinition, DeployedProcess targetProcessDefinition, Map<String, String> sourceElementIdToTargetElementId) {
        JobRecord job;
        boolean hasBoundaryEventInTarget;
        boolean hasBoundaryEventInSource;
        DirectBuffer actualFlowScopeId;
        DirectBuffer expectedFlowScopeId;
        boolean hasIncident;
        ProcessInstanceRecord elementInstanceRecord = elementInstance.getValue();
        long processInstanceKey = elementInstanceRecord.getProcessInstanceKey();
        if (UNSUPPORTED_ELEMENT_TYPES.contains(elementInstanceRecord.getBpmnElementType())) {
            throw new UnsupportedElementMigrationException(processInstanceKey, elementInstanceRecord.getElementId(), elementInstanceRecord.getBpmnElementType());
        }
        String targetElementId = sourceElementIdToTargetElementId.get(elementInstanceRecord.getElementId());
        if (targetElementId == null) {
            throw new UnmappedActiveElementException(processInstanceKey, elementInstanceRecord.getElementId());
        }
        boolean bl = hasIncident = this.incidentState.getProcessInstanceIncidentKey(elementInstance.getKey()) != -1L || elementInstance.getJobKey() > -1L && this.incidentState.getJobIncidentKey(elementInstance.getJobKey()) != -1L;
        if (hasIncident) {
            throw new ElementWithIncidentException(elementInstanceRecord.getProcessInstanceKey(), elementInstanceRecord.getElementId());
        }
        BpmnElementType targetElementType = targetProcessDefinition.getProcess().getElementById(targetElementId).getElementType();
        if (elementInstanceRecord.getBpmnElementType() != targetElementType) {
            throw new ElementTypeChangedException(processInstanceKey, elementInstanceRecord.getElementId(), elementInstanceRecord.getBpmnElementType(), targetElementId, targetElementType);
        }
        ElementInstance sourceFlowScopeElement = this.elementInstanceState.getInstance(elementInstanceRecord.getFlowScopeKey());
        if (sourceFlowScopeElement != null && !(expectedFlowScopeId = sourceFlowScopeElement.getValue().getElementIdBuffer()).equals((Object)(actualFlowScopeId = targetProcessDefinition.getProcess().getElementById(targetElementId).getFlowScope().getId()))) {
            throw new ChangedElementFlowScopeException(elementInstanceRecord.getProcessInstanceKey(), elementInstanceRecord.getElementId(), BufferUtil.bufferAsString((DirectBuffer)expectedFlowScopeId), BufferUtil.bufferAsString((DirectBuffer)actualFlowScopeId));
        }
        boolean bl2 = hasBoundaryEventInSource = !sourceProcessDefinition.getProcess().getElementById(elementInstanceRecord.getElementId(), ExecutableActivity.class).getBoundaryEvents().isEmpty();
        if (hasBoundaryEventInSource) {
            throw new EventSubscriptionMigrationNotSupportedException(elementInstanceRecord.getProcessInstanceKey(), elementInstanceRecord.getElementId(), "active");
        }
        boolean bl3 = hasBoundaryEventInTarget = !targetProcessDefinition.getProcess().getElementById(targetElementId, ExecutableActivity.class).getBoundaryEvents().isEmpty();
        if (hasBoundaryEventInTarget) {
            throw new EventSubscriptionMigrationNotSupportedException(elementInstanceRecord.getProcessInstanceKey(), elementInstanceRecord.getElementId(), "target");
        }
        EventTrigger eventTrigger = this.eventScopeInstanceState.peekEventTrigger(elementInstance.getKey());
        if (eventTrigger != null) {
            throw new ConcurrentCommandException(processInstanceKey);
        }
        if (elementInstance.getActiveSequenceFlows() > 0L) {
            throw new ConcurrentCommandException(processInstanceKey);
        }
        this.stateWriter.appendFollowUpEvent(elementInstance.getKey(), (Intent)ProcessInstanceIntent.ELEMENT_MIGRATED, (RecordValue)elementInstanceRecord.setProcessDefinitionKey(targetProcessDefinition.getKey()).setBpmnProcessId(targetProcessDefinition.getBpmnProcessId()).setVersion(targetProcessDefinition.getVersion()).setElementId(targetElementId));
        if (elementInstance.getJobKey() > 0L && (job = this.jobState.getJob(elementInstance.getJobKey())) != null) {
            this.stateWriter.appendFollowUpEvent(elementInstance.getJobKey(), (Intent)JobIntent.MIGRATED, (RecordValue)job.setProcessDefinitionKey(targetProcessDefinition.getKey()).setProcessDefinitionVersion(targetProcessDefinition.getVersion()).setBpmnProcessId(targetProcessDefinition.getBpmnProcessId()).setElementId(targetElementId));
        }
        this.variableState.getVariablesLocal(elementInstance.getKey()).forEach(variable -> this.stateWriter.appendFollowUpEvent(variable.key(), (Intent)VariableIntent.MIGRATED, (RecordValue)this.variableRecord.setScopeKey(elementInstance.getKey()).setName(variable.name()).setProcessInstanceKey(elementInstance.getValue().getProcessInstanceKey()).setProcessDefinitionKey(targetProcessDefinition.getKey()).setBpmnProcessId(targetProcessDefinition.getBpmnProcessId()).setTenantId(elementInstance.getValue().getTenantId())));
    }

    private static final class ChildProcessMigrationException
    extends RuntimeException {
        ChildProcessMigrationException(long processInstanceKey) {
            super(String.format("Expected to migrate process instance '%s' but process instance is a child process instance. Child process instances cannot be migrated.", processInstanceKey));
        }
    }

    private static final class UnsupportedElementMigrationException
    extends RuntimeException {
        UnsupportedElementMigrationException(long processInstanceKey, String elementId, BpmnElementType bpmnElementType) {
            super(String.format("Expected to migrate process instance '%s' but active element with id '%s' has an unsupported type. The migration of a %s is not supported.", processInstanceKey, elementId, bpmnElementType));
        }
    }

    private static final class UnmappedActiveElementException
    extends RuntimeException {
        UnmappedActiveElementException(long processInstanceKey, String elementId) {
            super(String.format("Expected to migrate process instance '%s' but no mapping instruction defined for active element with id '%s'. Elements cannot be migrated without a mapping.", processInstanceKey, elementId));
        }
    }

    private static final class ElementWithIncidentException
    extends RuntimeException {
        ElementWithIncidentException(long processInstanceKey, String elementId) {
            super(String.format("Expected to migrate process instance '%s' but active element with id '%s' has an incident. Elements cannot be migrated with an incident yet. Please retry migration after resolving the incident.", processInstanceKey, elementId));
        }
    }

    private static final class ElementTypeChangedException
    extends RuntimeException {
        ElementTypeChangedException(long processInstanceKey, String elementId, BpmnElementType bpmnElementType, String targetElementId, BpmnElementType targetBpmnElementType) {
            super(String.format("Expected to migrate process instance '%s' but active element with id '%s' and type '%s' is mapped to an element with id '%s' and different type '%s'. Elements must be mapped to elements of the same type.", processInstanceKey, elementId, bpmnElementType, targetElementId, targetBpmnElementType));
        }
    }

    private static final class ChangedElementFlowScopeException
    extends RuntimeException {
        ChangedElementFlowScopeException(long processInstanceKey, String elementId, String expectedFlowScopeId, String actualFlowScopeId) {
            super(String.format("Expected to migrate process instance '%s' but the flow scope of active element with id '%s' is changed. The flow scope of the active element is expected to be '%s' but was '%s'. The flow scope of an element cannot be changed during migration yet.", processInstanceKey, elementId, expectedFlowScopeId, actualFlowScopeId));
        }
    }

    private static final class EventSubscriptionMigrationNotSupportedException
    extends RuntimeException {
        EventSubscriptionMigrationNotSupportedException(long processInstanceKey, String elementId, String source) {
            super(String.format("Expected to migrate process instance '%s' but %s element with id '%s' has a boundary event. Migrating %s elements with boundary events is not possible yet.", processInstanceKey, source, elementId, source));
        }
    }

    private static final class ConcurrentCommandException
    extends RuntimeException {
        ConcurrentCommandException(long processInstanceKey) {
            super(String.format("Expected to migrate process instance '%s' but a concurrent command was executed on the process instance. Please retry the migration.", processInstanceKey));
        }
    }

    private static final class NonExistingElementException
    extends RuntimeException {
        NonExistingElementException(long processInstanceKey, String elementId, String elementSource) {
            super(String.format("Expected to migrate process instance '%s' but mapping instructions contain a non-existing %s element id '%s'. Elements provided in mapping instructions must exist in the %s process definition.", processInstanceKey, elementSource, elementId, elementSource));
        }
    }
}

