/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.retry;

import io.camunda.zeebe.util.retry.RetryConfiguration;
import io.github.resilience4j.core.IntervalBiFunction;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.core.functions.CheckedRunnable;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(RetryDecorator.class);
    private final RetryConfiguration retryConfiguration;
    private final Predicate<Throwable> retryOnExceptionPredicate;

    public RetryDecorator(RetryConfiguration retryConfiguration, Predicate<Throwable> retryOnExceptionPredicate) {
        this.retryConfiguration = retryConfiguration;
        this.retryOnExceptionPredicate = retryOnExceptionPredicate;
    }

    public RetryDecorator(RetryConfiguration retryConfiguration) {
        this(retryConfiguration, e -> true);
    }

    public RetryDecorator() {
        this(new RetryConfiguration());
    }

    public RetryDecorator withRetryOnException(Predicate<Throwable> retryOnExceptionPredicate) {
        return new RetryDecorator(this.retryConfiguration, retryOnExceptionPredicate);
    }

    public RetryDecorator withRetryOnExceptions(Class<? extends Throwable> ... exceptionClasses) {
        return new RetryDecorator(this.retryConfiguration, e -> {
            for (Class exceptionClass : exceptionClasses) {
                if (!exceptionClass.isAssignableFrom(e.getClass())) continue;
                return true;
            }
            return false;
        });
    }

    public <T> T decorate(String operationName, Callable<T> callable, Predicate<T> retryPredicate) throws Exception {
        Retry retry = this.buildRetry(operationName, retryPredicate);
        return (T)Retry.decorateCallable((Retry)retry, callable).call();
    }

    public void decorate(String operationName, Runnable runnable) {
        Retry retry = this.buildRetry(operationName, null);
        Retry.decorateRunnable((Retry)retry, (Runnable)runnable).run();
    }

    public void decorateCheckedRunnable(String operationName, CheckedRunnable runnable) {
        Retry retry = this.buildRetry(operationName, null);
        Retry.decorateCheckedRunnable((Retry)retry, (CheckedRunnable)runnable).unchecked().run();
    }

    private <T> Retry buildRetry(String operationName, Predicate<T> retryPredicate) {
        RetryConfig.Builder retryConfigBuilder = RetryConfig.custom().maxAttempts(this.retryConfiguration.getMaxRetries()).intervalBiFunction(IntervalBiFunction.ofIntervalFunction((IntervalFunction)IntervalFunction.ofExponentialRandomBackoff((Duration)this.retryConfiguration.getMinRetryDelay(), (double)this.retryConfiguration.getRetryDelayMultiplier(), (Duration)this.retryConfiguration.getMaxRetryDelay()))).retryOnException(this.retryOnExceptionPredicate);
        if (retryPredicate != null) {
            retryConfigBuilder.retryOnResult(retryPredicate);
        }
        RetryConfig config = retryConfigBuilder.build();
        Retry retry = Retry.of((String)UUID.randomUUID().toString(), (RetryConfig)config);
        retry.getEventPublisher().onError(event -> Optional.ofNullable(event.getLastThrowable()).ifPresentOrElse(t -> LOG.error("Retry failed for '{}': {}", (Object)operationName, (Object)t.getMessage()), () -> LOG.error("Retry failed for '{}'", (Object)operationName))).onRetry(event -> Optional.ofNullable(event.getLastThrowable()).ifPresentOrElse(t -> {
            LOG.warn("Retrying operation for '{}': attempt {}. Message: {}.", new Object[]{operationName, event.getNumberOfRetryAttempts(), t.getMessage()});
            LOG.debug("Stacktrace:", t);
        }, () -> LOG.warn("Retrying operation for '{}': attempt {}.", (Object)operationName, (Object)event.getNumberOfRetryAttempts())));
        return retry;
    }
}

