/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.retry;

import java.time.Duration;
import java.util.Optional;

public class RetryConfiguration {
    private static final Duration DEFAULT_MAX_RETRY_DELAY = Duration.ofMillis(30000L);
    private Integer maxRetries;
    private Duration minRetryDelay;
    private Duration maxRetryDelay;
    private Double retryDelayMultiplier;

    public int getMaxRetries() {
        return Optional.ofNullable(this.maxRetries).orElseGet(this::defaultMaxRetries);
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Duration getMinRetryDelay() {
        return Optional.ofNullable(this.minRetryDelay).orElseGet(this::defaultMinRetryDelay);
    }

    public void setMinRetryDelay(Duration minRetryDelay) {
        this.minRetryDelay = minRetryDelay;
    }

    public Duration getMaxRetryDelay() {
        return Optional.ofNullable(this.maxRetryDelay).orElseGet(this::defaultMaxRetryDelay);
    }

    public void setMaxRetryDelay(Duration maxRetryDelay) {
        this.maxRetryDelay = maxRetryDelay;
    }

    public double getRetryDelayMultiplier() {
        return Optional.ofNullable(this.retryDelayMultiplier).orElseGet(this::defaultRetryDelayMultiplier);
    }

    public void setRetryDelayMultiplier(double retryDelayMultiplier) {
        this.retryDelayMultiplier = retryDelayMultiplier;
    }

    protected int defaultMaxRetries() {
        return 3;
    }

    protected Duration defaultMinRetryDelay() {
        return Duration.ofMillis(500L);
    }

    protected Duration defaultMaxRetryDelay() {
        return DEFAULT_MAX_RETRY_DELAY;
    }

    protected double defaultRetryDelayMultiplier() {
        return 1.5;
    }
}

