/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.micrometer;

import io.camunda.zeebe.util.micrometer.StatefulMeterRegistry;
import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.concurrent.atomic.AtomicLong;

public final class StatefulGauge
extends AbstractMeter
implements Gauge {
    private final Gauge delegate;
    private final AtomicLong state;

    public StatefulGauge(Gauge gauge, AtomicLong state) {
        super(gauge.getId());
        this.delegate = gauge;
        this.state = state;
    }

    public void set(long value) {
        this.set((double)value);
    }

    public void set(double value) {
        this.state.set(Double.doubleToLongBits(value));
    }

    public void set(boolean value) {
        this.set(value ? 1.0 : 0.0);
    }

    public long increment() {
        return this.state.updateAndGet(value -> Double.doubleToLongBits(Double.longBitsToDouble(value) + 1.0));
    }

    public long decrement() {
        return this.state.updateAndGet(value -> Double.doubleToLongBits(Double.longBitsToDouble(value) - 1.0));
    }

    public double value() {
        return this.delegate.value();
    }

    AtomicLong state() {
        return this.state;
    }

    Gauge delegate() {
        return this.delegate;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    static StatefulGauge registerAsGauge(Meter.Id id, MeterRegistry registry) {
        AtomicLong state = new AtomicLong();
        Gauge gauge = Gauge.builder((String)id.getName(), (Object)state, StatefulGauge::longAsDouble).description(id.getDescription()).tags((Iterable)id.getTags()).baseUnit(id.getBaseUnit()).register(registry);
        return new StatefulGauge(gauge, state);
    }

    private static double longAsDouble(AtomicLong value) {
        return Double.longBitsToDouble(value.get());
    }

    public static final class Builder {
        private final String name;
        private Tags tags = Tags.empty();
        private String description;
        private String baseUnit;

        private Builder(String name) {
            this.name = name;
        }

        public Builder tags(String ... tags) {
            this.tags = this.tags.and(tags);
            return this;
        }

        public Builder tags(Iterable<Tag> tags) {
            this.tags = this.tags.and(tags);
            return this;
        }

        public Builder tag(String key, String value) {
            this.tags = this.tags.and(key, value);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder baseUnit(String unit) {
            this.baseUnit = unit;
            return this;
        }

        public Meter.MeterProvider<StatefulGauge> withRegistry(MeterRegistry registry) {
            return extraTags -> this.register(registry, this.tags.and(extraTags));
        }

        public StatefulGauge register(MeterRegistry registry) {
            return this.register(registry, this.tags);
        }

        private StatefulGauge register(MeterRegistry registry, Tags tags) {
            Meter.Id id = new Meter.Id(this.name, tags, this.baseUnit, this.description, Meter.Type.GAUGE);
            if (registry instanceof StatefulMeterRegistry) {
                StatefulMeterRegistry s = (StatefulMeterRegistry)registry;
                return s.registerIfNecessary(id);
            }
            return StatefulGauge.registerAsGauge(id, registry);
        }
    }
}

