/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.collection;

import io.camunda.zeebe.util.collection.Table;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

final class MapTable<RowT, ColT, T>
implements Table<RowT, ColT, T> {
    private final Map<RowT, Map<ColT, T>> table = new HashMap<RowT, Map<ColT, T>>();

    MapTable() {
    }

    @Override
    public T get(RowT rowKey, ColT columnKey) {
        Map<ColT, T> row = this.table.get(rowKey);
        if (row == null) {
            return null;
        }
        return row.get(columnKey);
    }

    @Override
    public void put(RowT rowKey, ColT columnKey, T value) {
        this.table.computeIfAbsent(rowKey, ignored -> new HashMap()).put(columnKey, value);
    }

    @Override
    public T computeIfAbsent(RowT rowKey, ColT columnKey, BiFunction<RowT, ColT, T> computer) {
        return (T)this.table.computeIfAbsent(rowKey, ignored -> new HashMap()).computeIfAbsent(columnKey, ignored -> computer.apply(rowKey, columnKey));
    }
}

