/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.collection;

import java.util.Arrays;
import java.util.function.IntFunction;

public final class MArray<T> {
    private final int[] offsets;
    private final T[] items;

    private MArray(int[] offsets, T[] items) {
        this.offsets = offsets;
        this.items = items;
    }

    public static <T> MArray<T> of(IntFunction<T[]> arraySupplier, int ... cardinalities) {
        int[] offsets = new int[cardinalities.length - 1];
        int size = cardinalities[0];
        for (int i = 1; i < cardinalities.length; ++i) {
            offsets[i - 1] = Arrays.stream(cardinalities, i, cardinalities.length).reduce(1, (a, b) -> a * b);
            size *= cardinalities[i];
        }
        return new MArray<T>(offsets, arraySupplier.apply(size));
    }

    public int dimensions() {
        return this.offsets.length + 1;
    }

    public T get(int ... indices) {
        int index = this.mapToIndex(indices);
        return this.items[index];
    }

    public void put(T value, int ... indices) {
        int index = this.mapToIndex(indices);
        this.items[index] = value;
    }

    private int mapToIndex(int ... indices) {
        if (indices.length != this.offsets.length + 1) {
            throw new IllegalArgumentException("Expected to compute the index in a multi-dimensional array with %d dimensions, but received %d dimensions".formatted(this.offsets.length + 1, indices.length));
        }
        int index = 0;
        for (int i = 0; i < indices.length - 1; ++i) {
            index += indices[i] * this.offsets[i];
        }
        return index + indices[indices.length - 1];
    }
}

